/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.lists;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import neiplugins.common.NEIProxyClient;
import neiplugins.lists.GuiList;
import neiplugins.lists.IListElement;
import net.minecraft.item.ItemStack;

public class SimpleListElement
implements IListElement {
    protected String title;
    protected boolean locflag;
    public ArrayList<PositionedStack> stacks;

    public SimpleListElement() {
    }

    public SimpleListElement(String title) {
        this(title, false);
    }

    public SimpleListElement(String title, boolean locflag) {
        this.title = title;
        this.locflag = locflag;
    }

    public SimpleListElement(String title, ItemStack icon, boolean locflag) {
        this(title, locflag);
        if (icon != null) {
            this.stacks = new ArrayList();
            this.stacks.add(new PositionedStack((Object)icon, 2, 2));
        } else {
            this.stacks = null;
        }
    }

    @Override
    public void draw(Dimension size, boolean hovered) {
        GuiDraw.drawStringC((String)this.getTitle(), (int)(size.width / 2), (int)((size.height - 8) / 2), (int)(hovered ? 0xFFFFA0 : 0xE0E0E0), (boolean)true);
    }

    @Override
    public boolean click(int button) {
        return false;
    }

    @Override
    public List<String> handleTooltip(GuiList gui, List<String> currenttip, Point mousepos) {
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiList gui, ItemStack stack, List<String> currenttip, Point mousepos) {
        return currenttip;
    }

    @Override
    public ArrayList<PositionedStack> getStacks() {
        return this.stacks;
    }

    public String getTitle() {
        if (this.locflag) {
            return NEIProxyClient.translateN(this.title, new Object[0]);
        }
        return this.title;
    }
}

