/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.lists;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import neiplugins.common.NEIProxyClient;
import neiplugins.lists.GuiList;
import neiplugins.lists.IListElement;
import net.minecraft.item.ItemStack;

public class ShowGuiListElement
implements IListElement {
    protected String title;
    protected boolean locflag;
    protected ArrayList<IListElement> list;

    public ShowGuiListElement(String title, boolean locflag, ArrayList<IListElement> list) {
        this.title = title;
        this.list = list;
        this.locflag = locflag;
    }

    public ShowGuiListElement(String title, ArrayList<IListElement> list) {
        this(title, false, list);
    }

    @Override
    public void draw(Dimension size, boolean hovered) {
        GuiDraw.drawStringC((String)this.getTitle(), (int)(size.width / 2), (int)((size.height - 8) / 2), (int)(hovered ? 0xFFFFA0 : 0xE0E0E0), (boolean)true);
    }

    @Override
    public boolean click(int button) {
        if (button == 0) {
            NEIClientUtils.playClickSound();
            return GuiList.showList(this.getTitle(), this.list);
        }
        return false;
    }

    @Override
    public List<String> handleTooltip(GuiList gui, List<String> currenttip, Point mousepos) {
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiList gui, ItemStack stack, List<String> currenttip, Point mousepos) {
        return currenttip;
    }

    @Override
    public ArrayList<PositionedStack> getStacks() {
        return null;
    }

    public String getTitle() {
        if (this.locflag) {
            return NEIProxyClient.translateN(this.title, new Object[0]);
        }
        return this.title;
    }
}

