/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.lists;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import neiplugins.lists.GuiList;
import neiplugins.lists.IListElement;
import net.minecraft.item.ItemStack;

public class RecipeHandlerListElement
implements IListElement {
    public String recipeType;
    public int type;
    public String id;
    public Object[] params;
    public ArrayList<PositionedStack> stacks;

    public RecipeHandlerListElement(String recipeType, int type, String id, Object[] params) {
        this(recipeType, null, type, id, params);
    }

    public RecipeHandlerListElement(String recipeType, ItemStack icon, int type, String id, Object[] params) {
        this.recipeType = recipeType;
        this.type = type;
        this.id = id;
        this.params = params;
        if (icon != null) {
            this.stacks = new ArrayList();
            this.stacks.add(new PositionedStack((Object)icon, 2, 2));
        } else {
            this.stacks = null;
        }
    }

    @Override
    public void draw(Dimension size, boolean hovered) {
        GuiDraw.drawStringC((String)this.recipeType, (int)(size.width / 2), (int)((size.height - 8) / 2), (int)(hovered ? 0xFFFFA0 : 0xE0E0E0), (boolean)true);
    }

    @Override
    public boolean click(int button) {
        if (button == 0) {
            NEIClientUtils.playClickSound();
            return this.type == 1 ? GuiUsageRecipe.openRecipeGui((String)this.id, (Object[])this.params) : GuiCraftingRecipe.openRecipeGui((String)this.id, (Object[])this.params);
        }
        return false;
    }

    @Override
    public List<String> handleTooltip(GuiList gui, List<String> currenttip, Point mousePos) {
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiList gui, ItemStack stack, List<String> currenttip, Point mousepos) {
        return currenttip;
    }

    @Override
    public ArrayList<PositionedStack> getStacks() {
        return this.stacks;
    }
}

