/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.lists;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.ContainerRecipe;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import neiplugins.common.NEIProxyClient;
import neiplugins.lists.IActiveListElement;
import neiplugins.lists.IListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiList
extends GuiContainer
implements IGuiContainerOverlay,
IContainerTooltipHandler {
    public int page;
    public ContainerRecipe slotcontainer;
    public GuiContainer firstGui;
    public GuiContainer prevGui;
    public GuiButton nextpage;
    public GuiButton prevpage;
    public String title;
    public Dimension elementSize;
    public ArrayList<? extends IListElement> elements = new ArrayList();
    public int cycleticks = Math.abs((int)System.currentTimeMillis());

    protected GuiList(GuiContainer prevgui, String title, ArrayList<? extends IListElement> list) {
        super((Container)new ContainerRecipe());
        this.slotcontainer = (ContainerRecipe)this.field_147002_h;
        this.prevGui = prevgui;
        this.firstGui = prevgui;
        this.title = title;
        this.elements = list;
        this.elementSize = new Dimension(this.getElementWidth(), this.getElementHeight());
        this.page = 0;
        if (prevgui instanceof IGuiContainerOverlay) {
            this.firstGui = ((IGuiContainerOverlay)prevgui).getFirstScreen();
        }
    }

    public static boolean showList(String title, ArrayList<? extends IListElement> list) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        if (list.isEmpty()) {
            return false;
        }
        mc.func_147108_a((GuiScreen)new GuiList(prevscreen, title, list));
        return true;
    }

    public boolean isClientOnly() {
        return true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.nextpage = new GuiNEIButton(0, this.field_146294_l / 2 - 70, (this.field_146295_m + this.field_147000_g) / 2 - 18, 13, 12, "<");
        this.prevpage = new GuiNEIButton(1, this.field_146294_l / 2 + 57, (this.field_146295_m + this.field_147000_g) / 2 - 18, 13, 12, ">");
        this.field_146292_n.add(this.nextpage);
        this.field_146292_n.add(this.prevpage);
        if (this.elements.size() <= this.elementsPerPage()) {
            this.nextpage.field_146125_m = false;
            this.prevpage.field_146125_m = false;
        }
        if (this.page > (this.elements.size() - 1) / this.elementsPerPage()) {
            this.page = (this.elements.size() - 1) / this.elementsPerPage();
        }
        if (this.page < 0) {
            this.page = 0;
        }
        this.refreshPage();
    }

    public void func_73869_a(char c, int i) {
        if (i == 1) {
            this.firstGui.func_73876_c();
            this.field_146297_k.func_147108_a((GuiScreen)this.firstGui);
            return;
        }
        if (GuiContainerManager.getManager((GuiContainer)this).lastKeyTyped(i, c)) {
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.firstGui.func_73876_c();
            this.field_146297_k.func_147108_a((GuiScreen)this.firstGui);
        } else if (i == NEIClientConfig.getKeyBinding((String)"gui.back")) {
            this.prevGui.func_73876_c();
            this.field_146297_k.func_147108_a((GuiScreen)this.prevGui);
        }
    }

    public int getHoveredPosition() {
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - this.field_147003_i, mousepos.y - this.field_147009_r);
        int pos = (relMouse.y - 16) / this.getElementsOffset();
        if (this.getElementRectangle(pos).contains(relMouse)) {
            return pos;
        }
        return -1;
    }

    public int getHoveredIndex() {
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - this.field_147003_i, mousepos.y - this.field_147009_r);
        int pos = (relMouse.y - 16) / this.getElementsOffset();
        int index = pos + this.page * this.elementsPerPage();
        if (index >= 0 && index < this.elements.size() && this.getElementRectangle(pos).contains(relMouse)) {
            return index;
        }
        return -1;
    }

    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - (this.field_146294_l - this.field_146999_f) / 2, mousepos.y - (this.field_146295_m - this.field_147000_g) / 2);
        int pos = (relMouse.y - 16) / this.getElementsOffset();
        int index = pos + this.page * this.elementsPerPage();
        if (index < 0 || index >= this.elements.size() || !this.getElementRectangle(pos).contains(relMouse)) {
            return currenttip;
        }
        currenttip = this.elements.get(index).handleTooltip(this, currenttip, new Point(relMouse.x - 5 - this.getLeftOffset(), (relMouse.y - 16) % this.getElementsOffset()));
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int mousex, int mousey, List<String> currenttip) {
        Point mousepos = GuiDraw.getMousePosition();
        Point relMouse = new Point(mousepos.x - this.field_147003_i, mousepos.y - this.field_147009_r);
        int pos = (relMouse.y - 16) / this.getElementsOffset();
        int index = pos + this.page * this.elementsPerPage();
        if (index < 0 || index >= this.elements.size() || !this.getElementRectangle(pos).contains(relMouse)) {
            return currenttip;
        }
        currenttip = this.elements.get(index).handleItemTooltip(this, stack, currenttip, new Point(relMouse.x - 5 - this.getLeftOffset(), (relMouse.y - 16) % this.getElementsOffset()));
        return currenttip;
    }

    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        int index = this.getHoveredIndex();
        if (index != -1 && this.elements.get(index).click(par3)) {
            return;
        }
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        switch (guibutton.field_146127_k) {
            case 0: {
                this.prevPage();
                break;
            }
            case 1: {
                this.nextPage();
            }
        }
    }

    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.onUpdate();
        this.refreshPage();
    }

    private void nextPage() {
        ++this.page;
        if (this.page > (this.elements.size() - 1) / this.elementsPerPage()) {
            this.page = 0;
        }
    }

    private void prevPage() {
        --this.page;
        if (this.page < 0) {
            this.page = (this.elements.size() - 1) / this.elementsPerPage();
        }
    }

    public void refreshPage() {
        this.refreshSlots();
    }

    private void refreshSlots() {
        this.slotcontainer.field_75151_b.clear();
        for (int i = this.page * this.elementsPerPage(); i < (this.page + 1) * this.elementsPerPage() && i < this.elements.size(); ++i) {
            Point p = this.getElementPosition(i);
            ArrayList<PositionedStack> stacks = this.getPositionedStacks(i);
            if (stacks == null) continue;
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
        }
    }

    public ArrayList<PositionedStack> getPositionedStacks(int index) {
        return this.getCycledIngredients(this.cycleticks / 20, this.elements.get(index).getStacks());
    }

    public ArrayList<PositionedStack> getCycledIngredients(int cycle, ArrayList<PositionedStack> ingredients) {
        if (ingredients == null) {
            return null;
        }
        for (int itemIndex = 0; itemIndex < ingredients.size(); ++itemIndex) {
            PositionedStack stack = ingredients.get(itemIndex);
            Random rand = new Random(cycle + itemIndex);
            stack.setPermutationToRender(Math.abs(rand.nextInt()) % stack.items.length);
        }
        return ingredients;
    }

    protected void drawForeground(int index, boolean empty, boolean hovered) {
        if (!empty) {
            this.elements.get(index).draw(this.elementSize, hovered);
        }
    }

    protected void drawBackground(int index, boolean empty, boolean hovered) {
        if (!empty) {
            GuiDraw.changeTexture((String)"minecraft:textures/gui/widgets.png");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 46 + (this.isActive(index) ? (hovered ? 40 : 20) : 0), this.getElementWidth() / 2, this.getElementHeight());
            this.func_73729_b(0 + this.getElementWidth() / 2, 0, 200 - this.getElementWidth() / 2, 46 + (this.isActive(index) ? (hovered ? 40 : 20) : 0), this.getElementWidth() / 2, this.getElementHeight());
        }
    }

    protected boolean isActive(int index) {
        if (this.elements.get(index) instanceof IActiveListElement) {
            return ((IActiveListElement)((Object)this.elements.get(index))).isActive();
        }
        return true;
    }

    protected void func_146979_b(int par1, int par2) {
        int pos = this.getHoveredPosition();
        GuiContainerManager.enable2DRender();
        this.field_146289_q.func_78276_b(this.title, (this.field_146999_f - this.field_146289_q.func_78256_a(this.title)) / 2, 5, 0x404040);
        String s = NEIProxyClient.translateN("guilist.prevpagetooltip", new Object[]{Keyboard.getKeyName((int)NEIClientConfig.getKeyBinding((String)"gui.back"))});
        this.field_146289_q.func_78276_b(s, (this.field_146999_f - this.field_146289_q.func_78256_a(s)) / 2, this.field_147000_g - 16 - 13, 0x404040);
        s = NEIProxyClient.translateN("guilist.page", new Object[]{this.page + 1, (this.elements.size() - 1) / this.elementsPerPage() + 1});
        this.field_146289_q.func_78276_b(s, (this.field_146999_f - this.field_146289_q.func_78256_a(s)) / 2, this.field_147000_g - 16, 0x404040);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(5 + this.getLeftOffset()), (float)16.0f, (float)0.0f);
        for (int i = this.page * this.elementsPerPage(); i < (this.page + 1) * this.elementsPerPage(); ++i) {
            this.drawForeground(i, i >= this.elements.size(), i % this.elementsPerPage() == pos);
            GL11.glTranslatef((float)0.0f, (float)this.getElementsOffset(), (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    protected void func_146976_a(float f, int mx, int my) {
        int pos = this.getHoveredPosition();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)"nei:textures/gui/recipebg.png");
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(j + 5 + this.getLeftOffset()), (float)(k + 16), (float)0.0f);
        for (int i = this.page * this.elementsPerPage(); i < (this.page + 1) * this.elementsPerPage(); ++i) {
            this.drawBackground(i, i >= this.elements.size(), i % this.elementsPerPage() == pos);
            GL11.glTranslatef((float)0.0f, (float)this.getElementsOffset(), (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    public int getElementsOffset() {
        return 23;
    }

    public int getLeftOffset() {
        if (this.getElementWidth() > 166) {
            return 0;
        }
        return (166 - this.getElementWidth()) / 2;
    }

    public int getElementHeight() {
        return 20;
    }

    public int getElementWidth() {
        return 140;
    }

    public Point getElementPosition(int pos) {
        return new Point(5 + this.getLeftOffset(), 16 + pos % this.elementsPerPage() * this.getElementsOffset());
    }

    public Rectangle getElementRectangle(int pos) {
        return new Rectangle(this.getElementPosition(pos), this.elementSize);
    }

    public int elementsPerPage() {
        return 120 / this.getElementsOffset();
    }
}

