/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forge;

import codechicken.nei.guihook.IContainerTooltipHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import neiplugins.NEIPlugins;
import neiplugins.common.IOptionUpdateCallback;
import neiplugins.common.NEIProxyClient;
import neiplugins.common.TooltipCache;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryTooltipHandler
implements IContainerTooltipHandler,
IOptionUpdateCallback {
    public static TooltipCache tooltipCache = new TooltipCache(true);
    public static boolean isEnabled = false;

    public List<String> handleTooltipFirst(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        return currenttip;
    }

    public static void resetCache() {
        NEIPlugins.logFine("OreDictionaryTooltipHandler.resetCache() start", new Object[0]);
        tooltipCache.clear();
        Object[] oreNames = OreDictionary.getOreNames();
        Arrays.sort(oreNames);
        for (Object oreName : oreNames) {
            int oreID = OreDictionary.getOreID((String)oreName);
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                if (ore.func_77960_j() == Short.MAX_VALUE) continue;
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltipCache.addCachedTooltip(ore, tooltip);
                tooltip.add("\u00a77" + (String)oreName);
                tooltipCache.put(ore, tooltip);
            }
        }
        NEIPlugins.logFine("OreDictionaryTooltipHandler.resetCache() end", new Object[0]);
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int mousex, int mousey, List<String> currenttip) {
        if (gui == null && !NEIProxyClient.canModifyTooltip()) {
            return currenttip;
        }
        if (stack == null || !isEnabled) {
            return currenttip;
        }
        if (gui != null && tooltipCache.haveWildcardTooltip(stack)) {
            currenttip.add("\u00a77Ore Dictionary names:");
        }
        if (tooltipCache.addCachedWildcardTooltip(stack, currenttip)) {
            return currenttip;
        }
        return currenttip;
    }

    @Override
    public void onOptionUpdate() {
        isEnabled = NEIProxyClient.getBooleanSetting("neiplugins.developer.showOreDictionaryNames", false);
    }

    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        return currenttip;
    }

    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }
}

