/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forge;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import neiplugins.NEIPlugins;
import neiplugins.common.Utils;
import neiplugins.lists.GuiList;
import neiplugins.lists.IListElement;
import neiplugins.lists.MultipleStackListElement;
import neiplugins.lists.SimpleListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class GuiGameChestLootList
extends GuiList {
    public static DecimalFormat chanceFormat = new DecimalFormat("0.##%");

    protected GuiGameChestLootList(GuiContainer prevgui, String title, ArrayList<? extends IListElement> list) {
        super(prevgui, title, list);
    }

    public static HashMap<String, ChestGenHooks> getChestInfo() {
        try {
            Field field = ChestGenHooks.class.getDeclaredField("chestInfo");
            field.setAccessible(true);
            return (HashMap)field.get(null);
        }
        catch (Exception ex) {
            NEIPlugins.logInfo("Failed to get field \"chestInfo\" from class \".minecraftforge.common.ChestGenHooks\": {0}", ex.getMessage());
            return null;
        }
    }

    public static ArrayList<WeightedRandomChestContent> getChestInfoContent(ChestGenHooks obj) {
        try {
            Field field = ChestGenHooks.class.getDeclaredField("contents");
            field.setAccessible(true);
            return (ArrayList)field.get(obj);
        }
        catch (Exception ex) {
            NEIPlugins.logInfo("Failed to get field \"contents\" from class \".minecraftforge.common.ChestGenHooks\": {0}", ex.getMessage());
            return null;
        }
    }

    public static boolean showList(String title) {
        ArrayList<ChestTypeListElement> list = new ArrayList<ChestTypeListElement>();
        for (String chestName : GuiGameChestLootList.getChestInfo().keySet()) {
            list.add(new ChestTypeListElement(chestName));
        }
        if (list.isEmpty()) {
            return false;
        }
        return GuiGameChestLootList.showList(title, list);
    }

    @Override
    protected void drawBackground(int index, boolean empty, boolean hovered) {
    }

    public static boolean showChestGenInfo(String category) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        HashMap<String, ChestGenHooks> chestInfo = GuiGameChestLootList.getChestInfo();
        if (!chestInfo.containsKey(category)) {
            return false;
        }
        ArrayList<WeightedRandomChestContent> content = GuiGameChestLootList.getChestInfoContent(chestInfo.get(category));
        int totalWeight = WeightedRandom.func_76272_a(content);
        Iterator<WeightedRandomChestContent> stacks = content.iterator();
        ArrayList<ChestContentsListElement> list = new ArrayList<ChestContentsListElement>();
        Dimension eSize = new Dimension(140, 16);
        while (stacks.hasNext()) {
            list.add(new ChestContentsListElement(stacks, 4, eSize, totalWeight));
        }
        if (list.isEmpty()) {
            return false;
        }
        mc.func_147108_a((GuiScreen)new GuiGameChestLootList(prevscreen, category, list));
        return true;
    }

    static class ChestContentsListElement
    extends MultipleStackListElement {
        public ArrayList<WeightedRandomChestContent> items;
        public int totalWeight;

        public ChestContentsListElement(Iterator<WeightedRandomChestContent> stacks, int margin, Dimension size, int totalWeight) {
            int pos = 1;
            this.margin = margin;
            this.stacks = new ArrayList();
            this.items = new ArrayList();
            this.totalWeight = totalWeight;
            while (pos + 16 < size.width && stacks.hasNext()) {
                WeightedRandomChestContent i = stacks.next();
                if (i.field_76297_b == null || !Utils.isSafeItemStack(i.field_76297_b)) continue;
                this.stacks.add(new PositionedStack((Object)i.field_76297_b, pos, 1));
                this.items.add(i);
                pos += 16 + margin;
            }
        }

        @Override
        protected List<String> handleItemTooltip(GuiList gui, int index, List<String> currenttip, Point mousePos) {
            WeightedRandomChestContent i = this.items.get(index);
            currenttip.add("Chance: " + chanceFormat.format(1.0f * (float)i.field_76292_a / (float)this.totalWeight));
            if (i.field_76295_d == i.field_76296_e) {
                currenttip.add(String.format("Amount: %d", i.field_76295_d));
            } else {
                currenttip.add(String.format("Amount: %d-%d", i.field_76295_d, i.field_76296_e));
            }
            return currenttip;
        }
    }

    static class ChestTypeListElement
    extends SimpleListElement {
        ChestTypeListElement(String title) {
            super(title);
        }

        @Override
        public boolean click(int button) {
            if (button == 0) {
                NEIClientUtils.playClickSound();
                return GuiGameChestLootList.showChestGenInfo(this.title);
            }
            return false;
        }
    }
}

