/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forge;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.ICachedRecipeWithLiquidTank;
import neiplugins.common.LiquidHelper;
import neiplugins.common.LiquidTank;
import neiplugins.common.LiquidTemplateRecipeHandler;
import neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidRegistryList
extends LiquidTemplateRecipeHandler {
    static Rectangle liquidTank = new Rectangle(22, 8, 48, 47);

    public String getRecipeName() {
        return "Fluid Registry";
    }

    @Override
    public String getRecipeId() {
        return "forge.liquiddictionary";
    }

    public String getGuiTexture() {
        return "neiplugins:gfx/FluidRegistryList.png";
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawStringC((String)((CachedFluidRegistryEntry)this.arecipes.get((int)recipe)).name, (int)85, (int)9, (int)-8355712, (boolean)false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (ingredient.getFluid().getID() != fluid.getID()) continue;
            this.arecipes.add(new CachedFluidRegistryEntry(fluid));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            this.arecipes.add(new CachedFluidRegistryEntry(fluid));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        if (t != null) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (t.getFluid().getID() != fluid.getID()) continue;
                this.arecipes.add(new CachedFluidRegistryEntry(fluid));
            }
            return;
        }
    }

    public class FluidRegistryTank
    extends LiquidTank {
        public FluidRegistryTank(Fluid fluid, int capacity, Rectangle position) {
            super(fluid, capacity, position);
        }

        @Override
        public List<String> additionalHandleTooltip(List<String> currenttip) {
            currenttip.add("\u00a73Fluid name: " + this.liquid.getFluid().getName());
            currenttip.add("\u00a73Fluid density: " + Integer.toString(this.liquid.getFluid().getDensity()));
            currenttip.add("\u00a73Fluid luminosity: " + Integer.toString(this.liquid.getFluid().getLuminosity()));
            currenttip.add("\u00a73Fluid temperature: " + Integer.toString(this.liquid.getFluid().getTemperature()));
            currenttip.add("\u00a73Fluid viscosity: " + Integer.toString(this.liquid.getFluid().getViscosity()));
            if (Utils.getBooleanSetting("neiplugins.fueltooltip.showTooltipInFluidRegistry")) {
                ArrayList<String> fuelTooltip = new ArrayList<String>();
                FuelTooltip.addFluidStackFuelTooltip(fuelTooltip, this.liquid, FuelTooltip.disabledHelpers);
                if (fuelTooltip != null && fuelTooltip.size() > 0) {
                    currenttip.add("\u00a77Can produce (per bucket):");
                    currenttip.addAll(fuelTooltip);
                }
            }
            return currenttip;
        }
    }

    public class CachedFluidRegistryEntry
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        FluidRegistryTank tank;
        PositionedStack liquidInput;
        PositionedStack liquidOutput;
        String name;

        public CachedFluidRegistryEntry(Fluid liquid) {
            super((TemplateRecipeHandler)FluidRegistryList.this);
            this.tank = new FluidRegistryTank(liquid, 1000, liquidTank);
            this.tank.liquid.amount = 1000;
            this.tank.showAmount = false;
            this.tank.showCapacity = false;
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.tank.liquid, 104, 6, 104, 42);
            this.liquidInput = output_cont[0];
            this.liquidOutput = output_cont[1];
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.liquidInput != null && this.liquidOutput != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(FluidRegistryList.this.cycleticks / 20, this.liquidInput));
                stacks.add(LiquidHelper.getSeqCycledStack(FluidRegistryList.this.cycleticks / 20, this.liquidOutput));
            }
            return stacks;
        }

        public boolean sameLiquid(FluidStack liquid) {
            return LiquidHelper.areSameLiquid(this.tank.liquid, liquid);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.tank);
            return res;
        }
    }
}

