/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forestry;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.factory.gadgets.MachineStill;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import neiplugins.common.ICachedRecipeWithLiquidTank;
import neiplugins.common.LiquidHelper;
import neiplugins.common.LiquidTank;
import neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class StillRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 4, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 4, 16, 58);
    static Point overlayTank = new Point(176, 0);
    public static Class<? extends GuiContainer> guiclass;

    @Override
    public String getRecipeId() {
        return "forestry.still";
    }

    public String getRecipeName() {
        return "Still";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 6, 15, 15), this.getRecipeId(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    public ArrayList<MachineStill.Recipe> getRecipes() {
        return MachineStill.RecipeManager.recipes;
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (MachineStill.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(result, irecipe.output)) continue;
            this.arecipes.add(new CachedStillRecipe(irecipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (MachineStill.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(ingredient, irecipe.input)) continue;
            this.arecipes.add(new CachedStillRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineStill.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedStillRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack t = LiquidHelper.getFluidStack(result);
        if (t != null) {
            for (MachineStill.Recipe irecipe : this.getRecipes()) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe).replaceMetaOnBottlerSlots(result));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        if (t != null) {
            for (MachineStill.Recipe irecipe : this.getRecipes()) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.input)) continue;
                CachedStillRecipe recipe = new CachedStillRecipe(irecipe);
                this.setIngredientPermutationNBT(recipe.slot_input, ingredient);
                this.arecipes.add(recipe);
            }
        }
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/still.png";
    }

    public class CachedStillRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        int timePerUnit;
        ArrayList<PositionedStack> slot_input;
        PositionedStack slot_output;
        PositionedStack slot_can;
        LiquidTank input;
        LiquidTank output;

        public CachedStillRecipe(MachineStill.Recipe recipe) {
            super((TemplateRecipeHandler)StillRecipeHandler.this);
            this.input = new LiquidTank(recipe.input, 10000, inputTank, overlayTank);
            this.output = new LiquidTank(recipe.output, 10000, outputTank, overlayTank);
            int multiply = 1;
            if (this.input.liquid.amount < 1000 && this.output.liquid.amount < 1000) {
                multiply = (int)Math.ceil(1000.0f / (float)this.input.liquid.amount);
            }
            this.input.liquid.amount *= multiply;
            this.output.liquid.amount *= multiply;
            this.timePerUnit = recipe.timePerUnit;
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.input.liquid, 15, 25, 5, 25);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.output.liquid, 145, 7, 145, 43);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
            this.slot_can = output_cont[0];
            this.slot_output = output_cont[1];
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(StillRecipeHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(StillRecipeHandler.this.cycleticks / 20, this.slot_output);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(StillRecipeHandler.this.cycleticks / 20, this.slot_can));
            }
            return stacks;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedStillRecipe replaceMetaOnBottlerSlots(ItemStack ingredient) {
            if (this.slot_output.items.length == 1 && this.slot_can == null) {
                return this;
            }
            for (int i = 0; i < this.slot_output.items.length; ++i) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)this.slot_output.items[i])) continue;
                this.slot_output.item = this.slot_output.items[i];
                this.slot_output.item.func_77964_b(ingredient.func_77960_j());
                this.slot_output.items = new ItemStack[]{this.slot_output.item};
                this.slot_output.setPermutationToRender(0);
                this.slot_can.item = this.slot_can.items[i];
                this.slot_can.items = new ItemStack[]{this.slot_can.item};
                this.slot_can.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

