/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forestry;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import java.util.HashMap;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelContextHelper;
import neiplugins.common.SimpleFuelHelper;
import neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ForestryFuelHelper {
    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("forestry.copperengine", "Peat-fired Engine", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                EngineCopperFuel copperFuel = (EngineCopperFuel)FuelManager.copperEngineFuel.get(stack);
                if (copperFuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValue(copperFuel.powerPerCycle * copperFuel.burnDuration) + " MJ (Peat-fired Engine)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("forestry.bronzeengine", "Biogas Engine", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                EngineBronzeFuel bronzeFuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(liquid);
                if (bronzeFuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValue(bronzeFuel.powerPerCycle * bronzeFuel.burnDuration * liquid.amount / 1000) + " MJ (Biogas Engine)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("forestry.generator", "Bio Generator", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                GeneratorFuel generatorFuel = (GeneratorFuel)GeneratorFuel.fuels.get(liquid.fluidID);
                if (generatorFuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValueF(liquid.amount * generatorFuel.eu * generatorFuel.rate / generatorFuel.fuelConsumed.amount) + " EU (Bio Generator)");
                }
                return currenttip;
            }
        });
        HashMap<Class, String> map = new HashMap<Class, String>();
        Class cls = Utils.findClass("forestry.energy.gui.GuiEngineCopper");
        if (cls != null) {
            map.put(cls, "forestry.copperengine");
        }
        if ((cls = Utils.findClass("forestry.energy.gui.GuiEngineBronze")) != null) {
            map.put(cls, "forestry.bronzeengine");
        }
        if ((cls = Utils.findClass("forestry.energy.gui.GuiGenerator")) != null) {
            map.put(cls, "forestry.generator");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("forestry.all", "Forestry", null, map));
        }
    }
}

