/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forestry;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IVariableFermentable;
import forestry.factory.gadgets.MachineFermenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import neiplugins.common.ICachedRecipeWithLiquidTank;
import neiplugins.common.LiquidHelper;
import neiplugins.common.LiquidTank;
import neiplugins.common.NEIProxyClient;
import neiplugins.common.Utils;
import neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 8, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 8, 16, 58);
    static Point overlayTank = new Point(176, 0);
    protected HashMap<Integer, List<ItemStack>> variableFermentableCache;
    public static ArrayList<ItemStack> fuels;
    public static Class<? extends GuiContainer> guiclass;

    @Override
    public String getRecipeId() {
        return "forestry.fermenter";
    }

    public String getRecipeName() {
        return "Fermenter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 31, 14, 12), this.getRecipeId(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    protected List<ItemStack> getVariableFermentableCache(ItemStack itemStack) {
        List<ItemStack> result;
        Integer key;
        if (this.variableFermentableCache == null) {
            this.variableFermentableCache = new HashMap();
        }
        if (!this.variableFermentableCache.containsKey(key = Integer.valueOf(Utils.itemStackToInt(itemStack)))) {
            this.variableFermentableCache.put(key, NEIProxyClient.getListOfNBTBasedItems(itemStack));
        }
        if ((result = this.variableFermentableCache.get(key)) == null) {
            result = new ArrayList<ItemStack>();
            result.add(itemStack);
        }
        return result;
    }

    public ArrayList<MachineFermenter.Recipe> getRecipes() {
        return MachineFermenter.RecipeManager.recipes;
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.output, result)) continue;
            if (irecipe.resource.func_77973_b() instanceof IVariableFermentable) {
                for (ItemStack t : this.getVariableFermentableCache(irecipe.resource)) {
                    this.arecipes.add(new CachedFermenterRecipe(irecipe, t));
                }
                continue;
            }
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.liquid, ingredient)) continue;
            if (irecipe.resource.func_77973_b() instanceof IVariableFermentable) {
                for (ItemStack t : this.getVariableFermentableCache(irecipe.resource)) {
                    this.arecipes.add(new CachedFermenterRecipe(irecipe, t));
                }
                continue;
            }
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (irecipe.resource.func_77973_b() instanceof IVariableFermentable) {
                for (ItemStack t : this.getVariableFermentableCache(irecipe.resource)) {
                    this.arecipes.add(new CachedFermenterRecipe(irecipe, t));
                }
                continue;
            }
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack t = LiquidHelper.getFluidStack(result);
        if (t != null) {
            for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
                if (!LiquidHelper.areSameLiquid(irecipe.output, t)) continue;
                if (irecipe.resource.func_77973_b() instanceof IVariableFermentable) {
                    for (ItemStack tt : this.getVariableFermentableCache(irecipe.resource)) {
                        this.arecipes.add(new CachedFermenterRecipe(irecipe, tt));
                    }
                    continue;
                }
                this.arecipes.add(new CachedFermenterRecipe(irecipe));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (LiquidHelper.areSameLiquid(irecipe.liquid, t)) {
                CachedFermenterRecipe recipe = new CachedFermenterRecipe(irecipe);
                recipe.setStacksPermutation(ingredient);
                this.arecipes.add(recipe);
                continue;
            }
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.resource, (ItemStack)ingredient)) continue;
            if (ingredient.func_77973_b() instanceof IVariableFermentable) {
                this.arecipes.add(new CachedFermenterRecipe(irecipe, ingredient));
                continue;
            }
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/fermenter.png";
    }

    public static void loadFuels() {
        fuels = new ArrayList();
        for (FermenterFuel fuel : FuelManager.fermenterFuel.values()) {
            fuels.add(fuel.item);
        }
    }

    public class CachedFermenterRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        PositionedStack slot_resource;
        PositionedStack slot_can_output;
        PositionedStack slot_can_input;
        PositionedStack slot_input;
        LiquidTank input;
        LiquidTank output;

        public CachedFermenterRecipe(MachineFermenter.Recipe recipe) {
            this(recipe, null);
        }

        public CachedFermenterRecipe(MachineFermenter.Recipe recipe, ItemStack variableFermentable) {
            super((TemplateRecipeHandler)FermenterRecipeHandler.this);
            this.input = new LiquidTank(recipe.liquid, 10000, inputTank, overlayTank);
            this.output = new LiquidTank(recipe.output, 10000, outputTank, overlayTank);
            this.input.liquid.amount = recipe.fermentationValue;
            if (this.output.liquid != null) {
                this.output.liquid.amount = variableFermentable != null && variableFermentable.func_77973_b() instanceof IVariableFermentable ? Math.round((float)recipe.fermentationValue * recipe.modifier * ((IVariableFermentable)variableFermentable.func_77973_b()).getFermentationModifier(variableFermentable)) : Math.round((float)recipe.fermentationValue * recipe.modifier);
            }
            this.slot_resource = new PositionedStack((Object)(variableFermentable != null ? variableFermentable : recipe.resource), 80, 12);
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.input.liquid, 25, 29, 5, 29);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.output.liquid, 145, 11, 145, 47);
            this.slot_input = input_cont[1];
            this.slot_can_input = output_cont[0];
            this.slot_can_output = output_cont[1];
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            if (this.slot_resource != null) {
                cycledstacks.add(this.slot_resource);
            }
            if (this.slot_input != null) {
                cycledstacks.add(this.slot_input);
            }
            return this.getCycledIngredients(FermenterRecipeHandler.this.cycleticks / 20, cycledstacks);
        }

        public void setStacksPermutation(ItemStack ingredient) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_resource != null) {
                stacks.add(this.slot_resource);
            }
            if (this.slot_input != null) {
                stacks.add(this.slot_input);
            }
            FermenterRecipeHandler.this.setIngredientPermutationNBT(stacks, ingredient);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_output);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can_input != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_input));
            }
            if (fuels != null && fuels.size() > 0) {
                stacks.add(new PositionedStack((Object)fuels.get(FermenterRecipeHandler.this.cycleticks / 40 % fuels.size()), 70, 46));
            }
            return stacks;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedFermenterRecipe replaceMetaOnBottlerSlots(ItemStack ingredient) {
            if (this.slot_can_output.items.length == 1 && this.slot_can_input == null) {
                return this;
            }
            for (int i = 0; i < this.slot_can_output.items.length; ++i) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)this.slot_can_output.items[i])) continue;
                this.slot_can_output.item = this.slot_can_output.items[i];
                this.slot_can_output.item.func_77964_b(ingredient.func_77960_j());
                this.slot_can_output.items = new ItemStack[]{this.slot_can_output.item};
                this.slot_can_output.setPermutationToRender(0);
                this.slot_can_input.item = this.slot_can_input.items[i];
                this.slot_can_input.items = new ItemStack[]{this.slot_can_input.item};
                this.slot_can_input.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

