/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forestry;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.factory.gadgets.MachineFabricator;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import neiplugins.common.ICachedRecipeWithLiquidTank;
import neiplugins.common.LiquidHelper;
import neiplugins.common.LiquidTank;
import neiplugins.common.Utils;
import neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(21, 37, 16, 16);
    public static Class<? extends GuiContainer> guiclass;
    public static HashMap<Integer, ArrayList<ItemStack>> moltensCacheLiquid;
    public static HashMap<Integer, FluidStack> moltensCacheItemStack;

    @Override
    public String getRecipeId() {
        return "forestry.fabricator";
    }

    public String getRecipeName() {
        return "Thermionic Fabricator";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(117, 44, 14, 13), this.getRecipeId(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    public ArrayList<MachineFabricator.Recipe> getRecipes() {
        return MachineFabricator.RecipeManager.recipes;
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.getLiquid(), ingredient)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedFabricatorRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            if (!Utils.areStacksSameTypeCrafting(irecipe.asIRecipe().func_77571_b(), result)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = this.getMoltenLiquidFromItemStack(ingredient);
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            CachedFabricatorRecipe recipe;
            if (this.containsIngredient(irecipe.asIRecipe(), ingredient) || Utils.areStacksSameTypeCrafting(FabricatorRecipeHandler.getPlan(irecipe), ingredient)) {
                recipe = new CachedFabricatorRecipe(irecipe);
                this.setIngredientPermutationNBT(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
                continue;
            }
            if (t == null || !LiquidHelper.areSameLiquid(irecipe.getLiquid(), t)) continue;
            recipe = new CachedFabricatorRecipe(irecipe);
            this.setIngredientPermutationNBT(recipe.moltens, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/fabricator.png";
    }

    protected static ItemStack getPlan(MachineFabricator.Recipe recipe) {
        return recipe.getPlan();
    }

    public static void buildMoltensCache() {
        for (MachineFabricator.Smelting smelting : MachineFabricator.RecipeManager.smeltings) {
            ItemStack resource = smelting.getResource();
            FluidStack liquid = smelting.getProduct();
            int key = Utils.itemStackToInt(resource);
            if (moltensCacheItemStack.containsKey(key)) continue;
            moltensCacheItemStack.put(key, liquid);
            if (!moltensCacheLiquid.containsKey(liquid.fluidID)) {
                moltensCacheLiquid.put(liquid.fluidID, new ArrayList());
            }
            ArrayList<ItemStack> t = moltensCacheLiquid.get(liquid.fluidID);
            t.add(resource);
        }
    }

    public ArrayList<ItemStack> getMoltensFromLiquid(FluidStack liquid) {
        if (liquid == null || liquid.amount <= 0) {
            return null;
        }
        if (moltensCacheLiquid.containsKey(liquid.fluidID)) {
            return moltensCacheLiquid.get(liquid.fluidID);
        }
        return null;
    }

    public FluidStack getMoltenLiquidFromItemStack(ItemStack stack) {
        int key = Utils.itemStackToInt(stack);
        if (key != 0) {
            return moltensCacheItemStack.get(key);
        }
        return null;
    }

    static {
        moltensCacheLiquid = new HashMap();
        moltensCacheItemStack = new HashMap();
    }

    public class CachedFabricatorRecipe
    extends ForestryRecipeHandler.CachedShapedRecipeCustom
    implements ICachedRecipeWithLiquidTank {
        public ArrayList<PositionedStack> moltens;
        public LiquidTank input;

        public CachedFabricatorRecipe(MachineFabricator.Recipe recipe) {
            ItemStack plan;
            super(FabricatorRecipeHandler.this);
            this.xoffset = 62;
            this.yoffset = 6;
            this.xproduct = 134;
            this.yproduct = 42;
            this.ingredients = new ArrayList();
            this.setIngredients((IDescriptiveRecipe)recipe.asIRecipe());
            this.input = new LiquidTank(recipe.getLiquid(), 2000, inputTank);
            this.moltens = new ArrayList();
            ArrayList<ItemStack> moltenItems = FabricatorRecipeHandler.this.getMoltensFromLiquid(this.input.liquid);
            if (moltenItems.size() > 0) {
                this.moltens.add(new PositionedStack(moltenItems, 21, 10));
            }
            if ((plan = FabricatorRecipeHandler.getPlan(recipe)) != null) {
                this.ingredients.add(new PositionedStack((Object)plan, 134, 6));
            }
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            return res;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(FabricatorRecipeHandler.this.cycleticks / 20, this.moltens);
        }
    }
}

