/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.forestry;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.factory.gadgets.MachineCentrifuge;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neiplugins.common.PositionedStackWithTooltip;
import neiplugins.common.Utils;
import neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class CentrifugeRecipeHandler
extends ForestryRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    public static Class<? extends GuiContainer> guiclass;

    @Override
    public String getRecipeId() {
        return "forestry.centrifuge";
    }

    public String getRecipeName() {
        return "Centrifuge";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(49, 8, 20, 52), this.getRecipeId(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    public ArrayList<MachineCentrifuge.Recipe> getRecipes() {
        return MachineCentrifuge.RecipeManager.recipes;
    }

    public boolean canProduce(MachineCentrifuge.Recipe recipe, ItemStack result) {
        for (ItemStack stack : recipe.products.keySet()) {
            if (!Utils.areStacksSameTypeCrafting(stack, result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineCentrifuge.Recipe irecipe : this.getRecipes()) {
            if (irecipe.products.size() <= 0) continue;
            this.arecipes.add(new CachedCentrifugeRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineCentrifuge.Recipe irecipe : this.getRecipes()) {
            if (!this.canProduce(irecipe, result)) continue;
            this.arecipes.add(new CachedCentrifugeRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MachineCentrifuge.Recipe irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.resource, (ItemStack)ingredient) || irecipe.products.size() <= 0) continue;
            CachedCentrifugeRecipe recipe = new CachedCentrifugeRecipe(irecipe);
            this.setIngredientPermutationNBT(recipe.resources, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(57, 25, 176, 0, 4, 17, ((CachedCentrifugeRecipe)((Object)this.arecipes.get((int)recipe))).timePerItem * 5, 3);
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/centrifuge.png";
    }

    public class CachedCentrifugeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList<PositionedStack> products;
        ArrayList<PositionedStack> resources;
        int timePerItem;

        public CachedCentrifugeRecipe(MachineCentrifuge.Recipe recipe) {
            super((TemplateRecipeHandler)CentrifugeRecipeHandler.this);
            this.resources = new ArrayList();
            this.resources.add(new PositionedStack((Object)recipe.resource, 29, 26));
            this.timePerItem = recipe.timePerItem;
            this.setProducts(recipe.products);
        }

        public void setProducts(HashMap<ItemStack, Integer> iproducts) {
            this.products = new ArrayList();
            int i = 0;
            for (Map.Entry<ItemStack, Integer> product : iproducts.entrySet()) {
                if (i > 8) break;
                PositionedStackWithTooltip stack = new PositionedStackWithTooltip(product.getKey().func_77946_l(), 93 + stackorder[i][0] * 18, 8 + stackorder[i][1] * 18);
                stack.setIntegerChanceTooltip(product.getValue());
                this.products.add(stack);
                ++i;
            }
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            for (int i = 1; i < this.products.size(); ++i) {
                stacks.add(this.products.get(i));
            }
            return stacks;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CentrifugeRecipeHandler.this.cycleticks / 20, this.resources);
        }

        public PositionedStack getResult() {
            return this.products.get(0);
        }
    }
}

