/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.enderio;

import buildcraft.api.fuels.IronEngineFuel;
import java.util.HashMap;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelContextHelper;
import neiplugins.common.SimpleFuelHelper;
import neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class EnderIOFuelHelper {
    public static float stirlingMJPerTick = 0.0f;
    public static double zombieMJPerTick = 0.0;
    public static float zombieTicksPerBucket = 0.0f;
    public static Fluid nutrientDistillation = null;
    public static String powerUnit = " RF ";
    public static int powerMultiplier = 10;

    public static void registerFuelHelpers() {
        boolean useRF = true;
        Class cls = Utils.findClass("crazypants.enderio.config.Config");
        if (cls != null) {
            if (Utils.getField(cls, "useRfAsDefault", null) == null) {
                return;
            }
            useRF = (Boolean)Utils.getField(cls, "useRfAsDefault", null);
            if (!useRF) {
                powerUnit = " MJ ";
                powerMultiplier = 1;
            }
            zombieMJPerTick = (Double)Utils.getField(cls, "zombieGeneratorMjPerTick", null);
            zombieTicksPerBucket = ((Integer)Utils.getField(cls, "zombieGeneratorTicksPerBucketFuel", null)).intValue();
        }
        if ((cls = Utils.findClass("crazypants.enderio.EnderIO")) != null) {
            nutrientDistillation = (Fluid)Utils.getField(cls, "fluidNutrientDistillation", null);
        }
        if ((cls = Utils.findClass("crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator")) != null) {
            stirlingMJPerTick = ((Float)Utils.getField(cls, "ENERGY_PER_TICK", null)).floatValue();
        }
        if (stirlingMJPerTick > 0.0f) {
            FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("enderio.GenStirling", "Stirling Generator", null){

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    int fuelValue = Math.round((float)TileEntityFurnace.func_145952_a((ItemStack)stack) * stirlingMJPerTick * (float)powerMultiplier);
                    if (fuelValue > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + powerUnit + "(Stirling Generator)");
                    }
                    return currenttip;
                }
            });
        }
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("enderio.GenCombustion", "Combustion Generator", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                int fuelValue;
                IronEngineFuel.Fuel fuel = IronEngineFuel.getFuelForFluid((Fluid)liquid.getFluid());
                if (fuel != null && (fuelValue = Math.round(fuel.powerPerCycle * (float)fuel.totalBurningTime * ((float)liquid.amount / 1000.0f) * (float)powerMultiplier)) > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + powerUnit + "(Combustion Generator)");
                }
                return currenttip;
            }
        });
        if (zombieMJPerTick > 0.0 && zombieTicksPerBucket > 0.0f && nutrientDistillation != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("enderio.GenZombie", "Zombie Generator", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    int fuelValue;
                    if (liquid.getFluid() != null && liquid.getFluid() == nutrientDistillation && (fuelValue = (int)Math.round((double)(zombieTicksPerBucket * ((float)liquid.amount / 1000.0f)) * zombieMJPerTick * (double)powerMultiplier)) > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + powerUnit + "(Zombie Generator)");
                    }
                    return currenttip;
                }
            });
        }
        HashMap<Class, String> map = new HashMap<Class, String>();
        cls = Utils.findClass("crazypants.enderio.machine.generator.stirling.GuiStirlingGenerator");
        if (cls != null) {
            map.put(cls, "enderio.GenStirling");
        }
        if ((cls = Utils.findClass("crazypants.enderio.machine.generator.combustion.GuiCombustionGenerator")) != null) {
            map.put(cls, "enderio.GenCombustion");
        }
        if ((cls = Utils.findClass("crazypants.enderio.machine.generator.zombie.GuiZombieGenerator")) != null) {
            map.put(cls, "enderio.GenZombie");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("enderio.GenAll", "Ender IO", null, map));
        }
    }
}

