/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.common;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import neiplugins.NEIPlugins;
import neiplugins.common.ICachedRecipeWithLiquidTank;
import neiplugins.common.IPositionedStackWithTooltipHandler;
import neiplugins.common.LiquidTank;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class LiquidTemplateRecipeHandler
extends TemplateRecipeHandler {
    public abstract String getRecipeId();

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public void loadCraftingRecipes(FluidStack result) {
    }

    public void loadUsageRecipes(FluidStack ingredient) {
    }

    public void loadSameRecipeId() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        try {
            if (outputId.equals(this.getRecipeId())) {
                this.loadSameRecipeId();
            } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof FluidStack) {
                this.loadCraftingRecipes((FluidStack)results[0]);
            } else {
                super.loadCraftingRecipes(outputId, results);
            }
        }
        catch (Throwable ex) {
            NEIPlugins.logWarningEx("Error occured while calling LiquidTemplateRecipeHandler.loadCraftingRecipes for recipeId: {0}", ex, this.getRecipeId());
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        try {
            if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
                this.loadUsageRecipes((FluidStack)ingredients[0]);
            } else {
                super.loadUsageRecipes(inputId, ingredients);
            }
        }
        catch (Throwable ex) {
            NEIPlugins.logWarningEx("Error occured while calling LiquidTemplateRecipeHandler.loadUsageRecipes for recipeId: {0}", ex, this.getRecipeId());
        }
    }

    public void setIngredientPermutationNBT(Collection<PositionedStack> ingredients, ItemStack ingredient) {
        block0: for (PositionedStack stack : ingredients) {
            for (int i = 0; i < stack.items.length; ++i) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)stack.items[i])) continue;
                stack.item = stack.items[i];
                stack.item.func_77964_b(ingredient.func_77960_j());
                if (stack.item.func_77942_o()) {
                    stack.item.func_77982_d((NBTTagCompound)ingredient.func_77978_p().func_74737_b());
                }
                stack.items = new ItemStack[]{stack.item};
                stack.setPermutationToRender(0);
                continue block0;
            }
        }
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawExtras(recipe);
        this.drawLiquidTanks(recipe);
    }

    public void drawLiquidTanks(int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(this.getGuiTexture());
            }
        }
    }

    protected boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mousepos.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid == null || tank.liquid.amount <= 0) continue;
                if (usage ? !GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : !GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid})) break;
                return true;
            }
        }
        return false;
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe) && crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mousepos.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public Rectangle getRectangleFromPositionedStack(PositionedStack stack) {
        return new Rectangle(stack.relx - 1, stack.rely - 1, 18, 18);
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack itemStack, List<String> currenttip, int recipe) {
        TemplateRecipeHandler.CachedRecipe irecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        Point mousepos = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - (gui.field_146294_l - 176) / 2 - offset.x, mousepos.y - (gui.field_146295_m - 166) / 2 - offset.y);
        for (PositionedStack stack : irecipe.getIngredients()) {
            if (!(stack instanceof IPositionedStackWithTooltipHandler) || !this.getRectangleFromPositionedStack(stack).contains(relMouse)) continue;
            currenttip = ((IPositionedStackWithTooltipHandler)stack).handleTooltip(gui, currenttip);
        }
        for (PositionedStack stack : irecipe.getOtherStacks()) {
            if (!(stack instanceof IPositionedStackWithTooltipHandler) || !this.getRectangleFromPositionedStack(stack).contains(relMouse)) continue;
            currenttip = ((IPositionedStackWithTooltipHandler)stack).handleTooltip(gui, currenttip);
        }
        PositionedStack stack = irecipe.getResult();
        if (stack instanceof IPositionedStackWithTooltipHandler && this.getRectangleFromPositionedStack(stack).contains(relMouse)) {
            currenttip = ((IPositionedStackWithTooltipHandler)stack).handleTooltip(gui, currenttip);
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }
}

