/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.common;

import codechicken.lib.gui.GuiDraw;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.List;
import neiplugins.common.LiquidHelper;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LiquidTank {
    public FluidStack liquid;
    public Rectangle position;
    public Point overlay;
    public int capacity;
    public boolean showCapacity = true;
    public boolean showAmount = true;
    public boolean showMillBuckets = false;
    public String overrideTitle = null;
    public boolean ignoreCapacity = false;
    public Rectangle frameSource;
    public Point framePos;
    public static DecimalFormat liquidAmountFormat = new DecimalFormat("0.000");

    public LiquidTank(FluidStack fluidStack, int capacity, Rectangle position, Point overlay) {
        this.liquid = fluidStack != null ? fluidStack.copy() : null;
        this.capacity = capacity;
        this.position = position;
        this.overlay = overlay;
    }

    public LiquidTank(FluidStack fluidStack, int capacity, Rectangle position) {
        this(fluidStack, capacity, position, null);
    }

    public LiquidTank(Fluid fluid, int capacity, Rectangle position, Point overlay) {
        this(new FluidStack(fluid, capacity), capacity, position, overlay);
        this.showAmount = false;
    }

    public LiquidTank(Fluid fluid, int capacity, Rectangle position) {
        this(new FluidStack(fluid, capacity), capacity, position, null);
        this.showAmount = false;
    }

    public void draw(String guiTexture) {
        this.drawLiquidTank(this.position, this.liquid, this.capacity, this.overlay, guiTexture);
    }

    public String amountToString(int amount) {
        if (this.showMillBuckets) {
            return amount + " mB";
        }
        return liquidAmountFormat.format((double)amount * 1.0 / 1000.0);
    }

    public List<String> handleTooltip(List<String> currenttip) {
        if (this.liquid != null) {
            if (this.overrideTitle != null) {
                currenttip.add(this.overrideTitle);
            } else {
                currenttip.add(LiquidHelper.getLiquidName(this.liquid));
            }
            if (this.showAmount) {
                currenttip.add("\u00a77Amount: " + this.amountToString(this.liquid.amount));
            }
            if (this.showCapacity) {
                currenttip.add("\u00a77Capacity: " + this.amountToString(this.capacity));
            }
            this.additionalHandleTooltip(currenttip);
        } else {
            currenttip.add("Empty");
        }
        return currenttip;
    }

    public List<String> additionalHandleTooltip(List<String> currenttip) {
        return currenttip;
    }

    public void drawLiquidTank(Rectangle position, FluidStack liquid, int capacity, Point overlay, String guiTexture) {
        IIcon liquidIcon;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (liquid == null || liquid.amount <= 0) {
            return;
        }
        if (this.framePos != null && this.frameSource != null) {
            GuiDraw.changeTexture((String)guiTexture);
            GuiDraw.gui.func_73729_b(this.framePos.x, this.framePos.y, this.frameSource.x, this.frameSource.y, this.frameSource.width, this.frameSource.height);
        }
        int scale = liquid.amount * position.height / capacity;
        if (liquid.amount > 0 && this.ignoreCapacity || scale > position.height) {
            scale = position.height;
        }
        if ((liquidIcon = LiquidHelper.getFluidTexture(liquid, false)) == null) {
            return;
        }
        GuiDraw.changeTexture((ResourceLocation)LiquidHelper.getFluidSheet(liquid));
        for (int col = 0; col < position.width / 16; ++col) {
            int x;
            int start = 0;
            int s = scale;
            do {
                x = Math.min(s, 16);
                GuiDraw.gui.func_94065_a(position.x + col * 16, position.y + position.height - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && (s -= x) != 0);
        }
        if (position.width % 16 != 0) {
            int x;
            int start = 0;
            int s = scale;
            do {
                x = Math.min(s, 16);
                GuiDraw.gui.func_94065_a(position.x + position.width - position.width % 16, position.y + position.height - x - start, liquidIcon, position.width % 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && (s -= x) != 0);
        }
        if (overlay != null) {
            GuiDraw.changeTexture((String)guiTexture);
            GuiDraw.gui.func_73729_b(position.x, position.y, overlay.x, overlay.y, position.width, position.height);
        }
    }
}

