/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import neiplugins.NEIPlugins;
import neiplugins.common.FirstTickHandler;
import neiplugins.common.RecipeHandlerUtils;
import neiplugins.common.TickHandlerIMCMessages;
import org.apache.logging.log4j.Level;

public class IMCHandler {
    private static TickHandlerIMCMessages handleIMCMessages;
    private static FirstTickHandler firstTickHandler;

    public static void postInit() {
        handleIMCMessages = new TickHandlerIMCMessages();
        handleIMCMessages.reset();
        firstTickHandler = new FirstTickHandler();
        FMLCommonHandler.instance().bus().register((Object)handleIMCMessages);
        FMLCommonHandler.instance().bus().register((Object)firstTickHandler);
    }

    public static void processIMCMessage(FMLInterModComms.IMCMessage message) {
        NEIPlugins.logFine("Accepted IMC message {0} with type {1}", message.key, message.getMessageType().getName());
        if (message.key.equals("register-usage-handler")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 3) {
                NEIPlugins.log(Level.INFO, String.format("Received an invalid 'register-usage-handler' request %s from mod %s", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
            if (!RecipeHandlerUtils.addToRecipeList(tokens[0], tokens[1], 1, tokens[2], new Object[0])) {
                NEIPlugins.log(Level.INFO, String.format("Received 'register-usage-handler' request %s from mod %s for recipe ID that already registred", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
        } else if (message.key.equals("register-crafting-handler")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 3) {
                NEIPlugins.log(Level.INFO, String.format("Received an invalid 'register-crafting-handler' request %s from mod %s", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
            if (!RecipeHandlerUtils.addToRecipeList(tokens[0], tokens[1], 0, tokens[2], new Object[0])) {
                NEIPlugins.log(Level.INFO, String.format("Received 'register-crafting-handler' request %s from mod %s for recipe ID that already registred", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
        }
    }
}

