/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.common;

import codechicken.nei.guihook.IContainerTooltipHandler;
import java.util.ArrayList;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.IFuelContextHelper;
import neiplugins.common.IFuelContextHelper2;
import neiplugins.common.NEIProxyClient;
import neiplugins.common.TooltipCache;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class FuelTooltipHandler
implements IContainerTooltipHandler {
    public static TooltipCache tooltipCache = new TooltipCache();

    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        if (FuelTooltip.showContextTooltip && gui != null) {
            for (IFuelContextHelper helper : FuelTooltip.contextHelpers.values()) {
                if (!(helper instanceof IFuelContextHelper2) || FuelTooltip.disabledContextHelpers.contains(helper.getKey()) || !helper.haveContextTooltip(gui)) continue;
                currenttip = ((IFuelContextHelper2)helper).getGuiContextTooltip(gui, mousex, mousey, currenttip);
            }
        }
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int mousex, int mousey, List<String> currenttip) {
        if (gui == null && !NEIProxyClient.canModifyTooltip()) {
            return currenttip;
        }
        if (stack == null) {
            return currenttip;
        }
        boolean displayFuelTooltip = true;
        if (FuelTooltip.showContextTooltip && gui != null) {
            for (IFuelContextHelper helper : FuelTooltip.contextHelpers.values()) {
                if (FuelTooltip.disabledContextHelpers.contains(helper.getKey()) || !helper.haveContextTooltip(gui)) continue;
                currenttip = helper.getContextTooltip(gui, stack, currenttip);
                if (helper.displayFuelTooltip(gui)) continue;
                displayFuelTooltip = false;
            }
        }
        if (!displayFuelTooltip) {
            return currenttip;
        }
        if (gui != null && tooltipCache.haveTooltip(stack)) {
            currenttip.add("\u00a77Can produce:");
        }
        if (tooltipCache.addCachedTooltip(stack, currenttip) || !FuelTooltip.isValidFuelItem(stack)) {
            return currenttip;
        }
        ArrayList<String> fueltooltip = new ArrayList<String>();
        FuelTooltip.addCommonFuelTooltip(fueltooltip, stack, FuelTooltip.disabledHelpers);
        if (fueltooltip.size() > 0) {
            currenttip.add("\u00a77Can produce:");
            currenttip.addAll(fueltooltip);
        }
        if (!stack.func_77942_o()) {
            if (fueltooltip.size() > 0) {
                tooltipCache.put(stack, fueltooltip);
            } else {
                tooltipCache.put(stack, null);
            }
        }
        return currenttip;
    }

    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }
}

