/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import neiplugins.NEIPlugins;
import neiplugins.common.FuelTooltipHandler;
import neiplugins.common.IFuelContextHelper;
import neiplugins.common.IFuelHelper;
import neiplugins.common.IOptionUpdateCallback;
import neiplugins.common.TooltipCache;
import neiplugins.common.Utils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FuelTooltip
implements IOptionUpdateCallback {
    public static DecimalFormat heatFormat = new DecimalFormat("0.#");
    public static DecimalFormat MJtFormat = new DecimalFormat("0.0");
    public static final String linePrefix = "\u00a77";
    public static Map<String, IFuelHelper> registeredHelpers = new HashMap<String, IFuelHelper>();
    public static Map<String, IFuelContextHelper> contextHelpers = new HashMap<String, IFuelContextHelper>();
    public static List<String> helpersPosition = new ArrayList<String>();
    public static Set<String> disabledHelpers = new HashSet<String>();
    public static Set<String> disabledContextHelpers = new HashSet<String>();
    public static Set<Integer> allowedNBTItems = new HashSet<Integer>();
    protected static boolean showContextTooltip;
    protected static boolean showLiquiqAsItemFuelTooltip;
    protected static boolean showLiquidContainerFuelTooltip;
    protected static boolean showLiquidContainerItemFuelTooltip;
    protected static boolean showItemStackFuelTooltip;
    protected static Class lastGuiContainer;
    protected static TooltipCache lastContextCache;

    public static void addFuelHelper(boolean hide, IFuelHelper helper) {
        String key = helper.getKey();
        if (!registeredHelpers.containsKey(key)) {
            registeredHelpers.put(key, helper);
        }
        if (!helpersPosition.contains(key)) {
            helpersPosition.add(key);
        }
        if (hide) {
            disabledHelpers.add(key);
        }
    }

    public static void addFuelHelper(IFuelHelper helper) {
        FuelTooltip.addFuelHelper(false, helper);
    }

    public static void addContextFuelHelper(IFuelContextHelper helper) {
        String key = helper.getKey();
        if (!contextHelpers.containsKey(key)) {
            contextHelpers.put(key, helper);
        }
    }

    public static void addValidNBTItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        int key = Utils.itemStackToInt(stack);
        if (key != 0) {
            allowedNBTItems.add(key);
        }
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && (!stack.func_77942_o() || allowedNBTItems.contains(Utils.itemStackToInt(stack)));
    }

    public static void addFluidStackFuelTooltip(List<String> currenttip, FluidStack liquid, Set<String> disabledHelpers) {
        if (liquid == null) {
            return;
        }
        for (String key : helpersPosition) {
            if (disabledHelpers.contains(key)) continue;
            currenttip = registeredHelpers.get(key).getFluidStackFuelTooltip(liquid, currenttip);
        }
    }

    public static void addItemStackFuelTooltip(List<String> currenttip, ItemStack stack, Set<String> disabledHelpers) {
        if (stack == null) {
            return;
        }
        for (String key : helpersPosition) {
            if (disabledHelpers.contains(key)) continue;
            currenttip = registeredHelpers.get(key).getItemStackFuelTooltip(stack, currenttip);
        }
    }

    public static void addCommonFuelTooltip(List<String> currenttip, ItemStack stack, Set<String> disabledHelpers) {
        if (stack == null) {
            return;
        }
        Item item = stack.func_77973_b();
        FluidStack fluid = null;
        if (showLiquidContainerFuelTooltip) {
            fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        }
        if (showLiquidContainerItemFuelTooltip && item instanceof IFluidContainerItem) {
            fluid = ((IFluidContainerItem)item).getFluid(stack);
        }
        for (String key : helpersPosition) {
            if (disabledHelpers.contains(key)) continue;
            try {
                if (showItemStackFuelTooltip) {
                    currenttip = registeredHelpers.get(key).getItemStackFuelTooltip(stack, currenttip);
                }
                if (fluid == null) continue;
                currenttip = registeredHelpers.get(key).getFluidStackFuelTooltip(fluid, currenttip);
            }
            catch (Throwable ex) {
                NEIPlugins.logWarningEx("Error occurred while calling FuelTooltip.addCommonFuelTooltip for fuel helper {0} and item {1}", ex, key, stack);
                currenttip.add("\u00a7c<Error occured>");
            }
        }
    }

    public static void addHighlightFuelTooltip(List<String> currenttip, ItemStack stack, Set<String> disabledHelpers, String hKey) {
        if (stack == null) {
            return;
        }
        Item item = stack.func_77973_b();
        FluidStack fluid = null;
        if (showLiquidContainerFuelTooltip) {
            fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        }
        if (showLiquidContainerItemFuelTooltip && item instanceof IFluidContainerItem) {
            fluid = ((IFluidContainerItem)item).getFluid(stack);
        }
        for (String key : helpersPosition) {
            try {
                if (key.equals(hKey)) {
                    List<String> templist = new ArrayList<String>();
                    templist = registeredHelpers.get(key).getItemStackFuelTooltip(stack, templist);
                    if (fluid != null) {
                        templist = registeredHelpers.get(key).getFluidStackFuelTooltip(fluid, templist);
                    }
                    for (String line : templist) {
                        if (line.startsWith(linePrefix)) {
                            currenttip.add("\u00a7e" + line.substring(2));
                            continue;
                        }
                        currenttip.add(line);
                    }
                    continue;
                }
                if (disabledHelpers.contains(key)) continue;
                if (showItemStackFuelTooltip) {
                    currenttip = registeredHelpers.get(key).getItemStackFuelTooltip(stack, currenttip);
                }
                if (fluid == null) continue;
                currenttip = registeredHelpers.get(key).getFluidStackFuelTooltip(fluid, currenttip);
            }
            catch (Throwable ex) {
                NEIPlugins.logWarningEx("Error occurred while calling FuelTooltip.addHighlightFuelTooltip for fuel helper {0} and item {1}", ex, key, stack);
                currenttip.add("\u00a7c<Error occured>");
            }
        }
    }

    public static TooltipCache getContextCache(GuiContainer gui) {
        if (lastGuiContainer != gui.getClass()) {
            lastContextCache.clear();
            lastGuiContainer = gui.getClass();
        }
        return lastContextCache;
    }

    public static void addContextTooltipCached(GuiContainer gui, List<String> currenttip, ItemStack stack, String hKey) {
        FuelTooltip.addContextTooltipCached(gui, currenttip, stack, disabledHelpers, hKey);
    }

    public static void addContextTooltipCached(GuiContainer gui, List<String> currenttip, ItemStack stack, Set<String> disabledHelpers, String hKey) {
        TooltipCache tooltipCache = FuelTooltip.getContextCache(gui);
        if (tooltipCache.addCachedTooltip(stack, currenttip) || !FuelTooltip.isValidFuelItem(stack)) {
            return;
        }
        ArrayList<String> fueltooltip = new ArrayList<String>();
        FuelTooltip.addHighlightFuelTooltip(fueltooltip, stack, disabledHelpers, hKey);
        if (fueltooltip.size() > 0) {
            fueltooltip.add(0, "\u00a77Can produce:");
            currenttip.addAll(fueltooltip);
        }
        if (!stack.func_77942_o()) {
            if (fueltooltip.size() > 0) {
                tooltipCache.put(stack, fueltooltip);
            } else {
                tooltipCache.put(stack, null);
            }
        }
    }

    @Override
    public void onOptionUpdate() {
        showContextTooltip = Utils.getBooleanSetting("neiplugins.fueltooltip.enableContextTooltip");
        showLiquidContainerFuelTooltip = Utils.getBooleanSetting("neiplugins.fueltooltip.showTooltipForLiquidContainer");
        showLiquiqAsItemFuelTooltip = Utils.getBooleanSetting("neiplugins.fueltooltip.showTooltipForLiquidItem");
        showItemStackFuelTooltip = Utils.getBooleanSetting("neiplugins.fueltooltip.showTooltipForItemStack");
        FuelTooltipHandler.tooltipCache.clear();
    }

    public static String compactValueD(double value) {
        if (value > 99999.0 && value % 100000.0 == 0.0) {
            return heatFormat.format(value / 1000000.0) + "M";
        }
        if (value > 99.0) {
            return heatFormat.format((double)Math.round(value / 100.0) / 10.0) + "k";
        }
        return Long.toString(Math.round(value));
    }

    public static String compactValueF(float value) {
        if (value > 99999.0f && value % 100000.0f == 0.0f) {
            return heatFormat.format(value / 1000000.0f) + "M";
        }
        if (value > 99.0f) {
            return heatFormat.format((float)Math.round(value / 100.0f) / 10.0f) + "k";
        }
        return Integer.toString(Math.round(value));
    }

    public static String compactValue(int value) {
        if (value > 99999 && value % 100000 == 0) {
            return heatFormat.format((float)value / 1000000.0f) + "M";
        }
        if (value > 99 && value % 100 == 0) {
            return heatFormat.format((float)value / 1000.0f) + "k";
        }
        return Integer.toString(value);
    }

    public static String convertHeatValue(int value, int second) {
        return FuelTooltip.compactValue(value) + " heat";
    }

    public static String convertMJt(int value) {
        return MJtFormat.format(value);
    }

    public static String convertMJtF(float value) {
        return MJtFormat.format(value);
    }

    static {
        lastGuiContainer = null;
        lastContextCache = new TooltipCache();
    }
}

