/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import neiplugins.NEIPlugins;
import neiplugins.common.IFirstTickHandler;

public class FirstTickHandler {
    private boolean firstServerTick = true;
    private boolean firstClientTick = true;
    private static List<IFirstTickHandler> clientHandlers = new ArrayList<IFirstTickHandler>();
    private static List<IFirstTickHandler> serverHandlers = new ArrayList<IFirstTickHandler>();
    public static List<IFirstTickHandler> handlers = new ArrayList<IFirstTickHandler>();
    public static final int interval = 30;

    @SubscribeEvent
    public void serverTickStart(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            if (this.firstServerTick) {
                this.firstServerTick = false;
                for (IFirstTickHandler handler : handlers) {
                    if (handler.firstServerTick()) continue;
                    serverHandlers.add(handler);
                }
                if (serverHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - server side finish", new Object[0]);
                }
            } else if (!serverHandlers.isEmpty()) {
                ArrayList<IFirstTickHandler> t = new ArrayList<IFirstTickHandler>();
                for (IFirstTickHandler handler : serverHandlers) {
                    if (handler.firstServerTick()) continue;
                    t.add(handler);
                }
                serverHandlers = t;
                if (serverHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - server side finish", new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void clientTickStart(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            if (this.firstClientTick) {
                this.firstClientTick = false;
                for (IFirstTickHandler handler : handlers) {
                    if (handler.firstClientTick()) continue;
                    clientHandlers.add(handler);
                }
                if (clientHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - client side finish", new Object[0]);
                }
            } else if (!clientHandlers.isEmpty()) {
                ArrayList<IFirstTickHandler> t = new ArrayList<IFirstTickHandler>();
                for (IFirstTickHandler handler : clientHandlers) {
                    if (handler.firstClientTick()) continue;
                    t.add(handler);
                }
                clientHandlers = t;
                if (clientHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - client side finish", new Object[0]);
                }
            }
        }
    }

    public int nextTickSpacing() {
        return this.firstClientTick | this.firstServerTick | !clientHandlers.isEmpty() | !serverHandlers.isEmpty() ? 30 : 1200;
    }
}

