/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.buildcraft;

import buildcraft.api.fuels.IronEngineFuel;
import java.util.HashMap;
import java.util.List;
import neiplugins.common.FuelTooltip;
import neiplugins.common.SimpleFuelContextHelper;
import neiplugins.common.SimpleFuelHelper;
import neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BuildCraftFuelHelper {
    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("buildcraft.ironengine", "Combustion Engine", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                IronEngineFuel.Fuel fuel = IronEngineFuel.getFuelForFluid((Fluid)liquid.getFluid());
                if (fuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValueF(fuel.powerPerCycle * (float)fuel.totalBurningTime * (float)liquid.amount / 1000.0f) + " MJ (Combustion Engine)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("buildcraft.stoneengine", "Stirling Engine", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                int fuelValue = TileEntityFurnace.func_145952_a((ItemStack)stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a77" + fuelValue + "  MJ (Stirling Engine)");
                }
                return currenttip;
            }
        });
        HashMap<Class, String> map = new HashMap<Class, String>();
        Class cls = Utils.findClass("buildcraft.energy.gui.GuiCombustionEngine");
        if (cls != null) {
            map.put(cls, "buildcraft.ironengine");
        }
        if ((cls = Utils.findClass("buildcraft.energy.gui.GuiStoneEngine")) != null) {
            map.put(cls, "buildcraft.stoneengine");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("bc.engines", "BuildCraft", null, map));
        }
    }
}

