/*
 * Decompiled with CFR 0.152.
 */
package neiplugins.buildcraft;

import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.api.recipes.IAssemblyRecipeManager;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class AssemblyRecipeHandler
extends LiquidTemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};
    public static LinkedList assemblyRecipes;
    public static Class<? extends GuiContainer> guiclass;

    @Override
    public String getRecipeId() {
        return "buildcraft.assembly";
    }

    public String getRecipeName() {
        return "Assembly Table";
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public String getOverlayIdentifier() {
        return "buildcraft.assemblyTable";
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public void drawExtras(int recipe) {
        Integer energy = (int)Math.round(((CachedAssemblyRecipe)((Object)this.arecipes.get((int)recipe))).energy);
        GuiDraw.drawStringC((String)(energy + " MJ"), (int)110, (int)9, (int)-8355712, (boolean)false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 3, 24, 58), this.getRecipeId(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    public List<? extends IAssemblyRecipeManager.IAssemblyRecipe> getRecipes() {
        return BuildcraftRecipes.assemblyTable.getRecipes();
    }

    @Override
    public void loadSameRecipeId() {
        for (IAssemblyRecipeManager.IAssemblyRecipe iAssemblyRecipe : this.getRecipes()) {
            this.arecipes.add(new CachedAssemblyRecipe(iAssemblyRecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IAssemblyRecipeManager.IAssemblyRecipe iAssemblyRecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)iAssemblyRecipe.getOutput())) continue;
            this.arecipes.add(new CachedAssemblyRecipe(iAssemblyRecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IAssemblyRecipeManager.IAssemblyRecipe iAssemblyRecipe : this.getRecipes()) {
            CachedAssemblyRecipe recipe = new CachedAssemblyRecipe(iAssemblyRecipe);
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            this.setIngredientPermutationNBT(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedAssemblyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList<PositionedStack> ingredients;
        PositionedStack result;
        double energy;

        public CachedAssemblyRecipe(IAssemblyRecipeManager.IAssemblyRecipe recipe) {
            super((TemplateRecipeHandler)AssemblyRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.getOutput(), 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(recipe.getInputs());
            this.energy = recipe.getEnergyCost();
        }

        public void setIngredients(Object[] items) {
            int count = 0;
            for (int ingred = 0; ingred < items.length; ++ingred) {
                PositionedStack stack = null;
                if (items[ingred] instanceof ItemStack) {
                    stack = new PositionedStack(items[ingred], 25 + stackorder[count][0] * 18, 6 + stackorder[count][1] * 18);
                } else if (items[ingred] instanceof Item) {
                    stack = new PositionedStack((Object)new ItemStack((Item)items[ingred]), 25 + stackorder[count][0] * 18, 6 + stackorder[count][1] * 18);
                } else if (items[ingred] instanceof String) {
                    stack = new PositionedStack((Object)OreDictionary.getOres((String)items[ingred].toString()), 25 + stackorder[count][0] * 18, 6 + stackorder[count][1] * 18);
                }
                if (stack == null) continue;
                ++count;
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AssemblyRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

