/*
 * Decompiled with CFR 0.152.
 */
package neiplugins;

import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import neiplugins.NEIPlugins;
import neiplugins.common.IPlugin;
import neiplugins.common.RecipeHandlerUtils;
import neiplugins.common.Utils;
import neiplugins.railcraft.BlastFurnaceRecipeHandler;
import neiplugins.railcraft.CokeOvenRecipeHandler;
import neiplugins.railcraft.RockCrusherRecipeHandler;
import neiplugins.railcraft.RollingMachineShapedRecipeHandler;
import neiplugins.railcraft.RollingMachineShapelessRecipeHandler;
import net.minecraft.item.ItemStack;

public class NEIPlugins_Railcraft
implements IPlugin {
    public static final String PLUGIN_NAME = "Railcraft";
    public static final String PLUGIN_VERSION = "1.6.6";
    public static final String REQUIRED_MOD = "Railcraft";

    @Override
    public String getPluginName() {
        return "Railcraft";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Railcraft");
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        RockCrusherRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiRockCrusher");
        BlastFurnaceRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiBlastFurnace");
        CokeOvenRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiCokeOven");
        RollingMachineShapedRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiRollingMachine");
        RollingMachineShapelessRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiRollingMachine");
        API.registerGuiOverlay(RollingMachineShapedRecipeHandler.guiclass, (String)"railcraft.rolling");
        API.registerGuiOverlayHandler(RollingMachineShapedRecipeHandler.guiclass, (IOverlayHandler)new DefaultOverlayHandler(5, 9), (String)"railcraft.rolling");
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineShapedRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineShapedRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineShapelessRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineShapelessRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CokeOvenRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CokeOvenRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BlastFurnaceRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BlastFurnaceRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RockCrusherRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RockCrusherRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.rolling.machine"), "Rolling Machine", 0, "railcraft.rolling", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.rock.crusher"), "Rock Crusher", 0, "railcraft.crusher", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.coke.oven"), "Coke Oven", 0, "railcraft.cokeoven", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.blast.furnace"), "Blast Furnace", 0, "railcraft.blastfurnace", new Object[0]);
    }

    private static ItemStack getItemByTag(String tag) {
        try {
            return GameRegistry.findItemStack((String)"Railcraft", (String)tag, (int)1);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

