/*
 * Decompiled with CFR 0.152.
 */
package neiplugins;

import codechicken.nei.api.API;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import neiplugins.NEIPlugins;
import neiplugins.common.IPlugin;
import neiplugins.common.LiquidHelper;
import neiplugins.forge.FluidRegistryList;
import neiplugins.forge.OptionsForge;
import neiplugins.forge.OreDictionaryList;
import neiplugins.forge.OreDictionaryTooltipHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class NEIPlugins_Forge
implements IPlugin {
    public static final String PLUGIN_NAME = "Minecraft Forge";
    public static final String PLUGIN_VERSION = "1.4.2";
    public static final String REQUIRED_MOD = "Forge";
    public static OreDictionaryTooltipHandler oredictTooltipHandler;

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod(REQUIRED_MOD);
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        this.addLiquidContainerSubset();
        API.registerUsageHandler((IUsageHandler)new OreDictionaryList());
        API.registerRecipeHandler((ICraftingHandler)new OreDictionaryList());
        API.registerUsageHandler((IUsageHandler)new FluidRegistryList());
        API.registerRecipeHandler((ICraftingHandler)new FluidRegistryList());
        OreDictionaryTooltipHandler.resetCache();
        oredictTooltipHandler = new OreDictionaryTooltipHandler();
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)oredictTooltipHandler);
        ArrayList<ItemStack> liquids = new ArrayList<ItemStack>();
        for (Object k : Block.field_149771_c.func_148742_b()) {
            Object v = Block.field_149771_c.func_82594_a(k);
            if (!(v instanceof IFluidBlock) && !(v instanceof BlockLiquid)) continue;
            liquids.add(new ItemStack((Block)v));
        }
        API.addSubset((String)"Blocks.Fluids", liquids);
        OptionsForge.addOptions();
    }

    private void addLiquidContainerSubset() {
        HashSet<List<Integer>> setContainerValidation = new HashSet<List<Integer>>();
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (setContainerValidation.contains(Arrays.asList(Item.func_150891_b((Item)data.emptyContainer.func_77973_b()), data.emptyContainer.func_77960_j()))) continue;
            setContainerValidation.add(Arrays.asList(Item.func_150891_b((Item)data.emptyContainer.func_77973_b()), data.emptyContainer.func_77960_j()));
            containers.add(data.emptyContainer.func_77946_l());
        }
        API.addSubset((String)"Items.Fluid Containers", containers);
        for (String s : FluidRegistry.getRegisteredFluids().keySet()) {
            Fluid fluid = FluidRegistry.getFluid((String)s);
            if (fluid == null) continue;
            HashSet<ItemStack> filledContainers = new HashSet<ItemStack>();
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.fluid.getFluid() != fluid) continue;
                filledContainers.add(data.filledContainer.func_77946_l());
            }
            if (filledContainers.size() <= 0) continue;
            String liquidName = LiquidHelper.getLiquidName(new FluidStack(fluid, 1000)).replace('.', '_');
            API.addSubset((String)("Items.Fluid Containers." + liquidName), filledContainers);
        }
    }
}

