/*
 * Decompiled with CFR 0.152.
 */
package neiplugins;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import neiplugins.NEIPlugins;
import neiplugins.common.IPlugin;
import neiplugins.common.RecipeHandlerUtils;
import neiplugins.common.Utils;
import neiplugins.forestry.CarpenterRecipeHandler;
import neiplugins.forestry.CentrifugeRecipeHandler;
import neiplugins.forestry.FabricatorRecipeHandler;
import neiplugins.forestry.FermenterRecipeHandler;
import neiplugins.forestry.MoistenerRecipeHandler;
import neiplugins.forestry.ShapedForestryRecipeHandler;
import neiplugins.forestry.SqueezerRecipeHandler;
import neiplugins.forestry.StillRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIPlugins_Forestry
implements IPlugin {
    public static final String PLUGIN_NAME = "Forestry";
    public static final String PLUGIN_VERSION = "1.4.6";
    public static final String REQUIRED_MOD = "Forestry";
    private static boolean showSecrets = false;

    @Override
    public String getPluginName() {
        return "Forestry";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Forestry");
    }

    public void updateConfig() {
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        FabricatorRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiFabricator");
        CarpenterRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiCarpenter");
        MoistenerRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiMoistener");
        CentrifugeRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiCentrifuge");
        SqueezerRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiSqueezer");
        StillRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiStill");
        FermenterRecipeHandler.guiclass = Utils.findClass("forestry.factory.gui.GuiFermenter");
        API.registerRecipeHandler((ICraftingHandler)new FabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new FabricatorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CarpenterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CarpenterRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MoistenerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MoistenerRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CentrifugeRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CentrifugeRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new SqueezerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new SqueezerRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new StillRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new StillRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new FermenterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new FermenterRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory", 1), "Carpenter", 0, "forestry.carpenter", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory", 2), "Centrifuge", 0, "forestry.centrifuge", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory", 3), "Fermenter", 0, "forestry.fermenter", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory", 4), "Moistener", 0, "forestry.moistener", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory", 5), "Squeezer", 0, "forestry.squeezer", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory", 6), "Still", 0, "forestry.still", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Forestry", NEIPlugins_Forestry.getForestryBlockStack("tile.for.factory2", 0), "Thermionic Fabricator", 0, "forestry.fabricator", new Object[0]);
        API.registerRecipeHandler((ICraftingHandler)new ShapedForestryRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ShapedForestryRecipeHandler());
        FermenterRecipeHandler.loadFuels();
        FabricatorRecipeHandler.buildMoltensCache();
    }

    public static ItemStack getForestryBlockStack(String name, int meta) {
        Block block = GameRegistry.findBlock((String)"Forestry", (String)name);
        if (block != null) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }

    public static Item getForestryItem(String name) {
        return GameRegistry.findItem((String)"Forestry", (String)name);
    }
}

