/*
 * Decompiled with CFR 0.152.
 */
package neiplugins;

import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import neiplugins.NEIPlugins;
import neiplugins.buildcraft.AssemblyRecipeHandler;
import neiplugins.buildcraft.RefineryRecipeHandler;
import neiplugins.common.IPlugin;
import neiplugins.common.RecipeHandlerUtils;
import neiplugins.common.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public class NEIPlugins_BuildCraft
implements IPlugin {
    public static final String PLUGIN_NAME = "BuildCraft";
    public static final String PLUGIN_VERSION = "1.5.2";
    public static final String REQUIRED_MOD = "BuildCraft|Core";
    public static final String REQUIRED_MOD1 = "BuildCraft|Energy";
    public static final String REQUIRED_MOD2 = "BuildCraft|Factory";
    public static final String REQUIRED_MOD3 = "BuildCraft|Silicon";
    public static final String REQUIRED_VERSION = "6.0";
    public static boolean buildersLoaded;
    public static boolean energyLoaded;
    public static boolean factoryLoaded;
    public static boolean siliconLoaded;
    public static boolean transportLoaded;

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        if (NEIPlugins.getMod().hasMod(REQUIRED_MOD)) {
            return NEIPlugins.getMod().modVersions.get(REQUIRED_MOD).getVersionString().startsWith(REQUIRED_VERSION);
        }
        return false;
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        energyLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD1);
        factoryLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD2);
        siliconLoaded = NEIPlugins.getMod().hasMod(REQUIRED_MOD3);
        this.addHandlers();
    }

    private void addHandlers() {
        Class cls;
        if (!energyLoaded) {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Energy not found", new Object[0]);
        }
        if (factoryLoaded) {
            cls = Utils.findClass("buildcraft.factory.gui.GuiRefinery");
            if (cls != null) {
                RefineryRecipeHandler.guiclass = cls;
                API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
                API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
                API.setGuiOffset((Class)cls, (int)0, (int)31);
                RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_BuildCraft.getBuildCraftBlockStack("Factory", "refineryBlock", 0), "Refinery", 0, "buildcraft.refinery", new Object[0]);
            }
        } else {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Factory not found", new Object[0]);
        }
        if (siliconLoaded) {
            cls = Utils.findClass("buildcraft.silicon.gui.GuiAssemblyTable");
            if (cls != null) {
                AssemblyRecipeHandler.guiclass = cls;
                API.registerRecipeHandler((ICraftingHandler)new AssemblyRecipeHandler());
                API.registerUsageHandler((IUsageHandler)new AssemblyRecipeHandler());
                RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_BuildCraft.getBuildCraftBlockStack("Silicon", "laserBlock", 0), "Assembly Table", 0, "buildcraft.assembly", new Object[0]);
                API.registerGuiOverlay((Class)cls, (String)"buildcraft.assembly", (int)-17, (int)30);
                API.registerGuiOverlayHandler((Class)cls, (IOverlayHandler)new DefaultOverlayHandler(-17, 30), (String)"buildcraft.assembly");
            }
        } else {
            NEIPlugins.log(Level.INFO, "Mod Buildcraft|Silicon not found", new Object[0]);
        }
    }

    public static ItemStack getBuildCraftBlockStack(String submod, String name, int meta) {
        Block block = GameRegistry.findBlock((String)("BuildCraft|" + submod), (String)name);
        if (block != null) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }
}

