/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidContainerRegistry {
    private static Map<ContainerKey, FluidContainerData> containerFluidMap = Maps.newHashMap();
    private static Map<ContainerKey, FluidContainerData> filledContainerMap = Maps.newHashMap();
    private static Set<ContainerKey> emptyContainers = Sets.newHashSet();
    public static final int BUCKET_VOLUME = 1000;
    public static final add EMPTY_BUCKET = new add(ade.ar);
    public static final add EMPTY_BOTTLE = new add(ade.bo);
    private static final add NULL_EMPTYCONTAINER = new add(ade.ar);

    private FluidContainerRegistry() {
    }

    public static boolean registerFluidContainer(FluidStack stack, add filledContainer, add emptyContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, emptyContainer));
    }

    public static boolean registerFluidContainer(Fluid fluid, add filledContainer, add emptyContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer, emptyContainer);
    }

    public static boolean registerFluidContainer(FluidStack stack, add filledContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, null, true));
    }

    public static boolean registerFluidContainer(Fluid fluid, add filledContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer);
    }

    public static boolean registerFluidContainer(FluidContainerData data) {
        if (FluidContainerRegistry.isFilledContainer(data.filledContainer)) {
            return false;
        }
        containerFluidMap.put(new ContainerKey(data.filledContainer), data);
        if (data.emptyContainer != null && data.emptyContainer != NULL_EMPTYCONTAINER) {
            filledContainerMap.put(new ContainerKey(data.emptyContainer, data.fluid), data);
            emptyContainers.add(new ContainerKey(data.emptyContainer));
        }
        MinecraftForge.EVENT_BUS.post(new FluidContainerRegisterEvent(data));
        return true;
    }

    public static FluidStack getFluidForFilledItem(add container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data == null ? null : data.fluid.copy();
    }

    public static add fillFluidContainer(FluidStack fluid, add container) {
        if (container == null || fluid == null) {
            return null;
        }
        FluidContainerData data = filledContainerMap.get(new ContainerKey(container, fluid));
        if (data != null && fluid.amount >= data.fluid.amount) {
            return data.filledContainer.m();
        }
        return null;
    }

    public static add drainFluidContainer(add container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        if (data != null) {
            return data.emptyContainer.m();
        }
        return null;
    }

    public static int getContainerCapacity(add container) {
        return FluidContainerRegistry.getContainerCapacity(null, container);
    }

    public static int getContainerCapacity(FluidStack fluid, add container) {
        if (container == null) {
            return 0;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        if (data != null) {
            return data.fluid.amount;
        }
        if (fluid != null && (data = filledContainerMap.get(new ContainerKey(container, fluid))) != null) {
            return data.fluid.amount;
        }
        return 0;
    }

    public static boolean containsFluid(add container, FluidStack fluid) {
        if (container == null || fluid == null) {
            return false;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data == null ? false : data.fluid.containsFluid(fluid);
    }

    public static boolean isBucket(add container) {
        if (container == null) {
            return false;
        }
        if (container.a(EMPTY_BUCKET)) {
            return true;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data != null && data.emptyContainer.a(EMPTY_BUCKET);
    }

    public static boolean isContainer(add container) {
        return FluidContainerRegistry.isEmptyContainer(container) || FluidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(add container) {
        return container != null && emptyContainers.contains(new ContainerKey(container));
    }

    public static boolean isFilledContainer(add container) {
        return container != null && FluidContainerRegistry.getFluidForFilledItem(container) != null;
    }

    public static FluidContainerData[] getRegisteredFluidContainerData() {
        return containerFluidMap.values().toArray(new FluidContainerData[containerFluidMap.size()]);
    }

    static {
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new add(ade.as), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.LAVA, new add(ade.at), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new add((adb)ade.bn), EMPTY_BOTTLE);
    }

    public static class FluidContainerRegisterEvent
    extends Event {
        public final FluidContainerData data;

        public FluidContainerRegisterEvent(FluidContainerData data) {
            this.data = data.copy();
        }
    }

    public static class FluidContainerData {
        public final FluidStack fluid;
        public final add filledContainer;
        public final add emptyContainer;

        public FluidContainerData(FluidStack stack, add filledContainer, add emptyContainer) {
            this(stack, filledContainer, emptyContainer, false);
        }

        public FluidContainerData(FluidStack stack, add filledContainer, add emptyContainer, boolean nullEmpty) {
            this.fluid = stack;
            this.filledContainer = filledContainer;
            add add2 = this.emptyContainer = emptyContainer == null ? NULL_EMPTYCONTAINER : emptyContainer;
            if (stack == null || filledContainer == null || emptyContainer == null && !nullEmpty) {
                throw new RuntimeException("Invalid FluidContainerData - a parameter was null.");
            }
        }

        public FluidContainerData copy() {
            return new FluidContainerData(this.fluid, this.filledContainer, this.emptyContainer, true);
        }
    }

    private static class ContainerKey {
        add container;
        FluidStack fluid;

        private ContainerKey(add container) {
            this.container = container;
        }

        private ContainerKey(add container, FluidStack fluid) {
            this(container);
            this.fluid = fluid;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.container.b().hashCode();
            code = 31 * code + this.container.k();
            if (this.fluid != null) {
                code = 31 * code + this.fluid.fluidID;
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ContainerKey)) {
                return false;
            }
            ContainerKey ck = (ContainerKey)o;
            if (this.container.b() != ck.container.b()) {
                return false;
            }
            if (this.container.k() != ck.container.k()) {
                return false;
            }
            if (this.fluid == null && ck.fluid != null) {
                return false;
            }
            if (this.fluid != null && ck.fluid == null) {
                return false;
            }
            if (this.fluid == null && ck.fluid == null) {
                return true;
            }
            return this.fluid.fluidID == ck.fluid.fluidID;
        }
    }
}

