/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.ZipperUtil;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.ExistingSubstitutionException;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ObjectHolderRegistry;
import cpw.mods.fml.common.registry.RegistryDelegate;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class GameData {
    static final int MIN_BLOCK_ID = 0;
    static final int MAX_BLOCK_ID = 4095;
    static final int MIN_ITEM_ID = 4096;
    static final int MAX_ITEM_ID = 31999;
    private static final GameData mainData = new GameData();
    @Deprecated
    public static final FMLControlledNamespacedRegistry<aji> blockRegistry = GameData.getBlockRegistry();
    @Deprecated
    public static final FMLControlledNamespacedRegistry<adb> itemRegistry = GameData.getItemRegistry();
    private static Table<String, String, add> customItemStacks = HashBasedTable.create();
    private static Map<GameRegistry.UniqueIdentifier, ModContainer> customOwners = Maps.newHashMap();
    private static GameData frozen;
    private final FMLControlledNamespacedRegistry<aji> iBlockRegistry;
    private final FMLControlledNamespacedRegistry<adb> iItemRegistry;
    private final BitSet availabilityMap;
    private final Set<Integer> blockedIds;
    private BiMap<String, adb> itemSubstitutions = HashBiMap.create();
    private BiMap<String, aji> blockSubstitutions = HashBiMap.create();

    public static FMLControlledNamespacedRegistry<aji> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    public static FMLControlledNamespacedRegistry<adb> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static ModContainer findModOwner(String string) {
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(string);
        if (customOwners.containsKey(ui)) {
            return customOwners.get(ui);
        }
        return Loader.instance().getIndexedModList().get(ui.modId);
    }

    public static GameDataSnapshot buildItemDataList() {
        HashMap idMapping = Maps.newHashMap();
        GameData.getMain().iBlockRegistry.serializeInto(idMapping);
        GameData.getMain().iItemRegistry.serializeInto(idMapping);
        HashSet blockSubs = Sets.newHashSet();
        GameData.getMain().iBlockRegistry.serializeSubstitutions(blockSubs);
        HashSet itemSubs = Sets.newHashSet();
        GameData.getMain().iItemRegistry.serializeSubstitutions(itemSubs);
        return new GameDataSnapshot(idMapping, blockSubs, itemSubs);
    }

    public static int[] getBlockedIds() {
        int[] ret = new int[GameData.getMain().blockedIds.size()];
        int index = 0;
        Iterator<Integer> i$ = GameData.getMain().blockedIds.iterator();
        while (i$.hasNext()) {
            int id;
            ret[index] = id = i$.next().intValue();
            ++index;
        }
        return ret;
    }

    public static void dumpRegistry(File minecraftDir) {
        if (customItemStacks == null) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("fml.dumpRegistry", "false")).booleanValue()) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String modId : customItemStacks.rowKeySet()) {
                builder.putAll((Object)modId, customItemStacks.row((Object)modId).keySet());
            }
            File f = new File(minecraftDir, "itemStackRegistry.csv");
            Joiner.MapJoiner mapJoiner = Joiner.on((String)"\n").withKeyValueSeparator(",");
            try {
                Files.write((CharSequence)mapJoiner.join((Iterable)builder.build().entries()), (File)f, (Charset)Charsets.UTF_8);
                FMLLog.log(Level.INFO, "Dumped item registry data to %s", f.getAbsolutePath());
            }
            catch (IOException e) {
                FMLLog.log(Level.ERROR, e, "Failed to write registry data to %s", f.getAbsolutePath());
            }
        }
    }

    static adb findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.a(modId + ":" + name);
    }

    static aji findBlock(String modId, String name) {
        String key = modId + ":" + name;
        return GameData.getMain().iBlockRegistry.b(key) ? GameData.getMain().iBlockRegistry.a(key) : null;
    }

    static add findItemStack(String modId, String name) {
        aji b2;
        adb i;
        add is = (add)customItemStacks.get((Object)modId, (Object)name);
        if (is == null && (i = GameData.findItem(modId, name)) != null) {
            is = new add(i, 0, 0);
        }
        if (is == null && (b2 = GameData.findBlock(modId, name)) != null) {
            is = new add(b2, 0, Short.MAX_VALUE);
        }
        return is;
    }

    static void registerCustomItemStack(String name, add itemStack) {
        customItemStacks.put((Object)Loader.instance().activeModContainer().getModId(), (Object)name, (Object)itemStack);
    }

    static GameRegistry.UniqueIdentifier getUniqueName(aji block) {
        if (block == null) {
            return null;
        }
        String name = GameData.getMain().iBlockRegistry.c(block);
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(name);
        if (customItemStacks.contains((Object)ui.modId, (Object)ui.name)) {
            return null;
        }
        return ui;
    }

    static GameRegistry.UniqueIdentifier getUniqueName(adb item) {
        if (item == null) {
            return null;
        }
        String name = GameData.getMain().iItemRegistry.c(item);
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(name);
        if (customItemStacks.contains((Object)ui.modId, (Object)ui.name)) {
            return null;
        }
        return ui;
    }

    /*
     * WARNING - void declaration
     */
    public static void fixBrokenIds(Map<String, Integer> dataList, Set<Integer> blockedIds) {
        BitSet availabilityMap = new BitSet(32000);
        for (Map.Entry<String, Integer> entry : dataList.entrySet()) {
            String itemName = entry.getKey();
            String realName = itemName.substring(1);
            if (itemName.charAt(0) != '\u0001') continue;
            availabilityMap.set(entry.getValue());
        }
        HashSet<Integer> newBlockedIds = new HashSet<Integer>();
        HashSet<String> itemsToRemove = new HashSet<String>();
        HashMap<String, Integer> itemsToRelocate = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : dataList.entrySet()) {
            String itemName = entry.getKey();
            if (itemName.charAt(0) == '\u0001') continue;
            int oldId = entry.getValue();
            String string = itemName.substring(1);
            String blockName = '\u0001' + string;
            adb item = GameData.getMain().iItemRegistry.getRaw(string);
            boolean blockThisId = false;
            if (item == null) {
                FMLLog.warning("Item %s (old id %d) is no longer available and thus can't be fixed.", string, oldId);
                itemsToRemove.add(itemName);
                blockThisId = true;
            } else if (item instanceof abh) {
                if (dataList.containsKey(blockName)) {
                    int blockId = dataList.get(blockName);
                    if (blockId != oldId) {
                        FMLLog.warning("ItemBlock %s (old id %d) doesn't have the same id as its block (%d).", string, oldId, blockId);
                        itemsToRelocate.put(entry.getKey(), blockId);
                        blockThisId = true;
                    } else {
                        availabilityMap.set(oldId);
                    }
                } else {
                    FMLLog.warning("Item %s (old id %d) has been migrated to an ItemBlock and can't be fixed.", string, oldId);
                    itemsToRemove.add(itemName);
                    blockThisId = true;
                }
            } else if (availabilityMap.get(oldId)) {
                FMLLog.warning("Item %s (old id %d) is conflicting with another block/item and can't be fixed.", string, oldId);
                itemsToRemove.add(itemName);
            } else {
                availabilityMap.set(oldId);
            }
            if (!blockThisId || availabilityMap.get(oldId)) continue;
            newBlockedIds.add(oldId);
            availabilityMap.set(oldId);
        }
        if (itemsToRemove.isEmpty() && itemsToRelocate.isEmpty()) {
            return;
        }
        String text = "Forge Mod Loader detected that this save is damaged.\n\nIt's likely that an automatic repair can successfully restore\nmost of it, except some items which may get swapped with others.\n\nA world backup will be created as a zip file in your saves\ndirectory automatically.\n\n" + itemsToRemove.size() + " items need to be removed.\n" + itemsToRelocate.size() + " items need to be relocated.";
        boolean confirmed = StartupQuery.confirm(text);
        if (!confirmed) {
            StartupQuery.abort();
        }
        HashSet<String> modsMissing = new HashSet<String>();
        for (String string : itemsToRemove) {
            modsMissing.add(string.substring(1, string.indexOf(58)));
        }
        Iterator it = modsMissing.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            if (!string.equals("minecraft") && !Loader.isModLoaded(string)) continue;
            it.remove();
        }
        if (!modsMissing.isEmpty()) {
            text = "Forge Mod Loader detected that " + modsMissing.size() + " mods are missing.\n\n" + "If you continue items previously provided by those mods will be\n" + "removed while repairing this world save.\n\n" + "Missing mods:\n";
            for (String string : modsMissing) {
                text = text + string + "\n";
            }
            confirmed = StartupQuery.confirm(text);
            if (!confirmed) {
                StartupQuery.abort();
            }
        }
        try {
            String skip = System.getProperty("fml.doNotBackup");
            if (skip == null || !"true".equals(skip)) {
                ZipperUtil.backupWorld();
            } else {
                void var10_21;
                boolean bl = false;
                while (var10_21 < 10) {
                    FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    ++var10_21;
                }
            }
        }
        catch (IOException e) {
            StartupQuery.notify("The world backup couldn't be created.\n\n" + e);
            StartupQuery.abort();
        }
        for (String string : itemsToRemove) {
            int id = dataList.remove(string);
            FMLLog.warning("Removed Item %s, old id %d.", string.substring(1), id);
        }
        for (Map.Entry entry : itemsToRelocate.entrySet()) {
            String itemName = (String)entry.getKey();
            int newId = (Integer)entry.getValue();
            int oldId = dataList.put(itemName, newId);
            FMLLog.warning("Remapped Item %s to id %d, old id %d.", itemName.substring(1), newId, oldId);
        }
        blockedIds.addAll(newBlockedIds);
    }

    public static List<String> injectWorldIDMap(Map<String, Integer> dataList, Set<String> blockSubstitutions, Set<String> itemSubstitutions, boolean injectFrozenData, boolean isLocalWorld) {
        return GameData.injectWorldIDMap(dataList, new HashSet<Integer>(), new HashMap<String, String>(), new HashMap<String, String>(), blockSubstitutions, itemSubstitutions, injectFrozenData, isLocalWorld);
    }

    public static List<String> injectWorldIDMap(Map<String, Integer> dataList, Set<Integer> blockedIds, Map<String, String> blockAliases, Map<String, String> itemAliases, Set<String> blockSubstitutions, Set<String> itemSubstitutions, boolean injectFrozenData, boolean isLocalWorld) {
        FMLLog.info("Injecting existing block and item data into this %s instance", FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap<String, Integer> missingMappings = new LinkedHashMap<String, Integer>();
        GameData.getMain().testConsistency();
        GameData.getMain().iBlockRegistry.dump();
        GameData.getMain().iItemRegistry.dump();
        GameData newData = new GameData();
        Iterator<Object> i$ = blockedIds.iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            newData.block(n);
        }
        for (Map.Entry entry : blockAliases.entrySet()) {
            newData.iBlockRegistry.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : itemAliases.entrySet()) {
            newData.iItemRegistry.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : blockSubstitutions) {
            newData.iBlockRegistry.activateSubstitution(string);
        }
        for (String string : itemSubstitutions) {
            newData.iItemRegistry.activateSubstitution(string);
        }
        if (injectFrozenData) {
            for (String string : GameData.getMain().blockSubstitutions.keySet()) {
                if (blockSubstitutions.contains(string)) continue;
                newData.iBlockRegistry.activateSubstitution(string);
            }
            for (String string : GameData.getMain().itemSubstitutions.keySet()) {
                if (itemSubstitutions.contains(string)) continue;
                newData.iItemRegistry.activateSubstitution(string);
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            boolean bl = pass == 0;
            for (Map.Entry<String, Integer> entry : dataList.entrySet()) {
                int currId;
                String itemName = entry.getKey();
                int newId = entry.getValue();
                if (itemName.charAt(0) == '\u0001' != bl) continue;
                itemName = itemName.substring(1);
                int n = currId = bl ? GameData.getMain().iBlockRegistry.getId(itemName) : GameData.getMain().iItemRegistry.getId(itemName);
                if (currId == -1) {
                    FMLLog.info("Found a missing id from the world %s", itemName);
                    missingMappings.put(entry.getKey(), newId);
                    continue;
                }
                if (currId != newId) {
                    FMLLog.fine("Fixed %s id mismatch %s: %d (init) -> %d (map).", bl ? "block" : "item", itemName, currId, newId);
                    remaps.put(itemName, new Integer[]{currId, newId});
                }
                if ((currId = bl ? newData.registerBlock(GameData.getMain().iBlockRegistry.getRaw(itemName), itemName, newId) : newData.registerItem(GameData.getMain().iItemRegistry.getRaw(itemName), itemName, newId)) == newId) continue;
                throw new IllegalStateException(String.format("Can't map %s %s to id %d (seen at: %d), already occupied by %s, blocked %b, ItemBlock %b", bl ? "block" : "item", itemName, newId, currId, bl ? newData.iBlockRegistry.getRaw(newId) : newData.iItemRegistry.getRaw(newId), newData.blockedIds.contains(newId), bl ? false : GameData.getMain().iItemRegistry.getRaw(currId) instanceof abh));
            }
        }
        List<String> missedMappings = Loader.instance().fireMissingMappingEvent(missingMappings, isLocalWorld, newData, remaps);
        if (!missedMappings.isEmpty()) {
            return missedMappings;
        }
        if (injectFrozenData) {
            Map<String, Integer> map = GameData.frozen.iBlockRegistry.getEntriesNotIn(newData.iBlockRegistry);
            Map<String, Integer> missingItems = GameData.frozen.iItemRegistry.getEntriesNotIn(newData.iItemRegistry);
            if (!map.isEmpty() || !missingItems.isEmpty()) {
                FMLLog.info("Injecting new block and item data into this server instance.", new Object[0]);
                for (int pass = 0; pass < 2; ++pass) {
                    boolean isBlock = pass == 0;
                    Map<String, Integer> missing = pass == 0 ? map : missingItems;
                    for (Map.Entry<String, Integer> entry : missing.entrySet()) {
                        String itemName = entry.getKey();
                        int currId = entry.getValue();
                        int newId = isBlock ? newData.registerBlock(GameData.frozen.iBlockRegistry.getRaw(itemName), itemName, currId) : newData.registerItem(GameData.frozen.iItemRegistry.getRaw(itemName), itemName, currId);
                        FMLLog.info("Injected new block/item %s: %d (init) -> %d (map).", itemName, currId, newId);
                        if (newId == currId) continue;
                        remaps.put(itemName, new Integer[]{entry.getValue(), newId});
                    }
                }
            }
        }
        newData.testConsistency();
        GameData.getMain().set(newData);
        GameData.getMain().iBlockRegistry.dump();
        GameData.getMain().iItemRegistry.dump();
        Loader.instance().fireRemapEvent(remaps);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        return ImmutableList.of();
    }

    public static List<String> processIdRematches(Iterable<FMLMissingMappingsEvent.MissingMapping> missedMappings, boolean isLocalWorld, GameData gameData, Map<String, Integer[]> remaps) {
        ArrayList failed = Lists.newArrayList();
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        ArrayList defaulted = Lists.newArrayList();
        for (FMLMissingMappingsEvent.MissingMapping remap : missedMappings) {
            FMLMissingMappingsEvent.Action action = remap.getAction();
            if (action == FMLMissingMappingsEvent.Action.REMAP) {
                int newId;
                String newName;
                int currId;
                if (remap.type == GameRegistry.Type.BLOCK) {
                    currId = GameData.getMain().iBlockRegistry.getId((aji)remap.getTarget());
                    newName = GameData.getMain().iBlockRegistry.c(remap.getTarget());
                    FMLLog.fine("The Block %s is being remapped to %s.", remap.name, newName);
                    newId = gameData.registerBlock((aji)remap.getTarget(), newName, remap.id);
                    gameData.iBlockRegistry.addAlias(remap.name, newName);
                } else {
                    currId = GameData.getMain().iItemRegistry.getId((adb)remap.getTarget());
                    newName = GameData.getMain().iItemRegistry.c(remap.getTarget());
                    FMLLog.fine("The Item %s is being remapped to %s.", remap.name, newName);
                    newId = gameData.registerItem((adb)remap.getTarget(), newName, remap.id);
                    gameData.iItemRegistry.addAlias(remap.name, newName);
                }
                if (newId != remap.id) {
                    throw new IllegalStateException();
                }
                if (currId == newId) continue;
                FMLLog.info("Fixed %s id mismatch %s: %d (init) -> %d (map).", remap.type == GameRegistry.Type.BLOCK ? "block" : "item", newName, currId, newId);
                remaps.put(newName, new Integer[]{currId, newId});
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.DEFAULT) {
                defaulted.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.FAIL) {
                failed.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.WARN) {
                warned.add(remap.name);
            }
            gameData.block(remap.id);
        }
        if (!defaulted.isEmpty()) {
            String text = "Forge Mod Loader detected missing blocks/items.\n\nThere are " + defaulted.size() + " missing blocks and items in this save.\n" + "If you continue the missing blocks/items will get removed.\n" + "A world backup will be automatically created in your saves directory.\n\n" + "Missing Blocks/Items:\n";
            for (String s : defaulted) {
                text = text + s + "\n";
            }
            boolean confirmed = StartupQuery.confirm(text);
            if (!confirmed) {
                StartupQuery.abort();
            }
            try {
                String skip = System.getProperty("fml.doNotBackup");
                if (skip == null || !"true".equals(skip)) {
                    ZipperUtil.backupWorld();
                } else {
                    for (int x = 0; x < 10; ++x) {
                        FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    }
                }
            }
            catch (IOException e) {
                StartupQuery.notify("The world backup couldn't be created.\n\n" + e);
                StartupQuery.abort();
            }
            warned.addAll(defaulted);
        }
        if (!failed.isEmpty()) {
            FMLLog.severe("This world contains blocks and items that refuse to be remapped. The world will not be loaded", new Object[0]);
            return failed;
        }
        if (!warned.isEmpty()) {
            FMLLog.severe("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return failed;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", ignored.size());
        }
        return failed;
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        GameData.getMain().testConsistency();
        frozen = new GameData(GameData.getMain());
        frozen.testConsistency();
    }

    public static void revertToFrozen() {
        if (frozen == null) {
            FMLLog.warning("Can't revert to frozen GameData state without freezing first.", new Object[0]);
        } else {
            FMLLog.fine("Reverting to frozen data state.", new Object[0]);
            GameData.getMain().set(frozen);
        }
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    protected static boolean isFrozen(FMLControlledNamespacedRegistry<?> registry) {
        return frozen != null && (GameData.getMain().iBlockRegistry == registry || GameData.getMain().iItemRegistry == registry);
    }

    protected static GameData getMain() {
        return mainData;
    }

    private GameData() {
        this.iBlockRegistry = new FMLControlledNamespacedRegistry<aji>("minecraft:air", 4095, 0, aji.class, '\u0001');
        this.iItemRegistry = new FMLControlledNamespacedRegistry<adb>(null, 31999, 4096, adb.class, '\u0002');
        this.availabilityMap = new BitSet(32000);
        this.blockedIds = new HashSet<Integer>();
    }

    private GameData(GameData data) {
        this();
        this.set(data);
    }

    private void set(GameData data) {
        this.iBlockRegistry.set(data.iBlockRegistry);
        this.iItemRegistry.set(data.iItemRegistry);
        this.availabilityMap.clear();
        this.availabilityMap.or(data.availabilityMap);
        this.blockedIds.clear();
        this.blockedIds.addAll(data.blockedIds);
    }

    int register(Object obj, String name, int idHint) {
        name = this.addPrefix(name);
        if (obj instanceof aji) {
            return this.registerBlock((aji)obj, name, idHint);
        }
        if (obj instanceof adb) {
            return this.registerItem((adb)obj, name, idHint);
        }
        throw new IllegalArgumentException("An invalid registry object is to be added, only instances of Block or Item are allowed.");
    }

    int registerItem(adb item, String name) {
        int index = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, index), name);
        }
        name = this.addPrefix(name);
        return this.registerItem(item, name, -1);
    }

    private int registerItem(adb item, String name, int idHint) {
        if (item instanceof abh) {
            int id;
            aji block = ((abh)item).a;
            if (idHint != -1 && GameData.getMain().blockSubstitutions.containsKey((Object)name)) {
                block = (aji)GameData.getMain().blockSubstitutions.get((Object)name);
            }
            if ((id = this.iBlockRegistry.getId(block)) == -1) {
                if (idHint < 0 || this.availabilityMap.get(idHint) || idHint > 4095) {
                    id = this.availabilityMap.nextClearBit(0);
                    if (id > 4095) {
                        throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", id));
                    }
                    FMLLog.fine("Allocated id %d for ItemBlock %s in the block id range, original id requested: %d.", id, name, idHint);
                } else {
                    id = idHint;
                }
            } else {
                FMLLog.fine("Found matching Block %s for ItemBlock %s at id %d, original id requested: %d", block, item, id, idHint);
                this.freeSlot(id, item);
            }
            idHint = id;
        }
        int itemId = this.iItemRegistry.add(idHint, name, item, this.availabilityMap);
        if (item instanceof abh) {
            if (itemId != idHint) {
                throw new IllegalStateException(String.format("ItemBlock at block id %d insertion failed, got id %d.", idHint, itemId));
            }
            this.verifyItemBlockName((abh)item);
        }
        this.useSlot(itemId);
        ((RegistryDelegate.Delegate)item.delegate).setName(name);
        return itemId;
    }

    int registerBlock(aji block, String name) {
        int index = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, index), name);
        }
        name = this.addPrefix(name);
        return this.registerBlock(block, name, -1);
    }

    private int registerBlock(aji block, String name, int idHint) {
        abh itemBlock = null;
        for (adb item : this.iItemRegistry.typeSafeIterable()) {
            if (!(item instanceof abh) || ((abh)item).a != block) continue;
            itemBlock = (abh)item;
            break;
        }
        if (itemBlock != null) {
            idHint = this.iItemRegistry.getId((adb)itemBlock);
            FMLLog.fine("Found matching ItemBlock %s for Block %s at id %d", itemBlock, block, idHint);
            this.freeSlot(idHint, block);
        }
        int blockId = this.iBlockRegistry.add(idHint, name, block, this.availabilityMap);
        if (itemBlock != null) {
            if (blockId != idHint) {
                throw new IllegalStateException(String.format("Block at itemblock id %d insertion failed, got id %d.", idHint, blockId));
            }
            this.verifyItemBlockName(itemBlock);
        }
        this.useSlot(blockId);
        ((RegistryDelegate.Delegate)block.delegate).setName(name);
        return blockId;
    }

    private void block(int id) {
        this.blockedIds.add(id);
        this.useSlot(id);
    }

    private void useSlot(int id) {
        this.availabilityMap.set(id);
    }

    private void freeSlot(int id, Object obj) {
        FMLControlledNamespacedRegistry<Object> registry = obj instanceof aji ? this.iBlockRegistry : this.iItemRegistry;
        aji thing = registry.getRaw(id);
        if (thing != null && thing != obj) {
            throw new IllegalStateException(String.format("Can't free registry slot %d occupied by %s", id, thing));
        }
        this.availabilityMap.clear(id);
    }

    private String addPrefix(String name) {
        ModContainer mc;
        String prefix;
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        if (!oldPrefix.equals(prefix = (mc = Loader.instance().activeModContainer()) != null ? mc.getModId() : "minecraft")) {
            name = prefix + ":" + name;
        }
        return name;
    }

    private void verifyItemBlockName(abh item) {
        String blockName = this.iBlockRegistry.c(item.a);
        String itemName = this.iItemRegistry.c(item);
        if (blockName != null && !blockName.equals(itemName)) {
            FMLLog.bigWarning("Block <-> ItemBlock name mismatch, block name %s, item name %s", blockName, itemName);
        }
    }

    private void testConsistency() {
        int i = this.availabilityMap.nextSetBit(0);
        while (i >= 0) {
            if (this.iBlockRegistry.getRaw(i) == null && this.iItemRegistry.getRaw(i) == null && !this.blockedIds.contains(i)) {
                throw new IllegalStateException(String.format("availabilityMap references empty entries for id %d.", i));
            }
            i = this.availabilityMap.nextSetBit(i + 1);
        }
        for (int pass = 0; pass < 2; ++pass) {
            boolean isBlock = pass == 0;
            String type = isBlock ? "block" : "item";
            FMLControlledNamespacedRegistry<aji> registry = isBlock ? this.iBlockRegistry : this.iItemRegistry;
            registry.validateContent(isBlock ? 4095 : 31999, type, this.availabilityMap, this.blockedIds, this.iBlockRegistry);
        }
        FMLLog.fine("Registry consistency check successful", new Object[0]);
    }

    void registerSubstitutionAlias(String nameToSubstitute, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        type.getRegistry().addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, toReplace);
    }

    static <T> RegistryDelegate<T> buildDelegate(T referant, Class<T> type) {
        return new RegistryDelegate.Delegate<T>(referant, type);
    }

    <T> BiMap<String, T> getPersistentSubstitutionMap(Class<T> type) {
        if (type.equals(adb.class)) {
            return this.itemSubstitutions;
        }
        if (type.equals(aji.class)) {
            return this.blockSubstitutions;
        }
        throw new RuntimeException("WHAT?");
    }

    public static class GameDataSnapshot {
        public final Map<String, Integer> idMap;
        public final Set<String> blockSubstitutions;
        public final Set<String> itemSubstitutions;

        public GameDataSnapshot(Map<String, Integer> idMap, Set<String> blockSubstitutions, Set<String> itemSubstitutions) {
            this.idMap = idMap;
            this.blockSubstitutions = blockSubstitutions;
            this.itemSubstitutions = itemSubstitutions;
        }
    }
}

