/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = ahu.n().length;
    private static BiomeInfo[] biomeList = new BiomeInfo[BIOME_LIST_SIZE];
    private static ArrayList<ahu>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(ahu biome, Type ... types) {
        types = BiomeDictionary.listSubTags(types);
        if (ahu.n()[biome.ay] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.ay] == null) {
                BiomeDictionary.biomeList[biome.ay] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.ay].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static ahu[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new ahu[0]);
        }
        return new ahu[0];
    }

    public static Type[] getTypesForBiome(ahu biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.ay] != null) {
            return BiomeDictionary.biomeList[biome.ay].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(ahu biomeA, ahu biomeB) {
        int a2 = biomeA.ay;
        int b2 = biomeB.ay;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(ahu biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.ay] != null) {
            return BiomeDictionary.containsType(biomeList[biome.ay], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(ahu biome) {
        return biomeList[biome.ay] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        FMLLog.warning("Redundant call to BiomeDictionary.registerAllBiomes ignored", new Object[0]);
    }

    public static void registerAllBiomesAndGenerateEvents() {
        for (int i = 0; i < ahu.n().length; ++i) {
            ahu biome = ahu.n()[i];
            if (biome == null) continue;
            if (biome.ar instanceof DeferredBiomeDecorator) {
                DeferredBiomeDecorator decorator = (DeferredBiomeDecorator)biome.ar;
                decorator.fireCreateEventAndReplace(biome);
            }
            BiomeDictionary.checkRegistration(biome);
        }
    }

    public static void makeBestGuess(ahu biome) {
        if (biome.ar.x >= 3) {
            if (biome.f() && biome.ao >= 0.9f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.f()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
                if (biome.ao <= 0.2f) {
                    BiomeDictionary.registerBiomeType(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.an <= 0.3f && biome.an >= 0.0f && (!biome.f() || biome.am >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.ap > 0.85f) {
            BiomeDictionary.registerBiomeType(biome, Type.WET);
        }
        if (biome.ap < 0.15f) {
            BiomeDictionary.registerBiomeType(biome, Type.DRY);
        }
        if (biome.ao > 0.85f) {
            BiomeDictionary.registerBiomeType(biome, Type.HOT);
        }
        if (biome.ao < 0.15f) {
            BiomeDictionary.registerBiomeType(biome, Type.COLD);
        }
        if (biome.ar.x > 0 && biome.ar.x < 3) {
            BiomeDictionary.registerBiomeType(biome, Type.SPARSE);
        } else if (biome.ar.x >= 10) {
            BiomeDictionary.registerBiomeType(biome, Type.DENSE);
        }
        if (biome.f() && biome.am < 0.0f && biome.an <= 0.3f && biome.an >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.am <= -0.5f) {
            if (biome.an == 0.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.RIVER);
            } else {
                BiomeDictionary.registerBiomeType(biome, Type.OCEAN);
            }
        }
        if (biome.an >= 0.4f && biome.an < 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.HILLS);
        }
        if (biome.an >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.d()) {
            BiomeDictionary.registerBiomeType(biome, Type.SNOWY);
        }
        if (biome.ai != ajn.m && biome.ao >= 1.0f && biome.ap < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.SAVANNA);
        }
        if (biome.ai == ajn.m) {
            BiomeDictionary.registerBiomeType(biome, Type.SANDY);
        } else if (biome.ai == ajn.ch) {
            BiomeDictionary.registerBiomeType(biome, Type.MESA);
        } else if (biome.ai == ajn.bh) {
            BiomeDictionary.registerBiomeType(biome, Type.MUSHROOM);
        }
    }

    private static void checkRegistration(ahu biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        if (type.hasSubTags()) {
            for (Type remappedType : BiomeDictionary.listSubTags(type)) {
                if (!info.typeList.contains((Object)remappedType)) continue;
                return true;
            }
            return false;
        }
        return info.typeList.contains((Object)type);
    }

    private static Type[] listSubTags(Type ... types) {
        ArrayList<Type> subTags = new ArrayList<Type>();
        for (Type type : types) {
            if (type.hasSubTags()) {
                subTags.addAll(type.subTags);
                continue;
            }
            subTags.add(type);
        }
        return subTags.toArray(new Type[subTags.size()]);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(ahu.o, Type.OCEAN);
        BiomeDictionary.registerBiomeType(ahu.p, Type.PLAINS);
        BiomeDictionary.registerBiomeType(ahu.q, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.registerBiomeType(ahu.r, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.s, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.t, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.H, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.u, Type.WET, Type.SWAMP);
        BiomeDictionary.registerBiomeType(ahu.v, Type.RIVER);
        BiomeDictionary.registerBiomeType(ahu.y, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.registerBiomeType(ahu.z, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.registerBiomeType(ahu.A, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.registerBiomeType(ahu.B, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(ahu.E, Type.BEACH);
        BiomeDictionary.registerBiomeType(ahu.F, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.J, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(ahu.K, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.G, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.x, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.registerBiomeType(ahu.w, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.registerBiomeType(ahu.C, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(ahu.I, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(ahu.D, Type.MUSHROOM, Type.BEACH);
        BiomeDictionary.registerBiomeType(ahu.L, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.M, Type.OCEAN);
        BiomeDictionary.registerBiomeType(ahu.N, Type.BEACH);
        BiomeDictionary.registerBiomeType(ahu.O, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.registerBiomeType(ahu.P, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.Q, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.R, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.S, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.registerBiomeType(ahu.T, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.U, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.V, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(ahu.W, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.registerBiomeType(ahu.X, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.registerBiomeType(ahu.Y, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.registerBiomeType(ahu.Z, Type.MESA, Type.SANDY);
        BiomeDictionary.registerBiomeType(ahu.aa, Type.MESA, Type.SPARSE, Type.SANDY);
        BiomeDictionary.registerBiomeType(ahu.ab, Type.MESA, Type.SANDY);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t : types) {
                this.typeList.add(t);
            }
        }
    }

    public static enum Type {
        HOT(new Type[0]),
        COLD(new Type[0]),
        SPARSE(new Type[0]),
        DENSE(new Type[0]),
        WET(new Type[0]),
        DRY(new Type[0]),
        SAVANNA(new Type[0]),
        CONIFEROUS(new Type[0]),
        JUNGLE(new Type[0]),
        SPOOKY(new Type[0]),
        DEAD(new Type[0]),
        LUSH(new Type[0]),
        NETHER(new Type[0]),
        END(new Type[0]),
        MUSHROOM(new Type[0]),
        MAGICAL(new Type[0]),
        OCEAN(new Type[0]),
        RIVER(new Type[0]),
        WATER(OCEAN, RIVER),
        MESA(new Type[0]),
        FOREST(new Type[0]),
        PLAINS(new Type[0]),
        MOUNTAIN(new Type[0]),
        HILLS(new Type[0]),
        SWAMP(new Type[0]),
        SANDY(new Type[0]),
        SNOWY(new Type[0]),
        WASTELAND(new Type[0]),
        BEACH(new Type[0]),
        DESERT(SANDY),
        FROZEN(SNOWY);

        private List<Type> subTags;

        private Type(Type ... subTags) {
            this.subTags = Arrays.asList(subTags);
        }

        private boolean hasSubTags() {
            return this.subTags != null && !this.subTags.isEmpty();
        }

        public static Type getType(String name, Type ... subTypes) {
            name = name.toUpperCase();
            for (Type t : Type.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            return EnumHelper.addEnum(Type.class, name, new Class[]{Type[].class}, new Object[]{subTypes});
        }
    }
}

