/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class NetworkModHolder {
    private static int assignedIds = 1;
    private int localId;
    private int networkId;
    private ModContainer container;
    private Method checkHandler;
    private VersionRange acceptableRange;
    private NetworkChecker checker;

    public NetworkModHolder(ModContainer container) {
        this.container = container;
        this.networkId = this.localId = assignedIds++;
    }

    public NetworkModHolder(ModContainer container, NetworkChecker checker) {
        this(container);
        this.checker = (NetworkChecker)Preconditions.checkNotNull((Object)checker);
        FMLLog.fine("The mod %s is using a custom checker %s", container.getModId(), checker.getClass().getName());
    }

    public NetworkModHolder(ModContainer container, Class<?> modClass, String acceptableVersionRange, ASMDataTable table) {
        this(container);
        SetMultimap<String, ASMDataTable.ASMData> annotationTable = table.getAnnotationsFor(container);
        Set versionCheckHandlers = annotationTable != null ? annotationTable.get((Object)NetworkCheckHandler.class.getName()) : ImmutableSet.of();
        String networkCheckHandlerMethod = null;
        Iterator i$ = versionCheckHandlers.iterator();
        while (i$.hasNext()) {
            ASMDataTable.ASMData vch = (ASMDataTable.ASMData)i$.next();
            if (!vch.getClassName().equals(modClass.getName())) continue;
            networkCheckHandlerMethod = vch.getObjectName();
            networkCheckHandlerMethod = networkCheckHandlerMethod.substring(0, networkCheckHandlerMethod.indexOf(40));
            break;
        }
        if (versionCheckHandlers.isEmpty()) {
            for (Method m : modClass.getMethods()) {
                if (!m.isAnnotationPresent(NetworkCheckHandler.class)) continue;
                if (m.getParameterTypes().length == 2 && m.getParameterTypes()[0].equals(Map.class) && m.getParameterTypes()[1].equals(Side.class)) {
                    this.checkHandler = m;
                    break;
                }
                FMLLog.severe("Found unexpected method signature for annotation NetworkCheckHandler", new Object[0]);
            }
        }
        if (networkCheckHandlerMethod != null) {
            try {
                Method checkHandlerMethod = modClass.getDeclaredMethod(networkCheckHandlerMethod, Map.class, Side.class);
                if (checkHandlerMethod.isAnnotationPresent(NetworkCheckHandler.class)) {
                    this.checkHandler = checkHandlerMethod;
                }
            }
            catch (Exception e) {
                FMLLog.log(Level.WARN, e, "The declared version check handler method %s on network mod id %s is not accessible", networkCheckHandlerMethod, container.getModId());
            }
        }
        if (this.checkHandler != null) {
            this.checker = new MethodNetworkChecker();
        } else if (!Strings.isNullOrEmpty((String)acceptableVersionRange) && acceptableVersionRange.equals("*")) {
            this.checker = new IgnoredChecker();
        } else {
            try {
                this.acceptableRange = VersionRange.createFromVersionSpec(acceptableVersionRange);
            }
            catch (InvalidVersionSpecificationException e) {
                FMLLog.log(Level.WARN, e, "Invalid bounded range %s specified for network mod id %s", acceptableVersionRange, container.getModId());
            }
            this.checker = new DefaultNetworkChecker();
        }
        FMLLog.finer("Mod %s is using network checker : %s", container.getModId(), this.checker);
        FMLLog.finer("Testing mod %s to verify it accepts its own version in a remote connection", container.getModId());
        boolean acceptsSelf = this.acceptVersion(container.getVersion());
        if (!acceptsSelf) {
            FMLLog.severe("The mod %s appears to reject its own version number (%s) in its version handling. This is likely a severe bug in the mod!", container.getModId(), container.getVersion());
        } else {
            FMLLog.finer("The mod %s accepts its own version (%s)", container.getModId(), container.getVersion());
        }
    }

    public boolean acceptVersion(String version) {
        if (this.acceptableRange != null) {
            return this.acceptableRange.containsVersion(new DefaultArtifactVersion(version));
        }
        return this.container.getVersion().equals(version);
    }

    public boolean check(Map<String, String> data, Side side) {
        return this.checker.check(data, side);
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public ModContainer getContainer() {
        return this.container;
    }

    public void setNetworkId(int value) {
        this.networkId = value;
    }

    private class MethodNetworkChecker
    extends NetworkChecker {
        private MethodNetworkChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            try {
                return (Boolean)NetworkModHolder.this.checkHandler.invoke(NetworkModHolder.this.container.getMod(), new Object[]{remoteVersions, side});
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "Error occurred invoking NetworkCheckHandler %s at %s", NetworkModHolder.this.checkHandler.getName(), NetworkModHolder.this.container);
                return false;
            }
        }

        public String toString() {
            return String.format("Invoking method %s", NetworkModHolder.this.checkHandler.getName());
        }
    }

    private class DefaultNetworkChecker
    extends NetworkChecker {
        private DefaultNetworkChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return remoteVersions.containsKey(NetworkModHolder.this.container.getModId()) ? NetworkModHolder.this.acceptVersion(remoteVersions.get(NetworkModHolder.this.container.getModId())) : side == Side.SERVER;
        }

        public String toString() {
            return NetworkModHolder.this.acceptableRange != null ? String.format("Accepting range %s", NetworkModHolder.this.acceptableRange) : String.format("Accepting version %s", NetworkModHolder.this.container.getVersion());
        }
    }

    private class IgnoredChecker
    extends NetworkChecker {
        private IgnoredChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return true;
        }

        public String toString() {
            return "No network checking performed";
        }
    }

    public abstract class NetworkChecker {
        public abstract boolean check(Map<String, String> var1, Side var2);
    }
}

