# no-multiline-string-literals

Continuing a string across a linebreak is supported in most script engines, but it is not a part of ECMAScript. 
Additionally, the whitespace at the beginning of each line can't be safely stripped at compile time, and any whitespace 
after the slash will result in tricky errors.

## Noncompliant Code Example

```typescript
let myString = 'A rather long string of English text, an error message \
                actually that just keeps going and going -- an error \
                message to make the Energizer bunny blush (right through \
                those Schwarzenegger shades)! Where was I? Oh yes, \
                you\'ve got an error and all the extraneous whitespace is \
                just gravy.  Have a nice day.';
```

## Compliant Solution

```typescript
let myString = 'A rather long string of English text, an error message ' +
    'actually that just keeps going and going -- an error ' +
    'message to make the Energizer bunny blush (right through ' +
    'those Schwarzenegger shades)! Where was I? Oh yes, ' +
    'you\'ve got an error and all the extraneous whitespace is ' +
    'just gravy.  Have a nice day.';
```
