/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.Resources;

public final class ProfileDefinitionReader {
    private final RuleFinder ruleFinder;

    public ProfileDefinitionReader(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public void activateRules(RulesProfile profile, String repositoryKey, String profilePath) {
        Set<String> activeKeys = ProfileDefinitionReader.loadActiveKeysFromJsonProfile(profilePath);
        for (String activeKey : activeKeys) {
            Rule rule = this.ruleFinder.findByKey(repositoryKey, activeKey);
            if (rule == null) {
                String errorMessage = "Failed to activate rule with key '%s'. No corresponding rule found in repository with key '%s'.";
                throw new IllegalStateException(String.format(errorMessage, activeKey, repositoryKey));
            }
            profile.activateRule(rule, null);
        }
    }

    static Set<String> loadActiveKeysFromJsonProfile(String profilePath) {
        Map<String, Object> root;
        JsonParser jsonParser = new JsonParser();
        try {
            root = jsonParser.parse(Resources.toString(profilePath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + profilePath, e);
        }
        Map ruleKeys = (Map)root.get("ruleKeys");
        if (ruleKeys == null) {
            throw new IllegalStateException("missing 'ruleKeys'");
        }
        return ruleKeys.values().stream().map(Object::toString).collect(Collectors.toSet());
    }
}

