/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript.lcov;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class LCOVParser {
    private static final String SF = "SF:";
    private static final String DA = "DA:";
    private static final String BRDA = "BRDA:";
    private final SensorContext context;
    private final List<String> unresolvedPaths = new ArrayList<String>();
    private static final Logger LOG = Loggers.get(LCOVParser.class);

    public LCOVParser(SensorContext context) {
        this.context = context;
    }

    public void parseReportsAndSaveCoverage(List<File> files) {
        LinkedList<String> lines = new LinkedList<String>();
        for (File file : files) {
            try {
                Stream<String> fileLines = Files.lines(file.toPath());
                Throwable throwable = null;
                try {
                    lines.addAll(fileLines.collect(Collectors.toList()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileLines == null) continue;
                    if (throwable != null) {
                        try {
                            fileLines.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileLines.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read content from file: " + file, e);
            }
        }
        this.parse(lines);
    }

    List<String> unresolvedPaths() {
        return this.unresolvedPaths;
    }

    private void parse(List<String> lines) {
        HashMap<InputFile, FileData> files = new HashMap<InputFile, FileData>();
        FileData fileData = null;
        int reportLineNum = 0;
        for (String string : lines) {
            ++reportLineNum;
            if (string.startsWith(SF)) {
                fileData = this.loadCurrentFileData(files, string);
                continue;
            }
            if (fileData == null) continue;
            if (string.startsWith(DA)) {
                LCOVParser.parseLineCoverage(fileData, reportLineNum, string);
                continue;
            }
            if (!string.startsWith(BRDA)) continue;
            LCOVParser.parseBranchCoverage(fileData, reportLineNum, string);
        }
        for (Map.Entry entry : files.entrySet()) {
            NewCoverage newCoverage = this.context.newCoverage().onFile((InputFile)entry.getKey());
            ((FileData)entry.getValue()).save(newCoverage);
        }
    }

    private static void parseBranchCoverage(FileData fileData, int reportLineNum, String line) {
        try {
            String[] tokens = line.substring(BRDA.length()).trim().split(",");
            String lineNumber = tokens[0];
            String branchNumber = tokens[1] + tokens[2];
            String taken = tokens[3];
            fileData.addBranch(Integer.valueOf(lineNumber), branchNumber, "-".equals(taken) ? 0 : Integer.valueOf(taken));
        }
        catch (Exception e) {
            LCOVParser.logWrongDataWarning("BRDA", reportLineNum, e);
        }
    }

    private static void parseLineCoverage(FileData fileData, int reportLineNum, String line) {
        try {
            String execution = line.substring(DA.length());
            String executionCount = execution.substring(execution.indexOf(44) + 1);
            String lineNumber = execution.substring(0, execution.indexOf(44));
            fileData.addLine(Integer.valueOf(lineNumber), Integer.valueOf(executionCount));
        }
        catch (Exception e) {
            LCOVParser.logWrongDataWarning("DA", reportLineNum, e);
        }
    }

    private static void logWrongDataWarning(String dataType, int reportLineNum, Exception e) {
        LOG.warn(String.format("Problem during processing LCOV report: can't save %s data for line %s of coverage report file (%s).", dataType, reportLineNum, e.toString()));
    }

    @CheckForNull
    private FileData loadCurrentFileData(Map<InputFile, FileData> files, String line) {
        String filePath = line.substring(SF.length());
        FileData fileData = null;
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasPath(filePath));
        if (inputFile != null) {
            fileData = files.get(inputFile);
            if (fileData == null) {
                fileData = new FileData(inputFile);
                files.put(inputFile, fileData);
            }
        } else {
            this.unresolvedPaths.add(filePath);
        }
        return fileData;
    }

    private static class FileData {
        private Map<Integer, Map<String, Integer>> branches = new HashMap<Integer, Map<String, Integer>>();
        private Map<Integer, Integer> hits = new HashMap<Integer, Integer>();
        private final int linesInFile;
        private final String filename;
        private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number %s doesn't belong to file %s";

        FileData(InputFile inputFile) {
            this.linesInFile = inputFile.lines();
            this.filename = inputFile.relativePath();
        }

        void addBranch(Integer lineNumber, String branchNumber, Integer taken) {
            this.checkLine(lineNumber);
            Map<String, Integer> branchesForLine = this.branches.get(lineNumber);
            if (branchesForLine == null) {
                branchesForLine = new HashMap<String, Integer>();
                this.branches.put(lineNumber, branchesForLine);
            }
            Integer currentValue = branchesForLine.get(branchNumber);
            branchesForLine.put(branchNumber, Optional.ofNullable(currentValue).orElse(0) + taken);
        }

        void addLine(Integer lineNumber, Integer executionCount) {
            this.checkLine(lineNumber);
            Integer currentValue = this.hits.get(lineNumber);
            this.hits.put(lineNumber, Optional.ofNullable(currentValue).orElse(0) + executionCount);
        }

        void save(NewCoverage newCoverage) {
            for (Map.Entry<Integer, Integer> entry : this.hits.entrySet()) {
                newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().intValue());
            }
            for (Map.Entry<Integer, Object> entry : this.branches.entrySet()) {
                int conditions = ((Map)entry.getValue()).size();
                int covered = 0;
                for (Integer taken : ((Map)entry.getValue()).values()) {
                    if (taken <= 0) continue;
                    ++covered;
                }
                newCoverage.conditions(entry.getKey().intValue(), conditions, covered);
            }
            newCoverage.ofType(CoverageType.UNIT).save();
        }

        private void checkLine(Integer lineNumber) {
            if (lineNumber < 1 || lineNumber > this.linesInFile) {
                throw new IllegalArgumentException(String.format(WRONG_LINE_EXCEPTION_MESSAGE, lineNumber, this.filename));
            }
        }
    }
}

