/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript.executable;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.SensorContextUtils;
import org.sonar.plugin.typescript.TypeScriptRules;
import org.sonar.plugin.typescript.executable.ExecutableBundle;
import org.sonar.plugin.typescript.executable.SonarTSCommand;

public class SonarTSCoreBundle
implements ExecutableBundle {
    private static final Logger LOG = Loggers.get(SonarTSCoreBundle.class);
    private static final int NODE_PROCESS_MEMORY = 2048;
    private static final String BIN = "node_modules/tslint-sonarts/bin/";
    private final Configuration configuration;
    private File deployDestination;
    private String bundleLocation;
    private File sonartsRunnerExecutable;
    private File sonartsServerExecutable;

    private SonarTSCoreBundle(String bundleLocation, File deployDestination, Configuration configuration) {
        this.bundleLocation = bundleLocation;
        this.deployDestination = deployDestination;
        this.configuration = configuration;
        File sonartsCoreDir = new File(deployDestination, "sonarts-bundle");
        this.sonartsRunnerExecutable = new File(sonartsCoreDir, "node_modules/tslint-sonarts/bin/tsrunner");
        this.sonartsServerExecutable = new File(sonartsCoreDir, "node_modules/tslint-sonarts/bin/sonarts-server");
    }

    static SonarTSCoreBundle createAndDeploy(String bundleLocation, File deployDestination, Configuration configuration) {
        LOG.debug(String.format("Deploying bundle from `%s` to `%s`", bundleLocation, deployDestination.getAbsolutePath()));
        SonarTSCoreBundle sonarTSCoreBundle = new SonarTSCoreBundle(bundleLocation, deployDestination, configuration);
        sonarTSCoreBundle.deploy();
        return sonarTSCoreBundle;
    }

    private void deploy() {
        try {
            File copiedFile = this.copyTo(this.deployDestination);
            SonarTSCoreBundle.extract(copiedFile);
            Files.delete(copiedFile.toPath());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deploy SonarTS bundle (with classpath '" + this.bundleLocation + "')", e);
        }
    }

    @Override
    public SonarTSCommand getSonarTsRunnerCommand() {
        return this.getCommand(this.sonartsRunnerExecutable, new String[0]);
    }

    @Override
    public String getRequestForRunner(String tsconfigPath, Iterable<InputFile> inputFiles, TypeScriptRules typeScriptRules) {
        SonarTSRequest request = new SonarTSRequest();
        request.filepaths = (String[])StreamSupport.stream(inputFiles.spliterator(), false).map(inputFile -> Paths.get(inputFile.uri()).toString()).toArray(String[]::new);
        request.tsconfig = tsconfigPath;
        request.rules = SensorContextUtils.convertToRulesToExecute(typeScriptRules);
        return new Gson().toJson(request);
    }

    private SonarTSCommand getCommand(File executable, String ... additionalArgs) {
        String increaseMemory = "--max-old-space-size=2048";
        Stream<String> args = Stream.of(this.getNodeExecutable(), increaseMemory, executable.getAbsolutePath());
        return new SonarTSCommand((String[])Stream.concat(args, Arrays.stream(additionalArgs)).toArray(String[]::new));
    }

    @Override
    public String getNodeExecutable() {
        return this.configuration.get("sonar.typescript.node").orElse("node");
    }

    @Override
    public SonarTSCommand getSonarTSServerCommand(int port) {
        return this.getCommand(this.sonartsServerExecutable, String.valueOf(port));
    }

    private File copyTo(File targetPath) throws IOException {
        File destination = new File(targetPath, this.bundleLocation);
        FileUtils.copyInputStreamToFile(this.getClass().getResourceAsStream(this.bundleLocation), destination);
        return destination;
    }

    private static void extract(File copiedFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(copiedFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(copiedFile.getParent(), entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy(in, (OutputStream)out);
                IOUtils.closeQuietly(in);
                ((OutputStream)out).close();
            }
        }
    }

    private static class SonarTSRequest {
        String[] filepaths;
        String tsconfig;
        List<SensorContextUtils.RuleToExecute> rules;

        private SonarTSRequest() {
        }
    }
}

