/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript;

import org.sonar.api.Plugin;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugin.typescript.ContextualSensor;
import org.sonar.plugin.typescript.ContextualServer;
import org.sonar.plugin.typescript.ExternalProcessStreamConsumer;
import org.sonar.plugin.typescript.ExternalTypescriptSensor;
import org.sonar.plugin.typescript.SonarWayProfile;
import org.sonar.plugin.typescript.SonarWayRecommendedProfile;
import org.sonar.plugin.typescript.TypeScriptExclusionsFileFilter;
import org.sonar.plugin.typescript.TypeScriptLanguage;
import org.sonar.plugin.typescript.TypeScriptRulesDefinition;
import org.sonar.plugin.typescript.executable.SonarTSCoreBundleFactory;
import org.sonar.plugin.typescript.lcov.LCOVCoverageSensor;

public class TypeScriptPlugin
implements Plugin {
    private static final String SONARTS_BUNDLE_ZIP = "/sonarts-bundle.zip";
    private static final String TESTS_AND_COVERAGE_SUBCATEGORY = "Tests and Coverage";
    private static final String TYPESCRIPT_CATEGORY = "TypeScript";
    private static final String GENERAL_SUBCATEGORY = "General";
    static final String FILE_SUFFIXES_KEY = "sonar.typescript.file.suffixes";
    public static final String FILE_SUFFIXES_DEFVALUE = ".ts,.tsx";
    public static final String LCOV_REPORT_PATHS = "sonar.typescript.lcov.reportPaths";
    public static final String LCOV_REPORT_PATHS_DEFAULT_VALUE = "";
    public static final String NODE_EXECUTABLE = "sonar.typescript.node";
    public static final String NODE_EXECUTABLE_DEFAULT = "node";
    public static final String TS_EXCLUSIONS_KEY = "sonar.typescript.exclusions";
    public static final String TS_EXCLUSIONS_DEFAULT_VALUE = "**/node_modules/**,**/bower_components/**";

    public void define(Plugin.Context context) {
        context.addExtensions(ExternalProcessStreamConsumer.class, TypeScriptLanguage.class, new Object[]{SonarWayProfile.class, SonarWayRecommendedProfile.class, TypeScriptRulesDefinition.class, TypeScriptExclusionsFileFilter.class, new SonarTSCoreBundleFactory(SONARTS_BUNDLE_ZIP), PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).defaultValue(FILE_SUFFIXES_DEFVALUE).name("File Suffixes").description("Comma-separated list of suffixes for files to analyze.").subCategory(GENERAL_SUBCATEGORY).category(TYPESCRIPT_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)LCOV_REPORT_PATHS).defaultValue(LCOV_REPORT_PATHS_DEFAULT_VALUE).name("LCOV Files").description("Paths (absolute or relative) to the files with LCOV data.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(TESTS_AND_COVERAGE_SUBCATEGORY).category(TYPESCRIPT_CATEGORY).multiValues(true).build(), PropertyDefinition.builder((String)NODE_EXECUTABLE).defaultValue(NODE_EXECUTABLE_DEFAULT).name("Node.js executable").description("Node.js executable used to run the analysis.").subCategory(GENERAL_SUBCATEGORY).category(TYPESCRIPT_CATEGORY).onQualifiers("TRK", new String[0]).build(), PropertyDefinition.builder((String)TS_EXCLUSIONS_KEY).defaultValue(TS_EXCLUSIONS_DEFAULT_VALUE).name("TypeScript Exclusions").description("List of file path patterns to be excluded from analysis of TypeScript files.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(GENERAL_SUBCATEGORY).multiValues(true).category(TYPESCRIPT_CATEGORY).build()});
        if (context.getRuntime().getProduct().equals((Object)SonarProduct.SONARLINT)) {
            context.addExtension(ContextualSensor.class);
            context.addExtension(ContextualServer.class);
        } else {
            context.addExtension(ExternalTypescriptSensor.class);
            context.addExtension(LCOVCoverageSensor.class);
        }
    }
}

