/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript;

import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugin.typescript.TypeScriptRules;

public class SensorContextUtils {
    private SensorContextUtils() {
    }

    static void saveIssues(SensorContext sensorContext, Issue[] issues, TypeScriptRules typeScriptRules) {
        FileSystem fs = sensorContext.fileSystem();
        for (Issue issue : issues) {
            InputFile inputFile = fs.inputFile(fs.predicates().hasAbsolutePath(issue.name));
            if (inputFile == null) continue;
            SensorContextUtils.saveIssue(sensorContext, typeScriptRules, issue, inputFile);
        }
    }

    public static List<RuleToExecute> convertToRulesToExecute(TypeScriptRules typeScriptRules) {
        ArrayList<RuleToExecute> rulesToExecute = new ArrayList<RuleToExecute>();
        typeScriptRules.forEach(rule -> {
            if (rule.isEnabled()) {
                rulesToExecute.add(new RuleToExecute(rule.tsLintKey(), rule.configuration()));
            }
        });
        return rulesToExecute;
    }

    static void setNodePath(File typescriptLocation, ProcessBuilder processBuilder) {
        Map<String, String> environment = processBuilder.environment();
        environment.put("NODE_PATH", typescriptLocation.getAbsolutePath() + File.pathSeparator + environment.getOrDefault("NODE_PATH", ""));
    }

    static void saveIssue(SensorContext sensorContext, TypeScriptRules typeScriptRules, Issue issue, InputFile inputFile) {
        RuleKey ruleKey = typeScriptRules.ruleKeyFromTsLintKey(issue.ruleName);
        NewIssue newIssue = sensorContext.newIssue().forRule(ruleKey);
        NewIssueLocation location = newIssue.newLocation();
        location.on((InputComponent)inputFile);
        location.message(issue.failure);
        if (ruleKey.rule().equals("S1438")) {
            location.at(inputFile.selectLine(issue.startPosition.line + 1));
        } else if (!TypeScriptRules.FILE_LEVEL_RULES.contains(ruleKey.rule())) {
            location.at(inputFile.newRange(issue.startPosition.line + 1, issue.startPosition.character.intValue(), issue.endPosition.line + 1, issue.endPosition.character.intValue()));
        }
        newIssue.at(location);
        if (issue.secondaryLocations != null) {
            for (SecondaryLocation secondaryLocation : issue.secondaryLocations) {
                NewIssueLocation newSecondaryLocation = newIssue.newLocation().on((InputComponent)inputFile);
                SensorContextUtils.setSecondaryLocation(newSecondaryLocation, secondaryLocation, inputFile);
                newIssue.addLocation(newSecondaryLocation);
            }
        }
        if (issue.cost != null) {
            newIssue.gap(issue.cost);
        }
        newIssue.save();
    }

    private static void setSecondaryLocation(NewIssueLocation newSecondaryLocation, SecondaryLocation secondaryLocation, InputFile inputFile) {
        newSecondaryLocation.at(inputFile.newRange(secondaryLocation.startLine + 1, secondaryLocation.startCol.intValue(), secondaryLocation.endLine + 1, secondaryLocation.endCol.intValue()));
        if (secondaryLocation.message != null) {
            newSecondaryLocation.message(secondaryLocation.message);
        }
    }

    static Iterable<InputFile> getInputFiles(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicate mainFilePredicate = sensorContext.fileSystem().predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("ts"));
        return fileSystem.inputFiles(mainFilePredicate);
    }

    public static class RuleToExecute {
        final String ruleName;
        final JsonElement ruleArguments;

        public RuleToExecute(String ruleName, JsonElement ruleArguments) {
            this.ruleName = ruleName;
            this.ruleArguments = ruleArguments;
        }
    }

    static class ContextualAnalysisRequest {
        String file;
        String content;
        List<RuleToExecute> rules;

        ContextualAnalysisRequest(InputFile inputFile, TypeScriptRules typeScriptRules) throws IOException {
            Path path = Paths.get(inputFile.uri());
            this.file = path.toString();
            this.content = inputFile.contents();
            this.rules = SensorContextUtils.convertToRulesToExecute(typeScriptRules);
        }
    }

    static class SymbolReference {
        Integer startLine;
        Integer startCol;
        Integer endLine;
        Integer endCol;

        SymbolReference() {
        }
    }

    static class Symbol {
        Integer startLine;
        Integer startCol;
        Integer endLine;
        Integer endCol;
        SymbolReference[] references;

        Symbol() {
        }
    }

    static class CpdToken {
        Integer startLine;
        Integer startCol;
        Integer endLine;
        Integer endCol;
        String image;

        CpdToken() {
        }
    }

    static class Highlight {
        Integer startLine;
        Integer startCol;
        Integer endLine;
        Integer endCol;
        String textType;

        Highlight() {
        }
    }

    static class AnalysisResponse {
        String filepath;
        Issue[] issues = new Issue[0];
        Highlight[] highlights = new Highlight[0];
        CpdToken[] cpdTokens = new CpdToken[0];
        Symbol[] symbols = new Symbol[0];
        int[] ncloc = new int[0];
        int[] commentLines = new int[0];
        Integer[] nosonarLines = new Integer[0];
        int[] executableLines = new int[0];
        int functions = 0;
        int statements = 0;
        int classes = 0;
        int complexity = 0;
        int cognitiveComplexity = 0;

        AnalysisResponse() {
        }
    }

    private static class SecondaryLocation {
        Integer startLine;
        Integer startCol;
        Integer endLine;
        Integer endCol;
        String message;

        private SecondaryLocation() {
        }
    }

    static class Position {
        Integer line;
        Integer character;

        public Position(Integer line, Integer character) {
            this.line = line;
            this.character = character;
        }

        public String toString() {
            return "[" + this.line + "," + this.character + "]";
        }
    }

    static class Issue {
        String failure;
        Position startPosition;
        Position endPosition;
        String name;
        String ruleName;
        SecondaryLocation[] secondaryLocations;
        Double cost;

        Issue() {
        }

        public String toString() {
            return this.failure + "\n start " + this.startPosition + "\n end " + this.endPosition + "\n name " + this.name + "\n ruleName " + this.ruleName + "\n cost " + this.cost;
        }
    }
}

