/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript;

import com.google.gson.Gson;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.ExternalProcessStreamConsumer;
import org.sonar.plugin.typescript.SensorContextUtils;
import org.sonar.plugin.typescript.TypeScriptRules;
import org.sonar.plugin.typescript.executable.ExecutableBundle;
import org.sonar.plugin.typescript.executable.ExecutableBundleFactory;
import org.sonar.plugin.typescript.executable.SonarTSCommand;

public class ExternalTypescriptSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(ExternalTypescriptSensor.class);
    private static final int MIN_NODE_VERSION = 6;
    private final CheckFactory checkFactory;
    private final ExternalProcessStreamConsumer errorConsumer;
    private final ExecutableBundleFactory executableBundleFactory;
    private final NoSonarFilter noSonarFilter;
    private final FileLinesContextFactory fileLinesContextFactory;

    public ExternalTypescriptSensor(ExecutableBundleFactory executableBundleFactory, NoSonarFilter noSonarFilter, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, ExternalProcessStreamConsumer errorConsumer) {
        this.executableBundleFactory = executableBundleFactory;
        this.noSonarFilter = noSonarFilter;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.checkFactory = checkFactory;
        this.errorConsumer = errorConsumer;
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        sensorDescriptor.onlyOnLanguage("ts").name("SonarTS").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext sensorContext) {
        File deployDestination = sensorContext.fileSystem().workDir();
        File typescriptLocation = ExternalTypescriptSensor.getTypescriptLocation(sensorContext.fileSystem().baseDir());
        if (typescriptLocation != null) {
            LOG.debug("TypeScript compiler is found in this directory " + typescriptLocation.getAbsolutePath());
            LOG.debug("It will be used for analysis of typescript files");
        } else {
            LOG.debug("No TypeScript compiler found in your project");
            LOG.debug("Global one referenced in 'NODE_PATH' will be used");
        }
        ExecutableBundle executableBundle = this.executableBundleFactory.createAndDeploy(deployDestination, sensorContext.config());
        Iterable<InputFile> inputFiles = SensorContextUtils.getInputFiles(sensorContext);
        TypeScriptRules typeScriptRules = new TypeScriptRules(this.checkFactory);
        this.analyze(inputFiles, sensorContext, typeScriptRules, executableBundle, typescriptLocation);
    }

    private void analyze(Iterable<InputFile> inputFiles, SensorContext sensorContext, TypeScriptRules typeScriptRules, ExecutableBundle executableBundle, @Nullable File localTypescript) {
        if (!ExternalTypescriptSensor.isCompatibleNodeVersion(executableBundle.getNodeExecutable())) {
            LOG.error("No TypeScript files will be analyzed");
            return;
        }
        File projectBaseDir = sensorContext.fileSystem().baseDir();
        Map<String, List<InputFile>> inputFileByTsconfig = ExternalTypescriptSensor.getInputFileByTsconfig(inputFiles, projectBaseDir);
        for (Map.Entry<String, List<InputFile>> e : inputFileByTsconfig.entrySet()) {
            SensorContextUtils.AnalysisResponse[] responses;
            String tsconfigPath = e.getKey();
            Collection inputFilesForThisConfig = e.getValue();
            LOG.debug(String.format("Analyzing %s typescript file(s) with the following configuration file %s", inputFilesForThisConfig.size(), tsconfigPath));
            SonarTSCommand command = executableBundle.getSonarTsRunnerCommand();
            String request = executableBundle.getRequestForRunner(tsconfigPath, inputFilesForThisConfig, typeScriptRules);
            for (SensorContextUtils.AnalysisResponse response : responses = this.executeExternalRunner(command, localTypescript, request)) {
                FileSystem fileSystem = sensorContext.fileSystem();
                InputFile inputFile = fileSystem.inputFile(fileSystem.predicates().hasAbsolutePath(response.filepath));
                if (inputFile != null) {
                    ExternalTypescriptSensor.saveHighlights(sensorContext, response.highlights, inputFile);
                    ExternalTypescriptSensor.saveSymbols(sensorContext, response.symbols, inputFile);
                    this.saveMetrics(sensorContext, response, inputFile);
                    ExternalTypescriptSensor.saveCpd(sensorContext, response.cpdTokens, inputFile);
                    SensorContextUtils.saveIssues(sensorContext, response.issues, typeScriptRules);
                    continue;
                }
                LOG.error("Failed to find input file for path `" + response.filepath + "`");
            }
        }
    }

    private static boolean isCompatibleNodeVersion(String nodeExecutable) {
        String version;
        LOG.debug("Checking node version");
        try {
            Process process = Runtime.getRuntime().exec(nodeExecutable + " -v");
            version = IOUtils.toString(process.getInputStream(), StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            LOG.error("Failed to get Node.js version", (Throwable)e);
            return false;
        }
        Pattern versionPattern = Pattern.compile("v?(\\d+)\\.\\d+\\.\\d+");
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            int major = Integer.parseInt(versionMatcher.group(1));
            if (major < 6) {
                LOG.error(String.format("Only Node.js v%s or later is supported, got %s", 6, version));
                return false;
            }
        } else {
            LOG.error(String.format("Failed to parse Node.js version, got '%s'", version));
            return false;
        }
        LOG.debug(String.format("Using Node.js %s", version));
        return true;
    }

    private static Map<String, List<InputFile>> getInputFileByTsconfig(Iterable<InputFile> inputFiles, File projectBaseDir) {
        HashMap<String, List<InputFile>> inputFileByTsconfig = new HashMap<String, List<InputFile>>();
        for (InputFile inputFile : inputFiles) {
            File tsConfig = ExternalTypescriptSensor.findTsConfig(inputFile, projectBaseDir);
            if (tsConfig == null) {
                LOG.error("No tsconfig.json file found for " + inputFile.uri() + " (looking up the directories tree). This file will not be analyzed.");
                continue;
            }
            inputFileByTsconfig.computeIfAbsent(tsConfig.getAbsolutePath(), x -> new ArrayList()).add(inputFile);
        }
        return inputFileByTsconfig;
    }

    @Nullable
    private static File findTsConfig(InputFile inputFile, File projectBaseDir) {
        File currentDirectory = inputFile.file();
        do {
            File tsconfig;
            if (!(tsconfig = new File(currentDirectory = currentDirectory.getParentFile(), "tsconfig.json")).exists()) continue;
            return tsconfig;
        } while (!currentDirectory.getAbsolutePath().equals(projectBaseDir.getAbsolutePath()));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SensorContextUtils.AnalysisResponse[] executeExternalRunner(SonarTSCommand command, @Nullable File localTypescript, String request) {
        String commandLine = command.commandLine();
        ProcessBuilder processBuilder = new ProcessBuilder(command.commandLineTokens());
        if (localTypescript != null) {
            LOG.debug("Setting 'NODE_PATH' to " + localTypescript);
            SensorContextUtils.setNodePath(localTypescript, processBuilder);
        }
        LOG.debug(String.format("Starting external process `%s`", commandLine));
        try {
            Process process = processBuilder.start();
            this.errorConsumer.consumeStream(process.getErrorStream(), new DetectMissingTypescript());
            OutputStreamWriter writerToSonar = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
            writerToSonar.write(request);
            writerToSonar.close();
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                SensorContextUtils.AnalysisResponse[] responses = new Gson().fromJson((Reader)inputStreamReader, SensorContextUtils.AnalysisResponse[].class);
                if (responses == null) {
                    LOG.error(String.format("External process `%s` returned an empty output. Run with -X for more information", commandLine));
                    SensorContextUtils.AnalysisResponse[] analysisResponseArray = new SensorContextUtils.AnalysisResponse[]{};
                    return analysisResponseArray;
                }
                SensorContextUtils.AnalysisResponse[] analysisResponseArray = responses;
                return analysisResponseArray;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to run external process `%s`. Run with -X for more information", commandLine), e);
        }
    }

    private static void saveCpd(SensorContext sensorContext, SensorContextUtils.CpdToken[] cpdTokens, InputFile file) {
        NewCpdTokens newCpdTokens = sensorContext.newCpdTokens().onFile(file);
        for (SensorContextUtils.CpdToken cpdToken : cpdTokens) {
            newCpdTokens.addToken(cpdToken.startLine.intValue(), cpdToken.startCol.intValue(), cpdToken.endLine.intValue(), cpdToken.endCol.intValue(), cpdToken.image);
        }
        newCpdTokens.save();
    }

    private void saveMetrics(SensorContext sensorContext, SensorContextUtils.AnalysisResponse analysisResponse, InputFile inputFile) {
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, analysisResponse.functions);
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.CLASSES, analysisResponse.classes);
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, analysisResponse.statements);
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.NCLOC, analysisResponse.ncloc.length);
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, analysisResponse.commentLines.length);
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, analysisResponse.complexity);
        ExternalTypescriptSensor.saveMetric(sensorContext, inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, analysisResponse.cognitiveComplexity);
        this.noSonarFilter.noSonarInFile(inputFile, Arrays.stream(analysisResponse.nosonarLines).collect(Collectors.toSet()));
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (int line : analysisResponse.ncloc) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        for (int line : analysisResponse.commentLines) {
            fileLinesContext.setIntValue("comment_lines_data", line, 1);
        }
        for (int line : analysisResponse.executableLines) {
            fileLinesContext.setIntValue("executable_lines_data", line, 1);
        }
        fileLinesContext.save();
    }

    private static void saveMetric(SensorContext sensorContext, InputFile inputFile, Metric<Integer> metric, int value) {
        sensorContext.newMeasure().forMetric(metric).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(value)).save();
    }

    private static void saveHighlights(SensorContext sensorContext, SensorContextUtils.Highlight[] highlights, InputFile inputFile) {
        NewHighlighting highlighting = sensorContext.newHighlighting().onFile(inputFile);
        for (SensorContextUtils.Highlight highlight : highlights) {
            highlighting.highlight(highlight.startLine.intValue(), highlight.startCol.intValue(), highlight.endLine.intValue(), highlight.endCol.intValue(), TypeOfText.valueOf((String)highlight.textType.toUpperCase(Locale.ENGLISH)));
        }
        highlighting.save();
    }

    private static void saveSymbols(SensorContext sensorContext, SensorContextUtils.Symbol[] symbols, InputFile inputFile) {
        NewSymbolTable newSymbolTable = sensorContext.newSymbolTable().onFile(inputFile);
        for (SensorContextUtils.Symbol symbol : symbols) {
            NewSymbol newSymbol = newSymbolTable.newSymbol(symbol.startLine.intValue(), symbol.startCol.intValue(), symbol.endLine.intValue(), symbol.endCol.intValue());
            for (SensorContextUtils.SymbolReference reference : symbol.references) {
                newSymbol.newReference(reference.startLine.intValue(), reference.startCol.intValue(), reference.endLine.intValue(), reference.endCol.intValue());
            }
        }
        newSymbolTable.save();
    }

    @Nullable
    private static File getTypescriptLocation(File currentDirectory) {
        File nodeModules = ExternalTypescriptSensor.getChildDirectoryByName(currentDirectory, "node_modules");
        if (nodeModules != null && ExternalTypescriptSensor.getChildDirectoryByName(nodeModules, "typescript") != null) {
            return nodeModules;
        }
        for (File file : currentDirectory.listFiles()) {
            File typescriptLocationForNestedDir;
            if (!file.isDirectory() || (typescriptLocationForNestedDir = ExternalTypescriptSensor.getTypescriptLocation(file)) == null) continue;
            return typescriptLocationForNestedDir;
        }
        return null;
    }

    @Nullable
    private static File getChildDirectoryByName(File directory, String name) {
        for (File file : directory.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    private static class DetectMissingTypescript
    implements ExternalProcessStreamConsumer.StreamConsumer {
        private boolean tsNotFound;

        private DetectMissingTypescript() {
        }

        @Override
        public void consumeLine(String line) {
            if (line.contains("Error: Cannot find module 'typescript'")) {
                this.tsNotFound = true;
            }
            LOG.error(line);
        }

        @Override
        public void finished() {
            if (this.tsNotFound) {
                LOG.error("Failed to find 'typescript' module. Please check, NODE_PATH contains location of global 'typescript' or install locally in your project");
            }
        }
    }
}

