/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.sonar.api.Startable;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@BatchSide
@ScannerSide
public class ExternalProcessStreamConsumer
implements Startable {
    private static final Logger LOG = Loggers.get(ExternalProcessStreamConsumer.class);
    private ExecutorService executorService;

    public final void consumeStream(InputStream inputStream, StreamConsumer streamConsumer) {
        this.executorService.submit(() -> {
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                this.readErrors(errorReader, streamConsumer);
            }
            catch (IOException e) {
                LOG.error("Error while reading stream", (Throwable)e);
            }
        });
    }

    protected void readErrors(BufferedReader errorReader, StreamConsumer streamConsumer) {
        errorReader.lines().forEach(streamConsumer::consumeLine);
        streamConsumer.finished();
    }

    public void start() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool(r -> {
                Thread thread = new Thread(r);
                thread.setName("sonarts-stream-consumer");
                thread.setDaemon(true);
                return thread;
            });
        }
    }

    public void stop() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.executorService.isTerminated()) {
                this.executorService.shutdownNow();
            }
        }
        this.executorService = null;
    }

    static interface StreamConsumer {
        public void consumeLine(String var1);

        default public void finished() {
        }
    }
}

