/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript;

import java.io.IOException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.ContextualServer;
import org.sonar.plugin.typescript.SensorContextUtils;
import org.sonar.plugin.typescript.TypeScriptRules;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
public class ContextualSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(ContextualSensor.class);
    private final ContextualServer contextualServer;
    private final CheckFactory checkFactory;

    public ContextualSensor(CheckFactory checkFactory, ContextualServer contextualServer) {
        this.checkFactory = checkFactory;
        this.contextualServer = contextualServer;
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        sensorDescriptor.onlyOnLanguage("ts").name("Contextual SonarTS").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext sensorContext) {
        Iterable<InputFile> inputFiles = SensorContextUtils.getInputFiles(sensorContext);
        LOG.info("Started SonarTS Analysis");
        inputFiles.forEach(inputFile -> {
            if (!inputFile.uri().getScheme().equals("file")) {
                LOG.error("File with uri [" + inputFile.uri() + "] can not be analyzed as it's not file scheme.");
                return;
            }
            try {
                TypeScriptRules typeScriptRules = new TypeScriptRules(this.checkFactory);
                SensorContextUtils.ContextualAnalysisRequest request = new SensorContextUtils.ContextualAnalysisRequest((InputFile)inputFile, typeScriptRules);
                SensorContextUtils.AnalysisResponse response = this.contextualServer.analyze(request);
                for (SensorContextUtils.Issue issue : response.issues) {
                    SensorContextUtils.saveIssue(sensorContext, typeScriptRules, issue, inputFile);
                }
            }
            catch (IOException e) {
                LOG.error("Failed writing to SonarTS Server ", (Throwable)e);
            }
        });
        LOG.info("Finished SonarTS Analysis");
    }
}

