/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.CFBamSchemaDefBuff;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamVersionTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamVersionCursor;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetDomainBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetDomainByNameIdxKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetDomainBySubDomIdxKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetDomainByTenantIdxKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetDomainPKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetLicenseBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetMajorVersionBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetMinorVersionBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetProjectBaseBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetVersionBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.ICFInternetSchema;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;

public class CFBamRamVersionTable
implements ICFBamVersionTable {
    private ICFBamSchema schema;
    private Map<CFInternetDomainPKey, CFInternetVersionBuff> dictByPKey = new HashMap<CFInternetDomainPKey, CFInternetVersionBuff>();

    public CFBamRamVersionTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    public void createVersion(CFSecurityAuthorization Authorization, CFInternetVersionBuff Buff) {
        String S_ProcName = "createVersion";
        this.schema.getTableProjectBase().createProjectBase(Authorization, (CFInternetProjectBaseBuff)Buff);
        CFInternetDomainPKey pkey = this.schema.getFactoryDomain().newPKey();
        pkey.setClassCode(Buff.getClassCode());
        pkey.setRequiredTenantId(Buff.getRequiredTenantId());
        pkey.setRequiredId(Buff.getRequiredId());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createVersion", (Object)pkey);
        }
        boolean allNull = true;
        allNull = false;
        allNull = false;
        if (!allNull && null == this.schema.getTableProjectBase().readDerivedByIdIdx(Authorization, Buff.getRequiredTenantId(), Buff.getRequiredId())) {
            throw CFLib.getDefaultExceptionFactory().newUnresolvedRelationException(this.getClass(), "createVersion", "Superclass", "SuperClass", "ProjectBase", null);
        }
        this.dictByPKey.put(pkey, Buff);
    }

    public CFInternetVersionBuff readDerived(CFSecurityAuthorization Authorization, CFInternetDomainPKey PKey) {
        String S_ProcName = "CFBamRamVersion.readDerived";
        CFInternetDomainPKey key = this.schema.getFactoryDomain().newPKey();
        key.setRequiredTenantId(PKey.getRequiredTenantId());
        key.setRequiredId(PKey.getRequiredId());
        CFInternetVersionBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFInternetVersionBuff lockDerived(CFSecurityAuthorization Authorization, CFInternetDomainPKey PKey) {
        String S_ProcName = "CFBamRamVersion.readDerived";
        CFInternetDomainPKey key = this.schema.getFactoryDomain().newPKey();
        key.setRequiredTenantId(PKey.getRequiredTenantId());
        key.setRequiredId(PKey.getRequiredId());
        CFInternetVersionBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFInternetVersionBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamVersion.readAllDerived";
        CFInternetVersionBuff[] retList = new CFInternetVersionBuff[this.dictByPKey.values().size()];
        Iterator<CFInternetVersionBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFInternetVersionBuff[] readDerivedByTenantIdx(CFSecurityAuthorization Authorization, long TenantId) {
        String S_ProcName = "CFBamRamDomain.readDerivedByTenantIdx";
        CFInternetDomainBuff[] buffList = this.schema.getTableDomain().readDerivedByTenantIdx(Authorization, TenantId);
        if (buffList == null) {
            return null;
        }
        ArrayList<CFInternetVersionBuff> filteredList = new ArrayList<CFInternetVersionBuff>();
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetDomainBuff buff = buffList[idx];
            if (buff == null || !(buff instanceof CFInternetVersionBuff)) continue;
            filteredList.add((CFInternetVersionBuff)buff);
        }
        return filteredList.toArray(new CFInternetVersionBuff[0]);
    }

    public CFInternetVersionBuff[] readDerivedBySubDomIdx(CFSecurityAuthorization Authorization, Long SubDomainOfTenantId, Long SubDomainOfId) {
        String S_ProcName = "CFBamRamDomain.readDerivedBySubDomIdx";
        CFInternetDomainBuff[] buffList = this.schema.getTableDomain().readDerivedBySubDomIdx(Authorization, SubDomainOfTenantId, SubDomainOfId);
        if (buffList == null) {
            return null;
        }
        ArrayList<CFInternetVersionBuff> filteredList = new ArrayList<CFInternetVersionBuff>();
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetDomainBuff buff = buffList[idx];
            if (buff == null || !(buff instanceof CFInternetVersionBuff)) continue;
            filteredList.add((CFInternetVersionBuff)buff);
        }
        return filteredList.toArray(new CFInternetVersionBuff[0]);
    }

    public CFInternetVersionBuff readDerivedByNameIdx(CFSecurityAuthorization Authorization, Long SubDomainOfTenantId, Long SubDomainOfId, String Name) {
        String S_ProcName = "CFBamRamDomain.readDerivedByNameIdx";
        CFInternetDomainBuff buff = this.schema.getTableDomain().readDerivedByNameIdx(Authorization, SubDomainOfTenantId, SubDomainOfId, Name);
        if (buff == null) {
            return null;
        }
        if (buff instanceof CFInternetVersionBuff) {
            return (CFInternetVersionBuff)buff;
        }
        return null;
    }

    public CFInternetVersionBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, long TenantId, long Id) {
        String S_ProcName = "CFBamRamDomain.readDerivedByIdIdx() ";
        CFInternetDomainPKey key = this.schema.getFactoryDomain().newPKey();
        key.setRequiredTenantId(TenantId);
        key.setRequiredId(Id);
        CFInternetVersionBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFInternetVersionBuff readBuff(CFSecurityAuthorization Authorization, CFInternetDomainPKey PKey) {
        String S_ProcName = "CFBamRamVersion.readBuff";
        CFInternetVersionBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("VERN")) {
            buff = null;
        }
        return buff;
    }

    public CFInternetVersionBuff lockBuff(CFSecurityAuthorization Authorization, CFInternetDomainPKey PKey) {
        String S_ProcName = "lockBuff";
        CFInternetVersionBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("VERN")) {
            buff = null;
        }
        return buff;
    }

    public CFInternetVersionBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamVersion.readAllBuff";
        ArrayList<CFInternetVersionBuff> filteredList = new ArrayList<CFInternetVersionBuff>();
        CFInternetVersionBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetVersionBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("VERN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFInternetVersionBuff[0]);
    }

    public CFInternetVersionBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, long TenantId, long Id) {
        String S_ProcName = "CFBamRamDomain.readBuffByIdIdx() ";
        CFInternetVersionBuff buff = this.readDerivedByIdIdx(Authorization, TenantId, Id);
        if (buff != null && buff.getClassCode().equals("DOMN")) {
            return buff;
        }
        return null;
    }

    public CFInternetVersionBuff[] readBuffByTenantIdx(CFSecurityAuthorization Authorization, long TenantId) {
        String S_ProcName = "CFBamRamDomain.readBuffByTenantIdx() ";
        ArrayList<CFInternetVersionBuff> filteredList = new ArrayList<CFInternetVersionBuff>();
        CFInternetVersionBuff[] buffList = this.readDerivedByTenantIdx(Authorization, TenantId);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetVersionBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("DOMN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFInternetVersionBuff[0]);
    }

    public CFInternetVersionBuff[] readBuffBySubDomIdx(CFSecurityAuthorization Authorization, Long SubDomainOfTenantId, Long SubDomainOfId) {
        String S_ProcName = "CFBamRamDomain.readBuffBySubDomIdx() ";
        ArrayList<CFInternetVersionBuff> filteredList = new ArrayList<CFInternetVersionBuff>();
        CFInternetVersionBuff[] buffList = this.readDerivedBySubDomIdx(Authorization, SubDomainOfTenantId, SubDomainOfId);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetVersionBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("DOMN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFInternetVersionBuff[0]);
    }

    public CFInternetVersionBuff readBuffByNameIdx(CFSecurityAuthorization Authorization, Long SubDomainOfTenantId, Long SubDomainOfId, String Name) {
        String S_ProcName = "CFBamRamDomain.readBuffByNameIdx() ";
        CFInternetVersionBuff buff = this.readDerivedByNameIdx(Authorization, SubDomainOfTenantId, SubDomainOfId, Name);
        if (buff != null && buff.getClassCode().equals("DOMN")) {
            return buff;
        }
        return null;
    }

    public void updateVersion(CFSecurityAuthorization Authorization, CFInternetVersionBuff Buff) {
        this.schema.getTableProjectBase().updateProjectBase(Authorization, (CFInternetProjectBaseBuff)Buff);
        CFInternetDomainPKey pkey = this.schema.getFactoryDomain().newPKey();
        pkey.setRequiredTenantId(Buff.getRequiredTenantId());
        pkey.setRequiredId(Buff.getRequiredId());
        CFInternetVersionBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateVersion", "Existing record not found", "Version", (Object)pkey);
        }
        boolean allNull = true;
        if (allNull && null == this.schema.getTableProjectBase().readDerivedByIdIdx(Authorization, Buff.getRequiredTenantId(), Buff.getRequiredId())) {
            throw CFLib.getDefaultExceptionFactory().newUnresolvedRelationException(this.getClass(), "updateVersion", "Superclass", "SuperClass", "ProjectBase", null);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
    }

    public void deleteVersion(CFSecurityAuthorization Authorization, CFInternetVersionBuff Buff) {
        CFBamSchemaDefBuff[] arrCheckSchemaDef;
        CFInternetDomainBuff[] arrCheckSubDomain;
        String S_ProcName = "CFBamRamVersionTable.deleteVersion() ";
        CFInternetDomainPKey pkey = this.schema.getFactoryDomain().newPKey();
        pkey.setRequiredTenantId(Buff.getRequiredTenantId());
        pkey.setRequiredId(Buff.getRequiredId());
        CFInternetVersionBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteVersion", (Object)pkey);
        }
        CFInternetLicenseBuff[] arrCheckLicenses = this.schema.getTableLicense().readDerivedByDomainIdx(Authorization, existing.getRequiredTenantId(), existing.getRequiredId());
        if (arrCheckLicenses.length > 0) {
            this.schema.getTableLicense().deleteLicenseByDomainIdx(Authorization, existing.getRequiredTenantId(), existing.getRequiredId());
        }
        if ((arrCheckSubDomain = this.schema.getTableDomain().readDerivedBySubDomIdx(Authorization, Long.valueOf(existing.getRequiredTenantId()), Long.valueOf(existing.getRequiredId()))).length > 0) {
            this.schema.getTableDomain().deleteDomainBySubDomIdx(Authorization, Long.valueOf(existing.getRequiredTenantId()), Long.valueOf(existing.getRequiredId()));
        }
        if ((arrCheckSchemaDef = this.schema.getTableSchemaDef().readDerivedByDomainIdx(Authorization, existing.getRequiredTenantId(), existing.getRequiredId())).length > 0) {
            this.schema.getTableSchemaDef().deleteSchemaDefByDomainIdx(Authorization, existing.getRequiredTenantId(), existing.getRequiredId());
        }
        if (this.schema.getTableMajorVersion().readDerivedByIdIdx(Authorization, existing.getRequiredTenantId(), existing.getRequiredId()) != null) {
            throw CFLib.getDefaultExceptionFactory().newDependentsDetectedException(this.getClass(), "deleteVersion", "Superclass", "SuperClass", "MajorVersion", (Object)pkey);
        }
        if (this.schema.getTableMinorVersion().readDerivedByIdIdx(Authorization, existing.getRequiredTenantId(), existing.getRequiredId()) != null) {
            throw CFLib.getDefaultExceptionFactory().newDependentsDetectedException(this.getClass(), "deleteVersion", "Superclass", "SuperClass", "MinorVersion", (Object)pkey);
        }
        this.dictByPKey.remove(pkey);
        this.schema.getTableProjectBase().deleteProjectBase(Authorization, (CFInternetProjectBaseBuff)Buff);
    }

    public void deleteVersionByIdIdx(CFSecurityAuthorization Authorization, long argTenantId, long argId) {
        CFInternetDomainPKey key = this.schema.getFactoryDomain().newPKey();
        key.setRequiredTenantId(argTenantId);
        key.setRequiredId(argId);
        this.deleteVersionByIdIdx(Authorization, key);
    }

    public void deleteVersionByIdIdx(CFSecurityAuthorization Authorization, CFInternetDomainPKey argKey) {
        String S_ProcName = "deleteVersionByIdIdx";
        boolean anyNotNull = false;
        anyNotNull = true;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFInternetVersionBuff> matchSet = new LinkedList<CFInternetVersionBuff>();
        for (CFInternetVersionBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetVersionBuff cur : matchSet) {
            cur = this.schema.getTableVersion().readDerivedByIdIdx(Authorization, cur.getRequiredTenantId(), cur.getRequiredId());
            String subClassCode = cur.getClassCode();
            if ("VERN".equals(subClassCode)) {
                this.schema.getTableVersion().deleteVersion(Authorization, cur);
                continue;
            }
            if ("MJVR".equals(subClassCode)) {
                this.schema.getTableMajorVersion().deleteMajorVersion(Authorization, (CFInternetMajorVersionBuff)cur);
                continue;
            }
            if ("MNVR".equals(subClassCode)) {
                this.schema.getTableMinorVersion().deleteMinorVersion(Authorization, (CFInternetMinorVersionBuff)cur);
                continue;
            }
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "deleteVersionByIdIdx", "subClassCode", (Object)cur, "Instance of or subclass of Version must not be \"" + subClassCode + "\"");
        }
    }

    public void deleteVersionByTenantIdx(CFSecurityAuthorization Authorization, long argTenantId) {
        CFInternetDomainByTenantIdxKey key = this.schema.getFactoryDomain().newTenantIdxKey();
        key.setRequiredTenantId(argTenantId);
        this.deleteVersionByTenantIdx(Authorization, key);
    }

    public void deleteVersionByTenantIdx(CFSecurityAuthorization Authorization, CFInternetDomainByTenantIdxKey argKey) {
        String S_ProcName = "deleteVersionByTenantIdx";
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFInternetVersionBuff> matchSet = new LinkedList<CFInternetVersionBuff>();
        for (CFInternetVersionBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetVersionBuff cur : matchSet) {
            cur = this.schema.getTableVersion().readDerivedByIdIdx(Authorization, cur.getRequiredTenantId(), cur.getRequiredId());
            String subClassCode = cur.getClassCode();
            if ("VERN".equals(subClassCode)) {
                this.schema.getTableVersion().deleteVersion(Authorization, cur);
                continue;
            }
            if ("MJVR".equals(subClassCode)) {
                this.schema.getTableMajorVersion().deleteMajorVersion(Authorization, (CFInternetMajorVersionBuff)cur);
                continue;
            }
            if ("MNVR".equals(subClassCode)) {
                this.schema.getTableMinorVersion().deleteMinorVersion(Authorization, (CFInternetMinorVersionBuff)cur);
                continue;
            }
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "deleteVersionByTenantIdx", "subClassCode", (Object)cur, "Instance of or subclass of Version must not be \"" + subClassCode + "\"");
        }
    }

    public void deleteVersionBySubDomIdx(CFSecurityAuthorization Authorization, Long argSubDomainOfTenantId, Long argSubDomainOfId) {
        CFInternetDomainBySubDomIdxKey key = this.schema.getFactoryDomain().newSubDomIdxKey();
        key.setOptionalSubDomainOfTenantId(argSubDomainOfTenantId);
        key.setOptionalSubDomainOfId(argSubDomainOfId);
        this.deleteVersionBySubDomIdx(Authorization, key);
    }

    public void deleteVersionBySubDomIdx(CFSecurityAuthorization Authorization, CFInternetDomainBySubDomIdxKey argKey) {
        String S_ProcName = "deleteVersionBySubDomIdx";
        boolean anyNotNull = false;
        if (argKey.getOptionalSubDomainOfTenantId() != null) {
            anyNotNull = true;
        }
        if (argKey.getOptionalSubDomainOfId() != null) {
            anyNotNull = true;
        }
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFInternetVersionBuff> matchSet = new LinkedList<CFInternetVersionBuff>();
        for (CFInternetVersionBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetVersionBuff cur : matchSet) {
            cur = this.schema.getTableVersion().readDerivedByIdIdx(Authorization, cur.getRequiredTenantId(), cur.getRequiredId());
            String subClassCode = cur.getClassCode();
            if ("VERN".equals(subClassCode)) {
                this.schema.getTableVersion().deleteVersion(Authorization, cur);
                continue;
            }
            if ("MJVR".equals(subClassCode)) {
                this.schema.getTableMajorVersion().deleteMajorVersion(Authorization, (CFInternetMajorVersionBuff)cur);
                continue;
            }
            if ("MNVR".equals(subClassCode)) {
                this.schema.getTableMinorVersion().deleteMinorVersion(Authorization, (CFInternetMinorVersionBuff)cur);
                continue;
            }
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "deleteVersionBySubDomIdx", "subClassCode", (Object)cur, "Instance of or subclass of Version must not be \"" + subClassCode + "\"");
        }
    }

    public void deleteVersionByNameIdx(CFSecurityAuthorization Authorization, Long argSubDomainOfTenantId, Long argSubDomainOfId, String argName) {
        CFInternetDomainByNameIdxKey key = this.schema.getFactoryDomain().newNameIdxKey();
        key.setOptionalSubDomainOfTenantId(argSubDomainOfTenantId);
        key.setOptionalSubDomainOfId(argSubDomainOfId);
        key.setRequiredName(argName);
        this.deleteVersionByNameIdx(Authorization, key);
    }

    public void deleteVersionByNameIdx(CFSecurityAuthorization Authorization, CFInternetDomainByNameIdxKey argKey) {
        String S_ProcName = "deleteVersionByNameIdx";
        boolean anyNotNull = false;
        if (argKey.getOptionalSubDomainOfTenantId() != null) {
            anyNotNull = true;
        }
        if (argKey.getOptionalSubDomainOfId() != null) {
            anyNotNull = true;
        }
        if (!(anyNotNull = true)) {
            return;
        }
        LinkedList<CFInternetVersionBuff> matchSet = new LinkedList<CFInternetVersionBuff>();
        for (CFInternetVersionBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetVersionBuff cur : matchSet) {
            cur = this.schema.getTableVersion().readDerivedByIdIdx(Authorization, cur.getRequiredTenantId(), cur.getRequiredId());
            String subClassCode = cur.getClassCode();
            if ("VERN".equals(subClassCode)) {
                this.schema.getTableVersion().deleteVersion(Authorization, cur);
                continue;
            }
            if ("MJVR".equals(subClassCode)) {
                this.schema.getTableMajorVersion().deleteMajorVersion(Authorization, (CFInternetMajorVersionBuff)cur);
                continue;
            }
            if ("MNVR".equals(subClassCode)) {
                this.schema.getTableMinorVersion().deleteMinorVersion(Authorization, (CFInternetMinorVersionBuff)cur);
                continue;
            }
            throw CFLib.getDefaultExceptionFactory().newUnsupportedClassException(this.getClass(), "deleteVersionByNameIdx", "subClassCode", (Object)cur, "Instance of or subclass of Version must not be \"" + subClassCode + "\"");
        }
    }

    public CFSecurityCursor openVersionCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamVersionCursor cursor = new CFBamRamVersionCursor(Authorization, (ICFInternetSchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public void closeVersionCursor(CFSecurityCursor Cursor) {
    }

    public CFInternetVersionBuff nextVersionCursor(CFSecurityCursor Cursor) {
        CFBamRamVersionCursor cursor = (CFBamRamVersionCursor)Cursor;
        CFInternetVersionBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFInternetVersionBuff prevVersionCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFInternetVersionBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextVersionCursor(Cursor);
        }
        return rec;
    }

    public CFInternetVersionBuff firstVersionCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFInternetVersionBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextVersionCursor(Cursor);
        }
        return rec;
    }

    public CFInternetVersionBuff lastVersionCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastVersionCursor");
    }

    public CFInternetVersionBuff nthVersionCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFInternetVersionBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextVersionCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

