/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamURLProtocolTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamURLProtocolCursor;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetURLProtocolBuff;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetURLProtocolByIsSecureIdxKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetURLProtocolByUNameIdxKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.CFInternetURLProtocolPKey;
import net.sourceforge.msscodefactory.cfinternet.v2_9.CFInternet.ICFInternetSchema;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;

public class CFBamRamURLProtocolTable
implements ICFBamURLProtocolTable {
    private ICFBamSchema schema;
    private Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff> dictByPKey = new HashMap<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff>();
    private Map<CFInternetURLProtocolByUNameIdxKey, CFInternetURLProtocolBuff> dictByUNameIdx = new HashMap<CFInternetURLProtocolByUNameIdxKey, CFInternetURLProtocolBuff>();
    private Map<CFInternetURLProtocolByIsSecureIdxKey, Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff>> dictByIsSecureIdx = new HashMap<CFInternetURLProtocolByIsSecureIdxKey, Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff>>();

    public CFBamRamURLProtocolTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    public void createURLProtocol(CFSecurityAuthorization Authorization, CFInternetURLProtocolBuff Buff) {
        Map<Object, Object> subdictIsSecureIdx;
        String S_ProcName = "createURLProtocol";
        CFInternetURLProtocolPKey pkey = this.schema.getFactoryURLProtocol().newPKey();
        pkey.setRequiredURLProtocolId(this.schema.nextURLProtocolIdGen());
        Buff.setRequiredURLProtocolId(pkey.getRequiredURLProtocolId());
        CFInternetURLProtocolByUNameIdxKey keyUNameIdx = this.schema.getFactoryURLProtocol().newUNameIdxKey();
        keyUNameIdx.setRequiredName(Buff.getRequiredName());
        CFInternetURLProtocolByIsSecureIdxKey keyIsSecureIdx = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        keyIsSecureIdx.setRequiredIsSecure(Buff.getRequiredIsSecure());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createURLProtocol", (Object)pkey);
        }
        if (this.dictByUNameIdx.containsKey(keyUNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createURLProtocol", "URLProtocolUNameIdx", (Object)keyUNameIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByUNameIdx.put(keyUNameIdx, Buff);
        if (this.dictByIsSecureIdx.containsKey(keyIsSecureIdx)) {
            subdictIsSecureIdx = this.dictByIsSecureIdx.get(keyIsSecureIdx);
        } else {
            subdictIsSecureIdx = new HashMap();
            this.dictByIsSecureIdx.put(keyIsSecureIdx, subdictIsSecureIdx);
        }
        subdictIsSecureIdx.put(pkey, Buff);
    }

    public CFInternetURLProtocolBuff readDerived(CFSecurityAuthorization Authorization, CFInternetURLProtocolPKey PKey) {
        String S_ProcName = "CFBamRamURLProtocol.readDerived";
        CFInternetURLProtocolPKey key = this.schema.getFactoryURLProtocol().newPKey();
        key.setRequiredURLProtocolId(PKey.getRequiredURLProtocolId());
        CFInternetURLProtocolBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFInternetURLProtocolBuff lockDerived(CFSecurityAuthorization Authorization, CFInternetURLProtocolPKey PKey) {
        String S_ProcName = "CFBamRamURLProtocol.readDerived";
        CFInternetURLProtocolPKey key = this.schema.getFactoryURLProtocol().newPKey();
        key.setRequiredURLProtocolId(PKey.getRequiredURLProtocolId());
        CFInternetURLProtocolBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFInternetURLProtocolBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamURLProtocol.readAllDerived";
        CFInternetURLProtocolBuff[] retList = new CFInternetURLProtocolBuff[this.dictByPKey.values().size()];
        Iterator<CFInternetURLProtocolBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFInternetURLProtocolBuff readDerivedByUNameIdx(CFSecurityAuthorization Authorization, String Name) {
        String S_ProcName = "CFBamRamURLProtocol.readDerivedByUNameIdx";
        CFInternetURLProtocolByUNameIdxKey key = this.schema.getFactoryURLProtocol().newUNameIdxKey();
        key.setRequiredName(Name);
        CFInternetURLProtocolBuff buff = this.dictByUNameIdx.containsKey(key) ? this.dictByUNameIdx.get(key) : null;
        return buff;
    }

    public CFInternetURLProtocolBuff[] readDerivedByIsSecureIdx(CFSecurityAuthorization Authorization, boolean IsSecure) {
        CFInternetURLProtocolBuff[] recArray;
        String S_ProcName = "CFBamRamURLProtocol.readDerivedByIsSecureIdx";
        CFInternetURLProtocolByIsSecureIdxKey key = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        key.setRequiredIsSecure(IsSecure);
        if (this.dictByIsSecureIdx.containsKey(key)) {
            Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff> subdictIsSecureIdx = this.dictByIsSecureIdx.get(key);
            recArray = new CFInternetURLProtocolBuff[subdictIsSecureIdx.size()];
            Iterator<CFInternetURLProtocolBuff> iter = subdictIsSecureIdx.values().iterator();
            int idx = 0;
            while (iter.hasNext()) {
                recArray[idx++] = iter.next();
            }
        } else {
            HashMap subdictIsSecureIdx = new HashMap();
            this.dictByIsSecureIdx.put(key, subdictIsSecureIdx);
            recArray = new CFInternetURLProtocolBuff[]{};
        }
        return recArray;
    }

    public CFInternetURLProtocolBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, int URLProtocolId) {
        String S_ProcName = "CFBamRamURLProtocol.readDerivedByIdIdx() ";
        CFInternetURLProtocolPKey key = this.schema.getFactoryURLProtocol().newPKey();
        key.setRequiredURLProtocolId(URLProtocolId);
        CFInternetURLProtocolBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFInternetURLProtocolBuff readBuff(CFSecurityAuthorization Authorization, CFInternetURLProtocolPKey PKey) {
        String S_ProcName = "CFBamRamURLProtocol.readBuff";
        CFInternetURLProtocolBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("UPRT")) {
            buff = null;
        }
        return buff;
    }

    public CFInternetURLProtocolBuff lockBuff(CFSecurityAuthorization Authorization, CFInternetURLProtocolPKey PKey) {
        String S_ProcName = "lockBuff";
        CFInternetURLProtocolBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("UPRT")) {
            buff = null;
        }
        return buff;
    }

    public CFInternetURLProtocolBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamURLProtocol.readAllBuff";
        ArrayList<CFInternetURLProtocolBuff> filteredList = new ArrayList<CFInternetURLProtocolBuff>();
        CFInternetURLProtocolBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetURLProtocolBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("UPRT")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFInternetURLProtocolBuff[0]);
    }

    public CFInternetURLProtocolBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, int URLProtocolId) {
        String S_ProcName = "CFBamRamURLProtocol.readBuffByIdIdx() ";
        CFInternetURLProtocolBuff buff = this.readDerivedByIdIdx(Authorization, URLProtocolId);
        if (buff != null && buff.getClassCode().equals("UPRT")) {
            return buff;
        }
        return null;
    }

    public CFInternetURLProtocolBuff readBuffByUNameIdx(CFSecurityAuthorization Authorization, String Name) {
        String S_ProcName = "CFBamRamURLProtocol.readBuffByUNameIdx() ";
        CFInternetURLProtocolBuff buff = this.readDerivedByUNameIdx(Authorization, Name);
        if (buff != null && buff.getClassCode().equals("UPRT")) {
            return buff;
        }
        return null;
    }

    public CFInternetURLProtocolBuff[] readBuffByIsSecureIdx(CFSecurityAuthorization Authorization, boolean IsSecure) {
        String S_ProcName = "CFBamRamURLProtocol.readBuffByIsSecureIdx() ";
        ArrayList<CFInternetURLProtocolBuff> filteredList = new ArrayList<CFInternetURLProtocolBuff>();
        CFInternetURLProtocolBuff[] buffList = this.readDerivedByIsSecureIdx(Authorization, IsSecure);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFInternetURLProtocolBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("UPRT")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFInternetURLProtocolBuff[0]);
    }

    public void updateURLProtocol(CFSecurityAuthorization Authorization, CFInternetURLProtocolBuff Buff) {
        CFInternetURLProtocolPKey pkey = this.schema.getFactoryURLProtocol().newPKey();
        pkey.setRequiredURLProtocolId(Buff.getRequiredURLProtocolId());
        CFInternetURLProtocolBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateURLProtocol", "Existing record not found", "URLProtocol", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateURLProtocol", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFInternetURLProtocolByUNameIdxKey existingKeyUNameIdx = this.schema.getFactoryURLProtocol().newUNameIdxKey();
        existingKeyUNameIdx.setRequiredName(existing.getRequiredName());
        CFInternetURLProtocolByUNameIdxKey newKeyUNameIdx = this.schema.getFactoryURLProtocol().newUNameIdxKey();
        newKeyUNameIdx.setRequiredName(Buff.getRequiredName());
        CFInternetURLProtocolByIsSecureIdxKey existingKeyIsSecureIdx = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        existingKeyIsSecureIdx.setRequiredIsSecure(existing.getRequiredIsSecure());
        CFInternetURLProtocolByIsSecureIdxKey newKeyIsSecureIdx = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        newKeyIsSecureIdx.setRequiredIsSecure(Buff.getRequiredIsSecure());
        if (!existingKeyUNameIdx.equals((Object)newKeyUNameIdx) && this.dictByUNameIdx.containsKey(newKeyUNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateURLProtocol", "URLProtocolUNameIdx", (Object)newKeyUNameIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByUNameIdx.remove(existingKeyUNameIdx);
        this.dictByUNameIdx.put(newKeyUNameIdx, Buff);
        Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff> subdict = this.dictByIsSecureIdx.get(existingKeyIsSecureIdx);
        if (subdict != null) {
            subdict.remove(pkey);
        }
        if (this.dictByIsSecureIdx.containsKey(newKeyIsSecureIdx)) {
            subdict = this.dictByIsSecureIdx.get(newKeyIsSecureIdx);
        } else {
            subdict = new HashMap<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff>();
            this.dictByIsSecureIdx.put(newKeyIsSecureIdx, subdict);
        }
        subdict.put(pkey, Buff);
    }

    public void deleteURLProtocol(CFSecurityAuthorization Authorization, CFInternetURLProtocolBuff Buff) {
        String S_ProcName = "CFBamRamURLProtocolTable.deleteURLProtocol() ";
        CFInternetURLProtocolPKey pkey = this.schema.getFactoryURLProtocol().newPKey();
        pkey.setRequiredURLProtocolId(Buff.getRequiredURLProtocolId());
        CFInternetURLProtocolBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteURLProtocol", (Object)pkey);
        }
        CFInternetURLProtocolByUNameIdxKey keyUNameIdx = this.schema.getFactoryURLProtocol().newUNameIdxKey();
        keyUNameIdx.setRequiredName(existing.getRequiredName());
        CFInternetURLProtocolByIsSecureIdxKey keyIsSecureIdx = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        keyIsSecureIdx.setRequiredIsSecure(existing.getRequiredIsSecure());
        this.dictByPKey.remove(pkey);
        this.dictByUNameIdx.remove(keyUNameIdx);
        Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff> subdict = this.dictByIsSecureIdx.get(keyIsSecureIdx);
        subdict.remove(pkey);
    }

    public void deleteURLProtocolByIdIdx(CFSecurityAuthorization Authorization, int argURLProtocolId) {
        CFInternetURLProtocolPKey key = this.schema.getFactoryURLProtocol().newPKey();
        key.setRequiredURLProtocolId(argURLProtocolId);
        this.deleteURLProtocolByIdIdx(Authorization, key);
    }

    public void deleteURLProtocolByIdIdx(CFSecurityAuthorization Authorization, CFInternetURLProtocolPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFInternetURLProtocolBuff> matchSet = new LinkedList<CFInternetURLProtocolBuff>();
        for (CFInternetURLProtocolBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetURLProtocolBuff cur : matchSet) {
            cur = this.schema.getTableURLProtocol().readDerivedByIdIdx(Authorization, cur.getRequiredURLProtocolId());
            this.deleteURLProtocol(Authorization, cur);
        }
    }

    public void deleteURLProtocolByUNameIdx(CFSecurityAuthorization Authorization, String argName) {
        CFInternetURLProtocolByUNameIdxKey key = this.schema.getFactoryURLProtocol().newUNameIdxKey();
        key.setRequiredName(argName);
        this.deleteURLProtocolByUNameIdx(Authorization, key);
    }

    public void deleteURLProtocolByUNameIdx(CFSecurityAuthorization Authorization, CFInternetURLProtocolByUNameIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFInternetURLProtocolBuff> matchSet = new LinkedList<CFInternetURLProtocolBuff>();
        for (CFInternetURLProtocolBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetURLProtocolBuff cur : matchSet) {
            cur = this.schema.getTableURLProtocol().readDerivedByIdIdx(Authorization, cur.getRequiredURLProtocolId());
            this.deleteURLProtocol(Authorization, cur);
        }
    }

    public void deleteURLProtocolByIsSecureIdx(CFSecurityAuthorization Authorization, boolean argIsSecure) {
        CFInternetURLProtocolByIsSecureIdxKey key = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        key.setRequiredIsSecure(argIsSecure);
        this.deleteURLProtocolByIsSecureIdx(Authorization, key);
    }

    public void deleteURLProtocolByIsSecureIdx(CFSecurityAuthorization Authorization, CFInternetURLProtocolByIsSecureIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFInternetURLProtocolBuff> matchSet = new LinkedList<CFInternetURLProtocolBuff>();
        for (CFInternetURLProtocolBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFInternetURLProtocolBuff cur : matchSet) {
            cur = this.schema.getTableURLProtocol().readDerivedByIdIdx(Authorization, cur.getRequiredURLProtocolId());
            this.deleteURLProtocol(Authorization, cur);
        }
    }

    public CFSecurityCursor openURLProtocolCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamURLProtocolCursor cursor = new CFBamRamURLProtocolCursor(Authorization, (ICFInternetSchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public CFSecurityCursor openURLProtocolCursorByIsSecureIdx(CFSecurityAuthorization Authorization, boolean IsSecure) {
        CFBamRamURLProtocolCursor cursor;
        CFInternetURLProtocolByIsSecureIdxKey key = this.schema.getFactoryURLProtocol().newIsSecureIdxKey();
        key.setRequiredIsSecure(IsSecure);
        if (this.dictByIsSecureIdx.containsKey(key)) {
            Map<CFInternetURLProtocolPKey, CFInternetURLProtocolBuff> subdictIsSecureIdx = this.dictByIsSecureIdx.get(key);
            cursor = new CFBamRamURLProtocolCursor(Authorization, (ICFInternetSchema)this.schema, subdictIsSecureIdx.values());
        } else {
            cursor = new CFBamRamURLProtocolCursor(Authorization, (ICFInternetSchema)this.schema, new ArrayList<CFInternetURLProtocolBuff>());
        }
        return cursor;
    }

    public void closeURLProtocolCursor(CFSecurityCursor Cursor) {
    }

    public CFInternetURLProtocolBuff nextURLProtocolCursor(CFSecurityCursor Cursor) {
        CFBamRamURLProtocolCursor cursor = (CFBamRamURLProtocolCursor)Cursor;
        CFInternetURLProtocolBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFInternetURLProtocolBuff prevURLProtocolCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFInternetURLProtocolBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextURLProtocolCursor(Cursor);
        }
        return rec;
    }

    public CFInternetURLProtocolBuff firstURLProtocolCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFInternetURLProtocolBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextURLProtocolCursor(Cursor);
        }
        return rec;
    }

    public CFInternetURLProtocolBuff lastURLProtocolCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastURLProtocolCursor");
    }

    public CFInternetURLProtocolBuff nthURLProtocolCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFInternetURLProtocolBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextURLProtocolCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

