/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamISOLanguageTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamISOLanguageCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryLanguageBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOLanguageBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOLanguageByCode2IdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOLanguageByCode3IdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOLanguagePKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;

public class CFBamRamISOLanguageTable
implements ICFBamISOLanguageTable {
    private ICFBamSchema schema;
    private Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff> dictByPKey = new HashMap<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff>();
    private Map<CFSecurityISOLanguageByCode3IdxKey, CFSecurityISOLanguageBuff> dictByCode3Idx = new HashMap<CFSecurityISOLanguageByCode3IdxKey, CFSecurityISOLanguageBuff>();
    private Map<CFSecurityISOLanguageByCode2IdxKey, Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff>> dictByCode2Idx = new HashMap<CFSecurityISOLanguageByCode2IdxKey, Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff>>();

    public CFBamRamISOLanguageTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    public void createISOLanguage(CFSecurityAuthorization Authorization, CFSecurityISOLanguageBuff Buff) {
        Map<Object, Object> subdictCode2Idx;
        String S_ProcName = "createISOLanguage";
        CFSecurityISOLanguagePKey pkey = this.schema.getFactoryISOLanguage().newPKey();
        pkey.setRequiredISOLanguageId(this.schema.nextISOLanguageIdGen());
        Buff.setRequiredISOLanguageId(pkey.getRequiredISOLanguageId());
        CFSecurityISOLanguageByCode3IdxKey keyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        keyCode3Idx.setRequiredISO6392Code(Buff.getRequiredISO6392Code());
        CFSecurityISOLanguageByCode2IdxKey keyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        keyCode2Idx.setOptionalISO6391Code(Buff.getOptionalISO6391Code());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createISOLanguage", (Object)pkey);
        }
        if (this.dictByCode3Idx.containsKey(keyCode3Idx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOLanguage", "ISOLanguage6392Idx", (Object)keyCode3Idx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByCode3Idx.put(keyCode3Idx, Buff);
        if (this.dictByCode2Idx.containsKey(keyCode2Idx)) {
            subdictCode2Idx = this.dictByCode2Idx.get(keyCode2Idx);
        } else {
            subdictCode2Idx = new HashMap();
            this.dictByCode2Idx.put(keyCode2Idx, subdictCode2Idx);
        }
        subdictCode2Idx.put(pkey, Buff);
    }

    public CFSecurityISOLanguageBuff readDerived(CFSecurityAuthorization Authorization, CFSecurityISOLanguagePKey PKey) {
        String S_ProcName = "CFBamRamISOLanguage.readDerived";
        CFSecurityISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(PKey.getRequiredISOLanguageId());
        CFSecurityISOLanguageBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOLanguageBuff lockDerived(CFSecurityAuthorization Authorization, CFSecurityISOLanguagePKey PKey) {
        String S_ProcName = "CFBamRamISOLanguage.readDerived";
        CFSecurityISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(PKey.getRequiredISOLanguageId());
        CFSecurityISOLanguageBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOLanguageBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamISOLanguage.readAllDerived";
        CFSecurityISOLanguageBuff[] retList = new CFSecurityISOLanguageBuff[this.dictByPKey.values().size()];
        Iterator<CFSecurityISOLanguageBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFSecurityISOLanguageBuff readDerivedByCode3Idx(CFSecurityAuthorization Authorization, String ISO6392Code) {
        String S_ProcName = "CFBamRamISOLanguage.readDerivedByCode3Idx";
        CFSecurityISOLanguageByCode3IdxKey key = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        key.setRequiredISO6392Code(ISO6392Code);
        CFSecurityISOLanguageBuff buff = this.dictByCode3Idx.containsKey(key) ? this.dictByCode3Idx.get(key) : null;
        return buff;
    }

    public CFSecurityISOLanguageBuff[] readDerivedByCode2Idx(CFSecurityAuthorization Authorization, String ISO6391Code) {
        CFSecurityISOLanguageBuff[] recArray;
        String S_ProcName = "CFBamRamISOLanguage.readDerivedByCode2Idx";
        CFSecurityISOLanguageByCode2IdxKey key = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        key.setOptionalISO6391Code(ISO6391Code);
        if (this.dictByCode2Idx.containsKey(key)) {
            Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff> subdictCode2Idx = this.dictByCode2Idx.get(key);
            recArray = new CFSecurityISOLanguageBuff[subdictCode2Idx.size()];
            Iterator<CFSecurityISOLanguageBuff> iter = subdictCode2Idx.values().iterator();
            int idx = 0;
            while (iter.hasNext()) {
                recArray[idx++] = iter.next();
            }
        } else {
            HashMap subdictCode2Idx = new HashMap();
            this.dictByCode2Idx.put(key, subdictCode2Idx);
            recArray = new CFSecurityISOLanguageBuff[]{};
        }
        return recArray;
    }

    public CFSecurityISOLanguageBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, short ISOLanguageId) {
        String S_ProcName = "CFBamRamISOLanguage.readDerivedByIdIdx() ";
        CFSecurityISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(ISOLanguageId);
        CFSecurityISOLanguageBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOLanguageBuff readBuff(CFSecurityAuthorization Authorization, CFSecurityISOLanguagePKey PKey) {
        String S_ProcName = "CFBamRamISOLanguage.readBuff";
        CFSecurityISOLanguageBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISLN")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityISOLanguageBuff lockBuff(CFSecurityAuthorization Authorization, CFSecurityISOLanguagePKey PKey) {
        String S_ProcName = "lockBuff";
        CFSecurityISOLanguageBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISLN")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityISOLanguageBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamISOLanguage.readAllBuff";
        ArrayList<CFSecurityISOLanguageBuff> filteredList = new ArrayList<CFSecurityISOLanguageBuff>();
        CFSecurityISOLanguageBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityISOLanguageBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISLN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityISOLanguageBuff[0]);
    }

    public CFSecurityISOLanguageBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, short ISOLanguageId) {
        String S_ProcName = "CFBamRamISOLanguage.readBuffByIdIdx() ";
        CFSecurityISOLanguageBuff buff = this.readDerivedByIdIdx(Authorization, ISOLanguageId);
        if (buff != null && buff.getClassCode().equals("ISLN")) {
            return buff;
        }
        return null;
    }

    public CFSecurityISOLanguageBuff readBuffByCode3Idx(CFSecurityAuthorization Authorization, String ISO6392Code) {
        String S_ProcName = "CFBamRamISOLanguage.readBuffByCode3Idx() ";
        CFSecurityISOLanguageBuff buff = this.readDerivedByCode3Idx(Authorization, ISO6392Code);
        if (buff != null && buff.getClassCode().equals("ISLN")) {
            return buff;
        }
        return null;
    }

    public CFSecurityISOLanguageBuff[] readBuffByCode2Idx(CFSecurityAuthorization Authorization, String ISO6391Code) {
        String S_ProcName = "CFBamRamISOLanguage.readBuffByCode2Idx() ";
        ArrayList<CFSecurityISOLanguageBuff> filteredList = new ArrayList<CFSecurityISOLanguageBuff>();
        CFSecurityISOLanguageBuff[] buffList = this.readDerivedByCode2Idx(Authorization, ISO6391Code);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityISOLanguageBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISLN")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityISOLanguageBuff[0]);
    }

    public void updateISOLanguage(CFSecurityAuthorization Authorization, CFSecurityISOLanguageBuff Buff) {
        CFSecurityISOLanguagePKey pkey = this.schema.getFactoryISOLanguage().newPKey();
        pkey.setRequiredISOLanguageId(Buff.getRequiredISOLanguageId());
        CFSecurityISOLanguageBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateISOLanguage", "Existing record not found", "ISOLanguage", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateISOLanguage", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFSecurityISOLanguageByCode3IdxKey existingKeyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        existingKeyCode3Idx.setRequiredISO6392Code(existing.getRequiredISO6392Code());
        CFSecurityISOLanguageByCode3IdxKey newKeyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        newKeyCode3Idx.setRequiredISO6392Code(Buff.getRequiredISO6392Code());
        CFSecurityISOLanguageByCode2IdxKey existingKeyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        existingKeyCode2Idx.setOptionalISO6391Code(existing.getOptionalISO6391Code());
        CFSecurityISOLanguageByCode2IdxKey newKeyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        newKeyCode2Idx.setOptionalISO6391Code(Buff.getOptionalISO6391Code());
        if (!existingKeyCode3Idx.equals((Object)newKeyCode3Idx) && this.dictByCode3Idx.containsKey(newKeyCode3Idx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOLanguage", "ISOLanguage6392Idx", (Object)newKeyCode3Idx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByCode3Idx.remove(existingKeyCode3Idx);
        this.dictByCode3Idx.put(newKeyCode3Idx, Buff);
        Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff> subdict = this.dictByCode2Idx.get(existingKeyCode2Idx);
        if (subdict != null) {
            subdict.remove(pkey);
        }
        if (this.dictByCode2Idx.containsKey(newKeyCode2Idx)) {
            subdict = this.dictByCode2Idx.get(newKeyCode2Idx);
        } else {
            subdict = new HashMap<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff>();
            this.dictByCode2Idx.put(newKeyCode2Idx, subdict);
        }
        subdict.put(pkey, Buff);
    }

    public void deleteISOLanguage(CFSecurityAuthorization Authorization, CFSecurityISOLanguageBuff Buff) {
        String S_ProcName = "CFBamRamISOLanguageTable.deleteISOLanguage() ";
        CFSecurityISOLanguagePKey pkey = this.schema.getFactoryISOLanguage().newPKey();
        pkey.setRequiredISOLanguageId(Buff.getRequiredISOLanguageId());
        CFSecurityISOLanguageBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteISOLanguage", (Object)pkey);
        }
        CFSecurityISOCountryLanguageBuff[] arrCheckISOLanguageCountries = this.schema.getTableISOCountryLanguage().readDerivedByLanguageIdx(Authorization, existing.getRequiredISOLanguageId());
        if (arrCheckISOLanguageCountries.length > 0) {
            this.schema.getTableISOCountryLanguage().deleteISOCountryLanguageByLanguageIdx(Authorization, existing.getRequiredISOLanguageId());
        }
        CFSecurityISOLanguageByCode3IdxKey keyCode3Idx = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        keyCode3Idx.setRequiredISO6392Code(existing.getRequiredISO6392Code());
        CFSecurityISOLanguageByCode2IdxKey keyCode2Idx = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        keyCode2Idx.setOptionalISO6391Code(existing.getOptionalISO6391Code());
        this.dictByPKey.remove(pkey);
        this.dictByCode3Idx.remove(keyCode3Idx);
        Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff> subdict = this.dictByCode2Idx.get(keyCode2Idx);
        subdict.remove(pkey);
    }

    public void deleteISOLanguageByIdIdx(CFSecurityAuthorization Authorization, short argISOLanguageId) {
        CFSecurityISOLanguagePKey key = this.schema.getFactoryISOLanguage().newPKey();
        key.setRequiredISOLanguageId(argISOLanguageId);
        this.deleteISOLanguageByIdIdx(Authorization, key);
    }

    public void deleteISOLanguageByIdIdx(CFSecurityAuthorization Authorization, CFSecurityISOLanguagePKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOLanguageBuff> matchSet = new LinkedList<CFSecurityISOLanguageBuff>();
        for (CFSecurityISOLanguageBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOLanguageBuff cur : matchSet) {
            cur = this.schema.getTableISOLanguage().readDerivedByIdIdx(Authorization, cur.getRequiredISOLanguageId());
            this.deleteISOLanguage(Authorization, cur);
        }
    }

    public void deleteISOLanguageByCode3Idx(CFSecurityAuthorization Authorization, String argISO6392Code) {
        CFSecurityISOLanguageByCode3IdxKey key = this.schema.getFactoryISOLanguage().newCode3IdxKey();
        key.setRequiredISO6392Code(argISO6392Code);
        this.deleteISOLanguageByCode3Idx(Authorization, key);
    }

    public void deleteISOLanguageByCode3Idx(CFSecurityAuthorization Authorization, CFSecurityISOLanguageByCode3IdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOLanguageBuff> matchSet = new LinkedList<CFSecurityISOLanguageBuff>();
        for (CFSecurityISOLanguageBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOLanguageBuff cur : matchSet) {
            cur = this.schema.getTableISOLanguage().readDerivedByIdIdx(Authorization, cur.getRequiredISOLanguageId());
            this.deleteISOLanguage(Authorization, cur);
        }
    }

    public void deleteISOLanguageByCode2Idx(CFSecurityAuthorization Authorization, String argISO6391Code) {
        CFSecurityISOLanguageByCode2IdxKey key = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        key.setOptionalISO6391Code(argISO6391Code);
        this.deleteISOLanguageByCode2Idx(Authorization, key);
    }

    public void deleteISOLanguageByCode2Idx(CFSecurityAuthorization Authorization, CFSecurityISOLanguageByCode2IdxKey argKey) {
        boolean anyNotNull = false;
        if (argKey.getOptionalISO6391Code() != null) {
            anyNotNull = true;
        }
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOLanguageBuff> matchSet = new LinkedList<CFSecurityISOLanguageBuff>();
        for (CFSecurityISOLanguageBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOLanguageBuff cur : matchSet) {
            cur = this.schema.getTableISOLanguage().readDerivedByIdIdx(Authorization, cur.getRequiredISOLanguageId());
            this.deleteISOLanguage(Authorization, cur);
        }
    }

    public CFSecurityCursor openISOLanguageCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamISOLanguageCursor cursor = new CFBamRamISOLanguageCursor(Authorization, (ICFSecuritySchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public CFSecurityCursor openISOLanguageCursorByCode2Idx(CFSecurityAuthorization Authorization, String ISO6391Code) {
        CFBamRamISOLanguageCursor cursor;
        CFSecurityISOLanguageByCode2IdxKey key = this.schema.getFactoryISOLanguage().newCode2IdxKey();
        key.setOptionalISO6391Code(ISO6391Code);
        if (this.dictByCode2Idx.containsKey(key)) {
            Map<CFSecurityISOLanguagePKey, CFSecurityISOLanguageBuff> subdictCode2Idx = this.dictByCode2Idx.get(key);
            cursor = new CFBamRamISOLanguageCursor(Authorization, (ICFSecuritySchema)this.schema, subdictCode2Idx.values());
        } else {
            cursor = new CFBamRamISOLanguageCursor(Authorization, (ICFSecuritySchema)this.schema, new ArrayList<CFSecurityISOLanguageBuff>());
        }
        return cursor;
    }

    public void closeISOLanguageCursor(CFSecurityCursor Cursor) {
    }

    public CFSecurityISOLanguageBuff nextISOLanguageCursor(CFSecurityCursor Cursor) {
        CFBamRamISOLanguageCursor cursor = (CFBamRamISOLanguageCursor)Cursor;
        CFSecurityISOLanguageBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFSecurityISOLanguageBuff prevISOLanguageCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFSecurityISOLanguageBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOLanguageCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityISOLanguageBuff firstISOLanguageCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFSecurityISOLanguageBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOLanguageCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityISOLanguageBuff lastISOLanguageCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastISOLanguageCursor");
    }

    public CFSecurityISOLanguageBuff nthISOLanguageCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFSecurityISOLanguageBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOLanguageCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

