/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamISOCurrencyTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamISOCurrencyCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryCurrencyBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCurrencyBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCurrencyByCcyCdIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCurrencyByCcyNmIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCurrencyPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;

public class CFBamRamISOCurrencyTable
implements ICFBamISOCurrencyTable {
    private ICFBamSchema schema;
    private Map<CFSecurityISOCurrencyPKey, CFSecurityISOCurrencyBuff> dictByPKey = new HashMap<CFSecurityISOCurrencyPKey, CFSecurityISOCurrencyBuff>();
    private Map<CFSecurityISOCurrencyByCcyCdIdxKey, CFSecurityISOCurrencyBuff> dictByCcyCdIdx = new HashMap<CFSecurityISOCurrencyByCcyCdIdxKey, CFSecurityISOCurrencyBuff>();
    private Map<CFSecurityISOCurrencyByCcyNmIdxKey, CFSecurityISOCurrencyBuff> dictByCcyNmIdx = new HashMap<CFSecurityISOCurrencyByCcyNmIdxKey, CFSecurityISOCurrencyBuff>();

    public CFBamRamISOCurrencyTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    public void createISOCurrency(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyBuff Buff) {
        String S_ProcName = "createISOCurrency";
        CFSecurityISOCurrencyPKey pkey = this.schema.getFactoryISOCurrency().newPKey();
        pkey.setRequiredISOCurrencyId(this.schema.nextISOCurrencyIdGen());
        Buff.setRequiredISOCurrencyId(pkey.getRequiredISOCurrencyId());
        CFSecurityISOCurrencyByCcyCdIdxKey keyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        keyCcyCdIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFSecurityISOCurrencyByCcyNmIdxKey keyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        keyCcyNmIdx.setRequiredName(Buff.getRequiredName());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createISOCurrency", (Object)pkey);
        }
        if (this.dictByCcyCdIdx.containsKey(keyCcyCdIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCurrency", "ISOCurrencyCodeIdx", (Object)keyCcyCdIdx);
        }
        if (this.dictByCcyNmIdx.containsKey(keyCcyNmIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCurrency", "ISOCurrencyNameIdx", (Object)keyCcyNmIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByCcyCdIdx.put(keyCcyCdIdx, Buff);
        this.dictByCcyNmIdx.put(keyCcyNmIdx, Buff);
    }

    public CFSecurityISOCurrencyBuff readDerived(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyPKey PKey) {
        String S_ProcName = "CFBamRamISOCurrency.readDerived";
        CFSecurityISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(PKey.getRequiredISOCurrencyId());
        CFSecurityISOCurrencyBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOCurrencyBuff lockDerived(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyPKey PKey) {
        String S_ProcName = "CFBamRamISOCurrency.readDerived";
        CFSecurityISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(PKey.getRequiredISOCurrencyId());
        CFSecurityISOCurrencyBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOCurrencyBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamISOCurrency.readAllDerived";
        CFSecurityISOCurrencyBuff[] retList = new CFSecurityISOCurrencyBuff[this.dictByPKey.values().size()];
        Iterator<CFSecurityISOCurrencyBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFSecurityISOCurrencyBuff readDerivedByCcyCdIdx(CFSecurityAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFBamRamISOCurrency.readDerivedByCcyCdIdx";
        CFSecurityISOCurrencyByCcyCdIdxKey key = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        key.setRequiredISOCode(ISOCode);
        CFSecurityISOCurrencyBuff buff = this.dictByCcyCdIdx.containsKey(key) ? this.dictByCcyCdIdx.get(key) : null;
        return buff;
    }

    public CFSecurityISOCurrencyBuff readDerivedByCcyNmIdx(CFSecurityAuthorization Authorization, String Name) {
        String S_ProcName = "CFBamRamISOCurrency.readDerivedByCcyNmIdx";
        CFSecurityISOCurrencyByCcyNmIdxKey key = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        key.setRequiredName(Name);
        CFSecurityISOCurrencyBuff buff = this.dictByCcyNmIdx.containsKey(key) ? this.dictByCcyNmIdx.get(key) : null;
        return buff;
    }

    public CFSecurityISOCurrencyBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, short ISOCurrencyId) {
        String S_ProcName = "CFBamRamISOCurrency.readDerivedByIdIdx() ";
        CFSecurityISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(ISOCurrencyId);
        CFSecurityISOCurrencyBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOCurrencyBuff readBuff(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyPKey PKey) {
        String S_ProcName = "CFBamRamISOCurrency.readBuff";
        CFSecurityISOCurrencyBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISCY")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityISOCurrencyBuff lockBuff(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyPKey PKey) {
        String S_ProcName = "lockBuff";
        CFSecurityISOCurrencyBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISCY")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityISOCurrencyBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamISOCurrency.readAllBuff";
        ArrayList<CFSecurityISOCurrencyBuff> filteredList = new ArrayList<CFSecurityISOCurrencyBuff>();
        CFSecurityISOCurrencyBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityISOCurrencyBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISCY")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityISOCurrencyBuff[0]);
    }

    public CFSecurityISOCurrencyBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, short ISOCurrencyId) {
        String S_ProcName = "CFBamRamISOCurrency.readBuffByIdIdx() ";
        CFSecurityISOCurrencyBuff buff = this.readDerivedByIdIdx(Authorization, ISOCurrencyId);
        if (buff != null && buff.getClassCode().equals("ISCY")) {
            return buff;
        }
        return null;
    }

    public CFSecurityISOCurrencyBuff readBuffByCcyCdIdx(CFSecurityAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFBamRamISOCurrency.readBuffByCcyCdIdx() ";
        CFSecurityISOCurrencyBuff buff = this.readDerivedByCcyCdIdx(Authorization, ISOCode);
        if (buff != null && buff.getClassCode().equals("ISCY")) {
            return buff;
        }
        return null;
    }

    public CFSecurityISOCurrencyBuff readBuffByCcyNmIdx(CFSecurityAuthorization Authorization, String Name) {
        String S_ProcName = "CFBamRamISOCurrency.readBuffByCcyNmIdx() ";
        CFSecurityISOCurrencyBuff buff = this.readDerivedByCcyNmIdx(Authorization, Name);
        if (buff != null && buff.getClassCode().equals("ISCY")) {
            return buff;
        }
        return null;
    }

    public void updateISOCurrency(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyBuff Buff) {
        CFSecurityISOCurrencyPKey pkey = this.schema.getFactoryISOCurrency().newPKey();
        pkey.setRequiredISOCurrencyId(Buff.getRequiredISOCurrencyId());
        CFSecurityISOCurrencyBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateISOCurrency", "Existing record not found", "ISOCurrency", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateISOCurrency", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFSecurityISOCurrencyByCcyCdIdxKey existingKeyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        existingKeyCcyCdIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFSecurityISOCurrencyByCcyCdIdxKey newKeyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        newKeyCcyCdIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFSecurityISOCurrencyByCcyNmIdxKey existingKeyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        existingKeyCcyNmIdx.setRequiredName(existing.getRequiredName());
        CFSecurityISOCurrencyByCcyNmIdxKey newKeyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        newKeyCcyNmIdx.setRequiredName(Buff.getRequiredName());
        if (!existingKeyCcyCdIdx.equals((Object)newKeyCcyCdIdx) && this.dictByCcyCdIdx.containsKey(newKeyCcyCdIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCurrency", "ISOCurrencyCodeIdx", (Object)newKeyCcyCdIdx);
        }
        if (!existingKeyCcyNmIdx.equals((Object)newKeyCcyNmIdx) && this.dictByCcyNmIdx.containsKey(newKeyCcyNmIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCurrency", "ISOCurrencyNameIdx", (Object)newKeyCcyNmIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByCcyCdIdx.remove(existingKeyCcyCdIdx);
        this.dictByCcyCdIdx.put(newKeyCcyCdIdx, Buff);
        this.dictByCcyNmIdx.remove(existingKeyCcyNmIdx);
        this.dictByCcyNmIdx.put(newKeyCcyNmIdx, Buff);
    }

    public void deleteISOCurrency(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyBuff Buff) {
        String S_ProcName = "CFBamRamISOCurrencyTable.deleteISOCurrency() ";
        CFSecurityISOCurrencyPKey pkey = this.schema.getFactoryISOCurrency().newPKey();
        pkey.setRequiredISOCurrencyId(Buff.getRequiredISOCurrencyId());
        CFSecurityISOCurrencyBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteISOCurrency", (Object)pkey);
        }
        CFSecurityISOCountryCurrencyBuff[] arrCheckISOCurrencyCountries = this.schema.getTableISOCountryCurrency().readDerivedByCurrencyIdx(Authorization, existing.getRequiredISOCurrencyId());
        if (arrCheckISOCurrencyCountries.length > 0) {
            this.schema.getTableISOCountryCurrency().deleteISOCountryCurrencyByCurrencyIdx(Authorization, existing.getRequiredISOCurrencyId());
        }
        CFSecurityISOCurrencyByCcyCdIdxKey keyCcyCdIdx = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        keyCcyCdIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFSecurityISOCurrencyByCcyNmIdxKey keyCcyNmIdx = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        keyCcyNmIdx.setRequiredName(existing.getRequiredName());
        this.dictByPKey.remove(pkey);
        this.dictByCcyCdIdx.remove(keyCcyCdIdx);
        this.dictByCcyNmIdx.remove(keyCcyNmIdx);
    }

    public void deleteISOCurrencyByIdIdx(CFSecurityAuthorization Authorization, short argISOCurrencyId) {
        CFSecurityISOCurrencyPKey key = this.schema.getFactoryISOCurrency().newPKey();
        key.setRequiredISOCurrencyId(argISOCurrencyId);
        this.deleteISOCurrencyByIdIdx(Authorization, key);
    }

    public void deleteISOCurrencyByIdIdx(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOCurrencyBuff> matchSet = new LinkedList<CFSecurityISOCurrencyBuff>();
        for (CFSecurityISOCurrencyBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOCurrencyBuff cur : matchSet) {
            cur = this.schema.getTableISOCurrency().readDerivedByIdIdx(Authorization, cur.getRequiredISOCurrencyId());
            this.deleteISOCurrency(Authorization, cur);
        }
    }

    public void deleteISOCurrencyByCcyCdIdx(CFSecurityAuthorization Authorization, String argISOCode) {
        CFSecurityISOCurrencyByCcyCdIdxKey key = this.schema.getFactoryISOCurrency().newCcyCdIdxKey();
        key.setRequiredISOCode(argISOCode);
        this.deleteISOCurrencyByCcyCdIdx(Authorization, key);
    }

    public void deleteISOCurrencyByCcyCdIdx(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyByCcyCdIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOCurrencyBuff> matchSet = new LinkedList<CFSecurityISOCurrencyBuff>();
        for (CFSecurityISOCurrencyBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOCurrencyBuff cur : matchSet) {
            cur = this.schema.getTableISOCurrency().readDerivedByIdIdx(Authorization, cur.getRequiredISOCurrencyId());
            this.deleteISOCurrency(Authorization, cur);
        }
    }

    public void deleteISOCurrencyByCcyNmIdx(CFSecurityAuthorization Authorization, String argName) {
        CFSecurityISOCurrencyByCcyNmIdxKey key = this.schema.getFactoryISOCurrency().newCcyNmIdxKey();
        key.setRequiredName(argName);
        this.deleteISOCurrencyByCcyNmIdx(Authorization, key);
    }

    public void deleteISOCurrencyByCcyNmIdx(CFSecurityAuthorization Authorization, CFSecurityISOCurrencyByCcyNmIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOCurrencyBuff> matchSet = new LinkedList<CFSecurityISOCurrencyBuff>();
        for (CFSecurityISOCurrencyBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOCurrencyBuff cur : matchSet) {
            cur = this.schema.getTableISOCurrency().readDerivedByIdIdx(Authorization, cur.getRequiredISOCurrencyId());
            this.deleteISOCurrency(Authorization, cur);
        }
    }

    public CFSecurityCursor openISOCurrencyCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamISOCurrencyCursor cursor = new CFBamRamISOCurrencyCursor(Authorization, (ICFSecuritySchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public void closeISOCurrencyCursor(CFSecurityCursor Cursor) {
    }

    public CFSecurityISOCurrencyBuff nextISOCurrencyCursor(CFSecurityCursor Cursor) {
        CFBamRamISOCurrencyCursor cursor = (CFBamRamISOCurrencyCursor)Cursor;
        CFSecurityISOCurrencyBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFSecurityISOCurrencyBuff prevISOCurrencyCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFSecurityISOCurrencyBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCurrencyCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityISOCurrencyBuff firstISOCurrencyCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFSecurityISOCurrencyBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCurrencyCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityISOCurrencyBuff lastISOCurrencyCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastISOCurrencyCursor");
    }

    public CFSecurityISOCurrencyBuff nthISOCurrencyCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFSecurityISOCurrencyBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCurrencyCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

