/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamISOCountryTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamISOCountryCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryByISOCodeIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryByNameIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityISOCountryPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;

public class CFBamRamISOCountryTable
implements ICFBamISOCountryTable {
    private ICFBamSchema schema;
    private Map<CFSecurityISOCountryPKey, CFSecurityISOCountryBuff> dictByPKey = new HashMap<CFSecurityISOCountryPKey, CFSecurityISOCountryBuff>();
    private Map<CFSecurityISOCountryByISOCodeIdxKey, CFSecurityISOCountryBuff> dictByISOCodeIdx = new HashMap<CFSecurityISOCountryByISOCodeIdxKey, CFSecurityISOCountryBuff>();
    private Map<CFSecurityISOCountryByNameIdxKey, CFSecurityISOCountryBuff> dictByNameIdx = new HashMap<CFSecurityISOCountryByNameIdxKey, CFSecurityISOCountryBuff>();

    public CFBamRamISOCountryTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    public void createISOCountry(CFSecurityAuthorization Authorization, CFSecurityISOCountryBuff Buff) {
        String S_ProcName = "createISOCountry";
        CFSecurityISOCountryPKey pkey = this.schema.getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(this.schema.nextISOCountryIdGen());
        Buff.setRequiredISOCountryId(pkey.getRequiredISOCountryId());
        CFSecurityISOCountryByISOCodeIdxKey keyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        keyISOCodeIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFSecurityISOCountryByNameIdxKey keyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        keyNameIdx.setRequiredName(Buff.getRequiredName());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createISOCountry", (Object)pkey);
        }
        if (this.dictByISOCodeIdx.containsKey(keyISOCodeIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCountry", "ISOCountryCodeIdx", (Object)keyISOCodeIdx);
        }
        if (this.dictByNameIdx.containsKey(keyNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createISOCountry", "ISOCountryNameIdx", (Object)keyNameIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByISOCodeIdx.put(keyISOCodeIdx, Buff);
        this.dictByNameIdx.put(keyNameIdx, Buff);
    }

    public CFSecurityISOCountryBuff readDerived(CFSecurityAuthorization Authorization, CFSecurityISOCountryPKey PKey) {
        String S_ProcName = "CFBamRamISOCountry.readDerived";
        CFSecurityISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(PKey.getRequiredISOCountryId());
        CFSecurityISOCountryBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOCountryBuff lockDerived(CFSecurityAuthorization Authorization, CFSecurityISOCountryPKey PKey) {
        String S_ProcName = "CFBamRamISOCountry.readDerived";
        CFSecurityISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(PKey.getRequiredISOCountryId());
        CFSecurityISOCountryBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOCountryBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamISOCountry.readAllDerived";
        CFSecurityISOCountryBuff[] retList = new CFSecurityISOCountryBuff[this.dictByPKey.values().size()];
        Iterator<CFSecurityISOCountryBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFSecurityISOCountryBuff readDerivedByISOCodeIdx(CFSecurityAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFBamRamISOCountry.readDerivedByISOCodeIdx";
        CFSecurityISOCountryByISOCodeIdxKey key = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(ISOCode);
        CFSecurityISOCountryBuff buff = this.dictByISOCodeIdx.containsKey(key) ? this.dictByISOCodeIdx.get(key) : null;
        return buff;
    }

    public CFSecurityISOCountryBuff readDerivedByNameIdx(CFSecurityAuthorization Authorization, String Name) {
        String S_ProcName = "CFBamRamISOCountry.readDerivedByNameIdx";
        CFSecurityISOCountryByNameIdxKey key = this.schema.getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(Name);
        CFSecurityISOCountryBuff buff = this.dictByNameIdx.containsKey(key) ? this.dictByNameIdx.get(key) : null;
        return buff;
    }

    public CFSecurityISOCountryBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, short ISOCountryId) {
        String S_ProcName = "CFBamRamISOCountry.readDerivedByIdIdx() ";
        CFSecurityISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(ISOCountryId);
        CFSecurityISOCountryBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityISOCountryBuff readBuff(CFSecurityAuthorization Authorization, CFSecurityISOCountryPKey PKey) {
        String S_ProcName = "CFBamRamISOCountry.readBuff";
        CFSecurityISOCountryBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISOC")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityISOCountryBuff lockBuff(CFSecurityAuthorization Authorization, CFSecurityISOCountryPKey PKey) {
        String S_ProcName = "lockBuff";
        CFSecurityISOCountryBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("ISOC")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityISOCountryBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamISOCountry.readAllBuff";
        ArrayList<CFSecurityISOCountryBuff> filteredList = new ArrayList<CFSecurityISOCountryBuff>();
        CFSecurityISOCountryBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityISOCountryBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("ISOC")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityISOCountryBuff[0]);
    }

    public CFSecurityISOCountryBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, short ISOCountryId) {
        String S_ProcName = "CFBamRamISOCountry.readBuffByIdIdx() ";
        CFSecurityISOCountryBuff buff = this.readDerivedByIdIdx(Authorization, ISOCountryId);
        if (buff != null && buff.getClassCode().equals("ISOC")) {
            return buff;
        }
        return null;
    }

    public CFSecurityISOCountryBuff readBuffByISOCodeIdx(CFSecurityAuthorization Authorization, String ISOCode) {
        String S_ProcName = "CFBamRamISOCountry.readBuffByISOCodeIdx() ";
        CFSecurityISOCountryBuff buff = this.readDerivedByISOCodeIdx(Authorization, ISOCode);
        if (buff != null && buff.getClassCode().equals("ISOC")) {
            return buff;
        }
        return null;
    }

    public CFSecurityISOCountryBuff readBuffByNameIdx(CFSecurityAuthorization Authorization, String Name) {
        String S_ProcName = "CFBamRamISOCountry.readBuffByNameIdx() ";
        CFSecurityISOCountryBuff buff = this.readDerivedByNameIdx(Authorization, Name);
        if (buff != null && buff.getClassCode().equals("ISOC")) {
            return buff;
        }
        return null;
    }

    public void updateISOCountry(CFSecurityAuthorization Authorization, CFSecurityISOCountryBuff Buff) {
        CFSecurityISOCountryPKey pkey = this.schema.getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(Buff.getRequiredISOCountryId());
        CFSecurityISOCountryBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateISOCountry", "Existing record not found", "ISOCountry", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateISOCountry", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFSecurityISOCountryByISOCodeIdxKey existingKeyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        existingKeyISOCodeIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFSecurityISOCountryByISOCodeIdxKey newKeyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        newKeyISOCodeIdx.setRequiredISOCode(Buff.getRequiredISOCode());
        CFSecurityISOCountryByNameIdxKey existingKeyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        existingKeyNameIdx.setRequiredName(existing.getRequiredName());
        CFSecurityISOCountryByNameIdxKey newKeyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        newKeyNameIdx.setRequiredName(Buff.getRequiredName());
        if (!existingKeyISOCodeIdx.equals((Object)newKeyISOCodeIdx) && this.dictByISOCodeIdx.containsKey(newKeyISOCodeIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCountry", "ISOCountryCodeIdx", (Object)newKeyISOCodeIdx);
        }
        if (!existingKeyNameIdx.equals((Object)newKeyNameIdx) && this.dictByNameIdx.containsKey(newKeyNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateISOCountry", "ISOCountryNameIdx", (Object)newKeyNameIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByISOCodeIdx.remove(existingKeyISOCodeIdx);
        this.dictByISOCodeIdx.put(newKeyISOCodeIdx, Buff);
        this.dictByNameIdx.remove(existingKeyNameIdx);
        this.dictByNameIdx.put(newKeyNameIdx, Buff);
    }

    public void deleteISOCountry(CFSecurityAuthorization Authorization, CFSecurityISOCountryBuff Buff) {
        String S_ProcName = "CFBamRamISOCountryTable.deleteISOCountry() ";
        CFSecurityISOCountryPKey pkey = this.schema.getFactoryISOCountry().newPKey();
        pkey.setRequiredISOCountryId(Buff.getRequiredISOCountryId());
        CFSecurityISOCountryBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteISOCountry", (Object)pkey);
        }
        this.schema.getTableISOCountryLanguage().deleteISOCountryLanguageByCountryIdx(Authorization, existing.getRequiredISOCountryId());
        this.schema.getTableISOCountryCurrency().deleteISOCountryCurrencyByCountryIdx(Authorization, existing.getRequiredISOCountryId());
        CFSecurityISOCountryByISOCodeIdxKey keyISOCodeIdx = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        keyISOCodeIdx.setRequiredISOCode(existing.getRequiredISOCode());
        CFSecurityISOCountryByNameIdxKey keyNameIdx = this.schema.getFactoryISOCountry().newNameIdxKey();
        keyNameIdx.setRequiredName(existing.getRequiredName());
        this.dictByPKey.remove(pkey);
        this.dictByISOCodeIdx.remove(keyISOCodeIdx);
        this.dictByNameIdx.remove(keyNameIdx);
    }

    public void deleteISOCountryByIdIdx(CFSecurityAuthorization Authorization, short argISOCountryId) {
        CFSecurityISOCountryPKey key = this.schema.getFactoryISOCountry().newPKey();
        key.setRequiredISOCountryId(argISOCountryId);
        this.deleteISOCountryByIdIdx(Authorization, key);
    }

    public void deleteISOCountryByIdIdx(CFSecurityAuthorization Authorization, CFSecurityISOCountryPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOCountryBuff> matchSet = new LinkedList<CFSecurityISOCountryBuff>();
        for (CFSecurityISOCountryBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOCountryBuff cur : matchSet) {
            cur = this.schema.getTableISOCountry().readDerivedByIdIdx(Authorization, cur.getRequiredISOCountryId());
            this.deleteISOCountry(Authorization, cur);
        }
    }

    public void deleteISOCountryByISOCodeIdx(CFSecurityAuthorization Authorization, String argISOCode) {
        CFSecurityISOCountryByISOCodeIdxKey key = this.schema.getFactoryISOCountry().newISOCodeIdxKey();
        key.setRequiredISOCode(argISOCode);
        this.deleteISOCountryByISOCodeIdx(Authorization, key);
    }

    public void deleteISOCountryByISOCodeIdx(CFSecurityAuthorization Authorization, CFSecurityISOCountryByISOCodeIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOCountryBuff> matchSet = new LinkedList<CFSecurityISOCountryBuff>();
        for (CFSecurityISOCountryBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOCountryBuff cur : matchSet) {
            cur = this.schema.getTableISOCountry().readDerivedByIdIdx(Authorization, cur.getRequiredISOCountryId());
            this.deleteISOCountry(Authorization, cur);
        }
    }

    public void deleteISOCountryByNameIdx(CFSecurityAuthorization Authorization, String argName) {
        CFSecurityISOCountryByNameIdxKey key = this.schema.getFactoryISOCountry().newNameIdxKey();
        key.setRequiredName(argName);
        this.deleteISOCountryByNameIdx(Authorization, key);
    }

    public void deleteISOCountryByNameIdx(CFSecurityAuthorization Authorization, CFSecurityISOCountryByNameIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityISOCountryBuff> matchSet = new LinkedList<CFSecurityISOCountryBuff>();
        for (CFSecurityISOCountryBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityISOCountryBuff cur : matchSet) {
            cur = this.schema.getTableISOCountry().readDerivedByIdIdx(Authorization, cur.getRequiredISOCountryId());
            this.deleteISOCountry(Authorization, cur);
        }
    }

    public CFSecurityCursor openISOCountryCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamISOCountryCursor cursor = new CFBamRamISOCountryCursor(Authorization, (ICFSecuritySchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public void closeISOCountryCursor(CFSecurityCursor Cursor) {
    }

    public CFSecurityISOCountryBuff nextISOCountryCursor(CFSecurityCursor Cursor) {
        CFBamRamISOCountryCursor cursor = (CFBamRamISOCountryCursor)Cursor;
        CFSecurityISOCountryBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFSecurityISOCountryBuff prevISOCountryCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFSecurityISOCountryBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCountryCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityISOCountryBuff firstISOCountryCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFSecurityISOCountryBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCountryCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityISOCountryBuff lastISOCountryCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastISOCountryCursor");
    }

    public CFSecurityISOCountryBuff nthISOCountryCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFSecurityISOCountryBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextISOCountryCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

