/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamHostNodeTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamClusterTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamHostNodeCursor;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityHostNodeBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityHostNodeByClusterIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityHostNodeByHostNameIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityHostNodeByUDescrIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityHostNodePKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;

public class CFBamRamHostNodeTable
implements ICFBamHostNodeTable {
    private ICFBamSchema schema;
    private Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff> dictByPKey = new HashMap<CFSecurityHostNodePKey, CFSecurityHostNodeBuff>();
    private Map<CFSecurityHostNodeByClusterIdxKey, Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff>> dictByClusterIdx = new HashMap<CFSecurityHostNodeByClusterIdxKey, Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff>>();
    private Map<CFSecurityHostNodeByUDescrIdxKey, CFSecurityHostNodeBuff> dictByUDescrIdx = new HashMap<CFSecurityHostNodeByUDescrIdxKey, CFSecurityHostNodeBuff>();
    private Map<CFSecurityHostNodeByHostNameIdxKey, CFSecurityHostNodeBuff> dictByHostNameIdx = new HashMap<CFSecurityHostNodeByHostNameIdxKey, CFSecurityHostNodeBuff>();

    public CFBamRamHostNodeTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    public void createHostNode(CFSecurityAuthorization Authorization, CFSecurityHostNodeBuff Buff) {
        Map<Object, Object> subdictClusterIdx;
        String S_ProcName = "createHostNode";
        CFSecurityHostNodePKey pkey = this.schema.getFactoryHostNode().newPKey();
        pkey.setRequiredClusterId(Buff.getRequiredClusterId());
        pkey.setRequiredHostNodeId(((CFBamRamClusterTable)this.schema.getTableCluster()).nextHostNodeIdGen(Authorization, Buff.getRequiredClusterId()));
        Buff.setRequiredClusterId(pkey.getRequiredClusterId());
        Buff.setRequiredHostNodeId(pkey.getRequiredHostNodeId());
        CFSecurityHostNodeByClusterIdxKey keyClusterIdx = this.schema.getFactoryHostNode().newClusterIdxKey();
        keyClusterIdx.setRequiredClusterId(Buff.getRequiredClusterId());
        CFSecurityHostNodeByUDescrIdxKey keyUDescrIdx = this.schema.getFactoryHostNode().newUDescrIdxKey();
        keyUDescrIdx.setRequiredClusterId(Buff.getRequiredClusterId());
        keyUDescrIdx.setRequiredDescription(Buff.getRequiredDescription());
        CFSecurityHostNodeByHostNameIdxKey keyHostNameIdx = this.schema.getFactoryHostNode().newHostNameIdxKey();
        keyHostNameIdx.setRequiredClusterId(Buff.getRequiredClusterId());
        keyHostNameIdx.setRequiredHostName(Buff.getRequiredHostName());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createHostNode", (Object)pkey);
        }
        if (this.dictByUDescrIdx.containsKey(keyUDescrIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createHostNode", "HostNodeUDescrIdx", (Object)keyUDescrIdx);
        }
        if (this.dictByHostNameIdx.containsKey(keyHostNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createHostNode", "HostNodeUHostNameIdx", (Object)keyHostNameIdx);
        }
        boolean allNull = true;
        allNull = false;
        if (!allNull && null == this.schema.getTableCluster().readDerivedByIdIdx(Authorization, Buff.getRequiredClusterId())) {
            throw CFLib.getDefaultExceptionFactory().newUnresolvedRelationException(this.getClass(), "createHostNode", "Container", "HostNodeCluster", "Cluster", null);
        }
        this.dictByPKey.put(pkey, Buff);
        if (this.dictByClusterIdx.containsKey(keyClusterIdx)) {
            subdictClusterIdx = this.dictByClusterIdx.get(keyClusterIdx);
        } else {
            subdictClusterIdx = new HashMap();
            this.dictByClusterIdx.put(keyClusterIdx, subdictClusterIdx);
        }
        subdictClusterIdx.put(pkey, Buff);
        this.dictByUDescrIdx.put(keyUDescrIdx, Buff);
        this.dictByHostNameIdx.put(keyHostNameIdx, Buff);
    }

    public CFSecurityHostNodeBuff readDerived(CFSecurityAuthorization Authorization, CFSecurityHostNodePKey PKey) {
        String S_ProcName = "CFBamRamHostNode.readDerived";
        CFSecurityHostNodePKey key = this.schema.getFactoryHostNode().newPKey();
        key.setRequiredClusterId(PKey.getRequiredClusterId());
        key.setRequiredHostNodeId(PKey.getRequiredHostNodeId());
        CFSecurityHostNodeBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityHostNodeBuff lockDerived(CFSecurityAuthorization Authorization, CFSecurityHostNodePKey PKey) {
        String S_ProcName = "CFBamRamHostNode.readDerived";
        CFSecurityHostNodePKey key = this.schema.getFactoryHostNode().newPKey();
        key.setRequiredClusterId(PKey.getRequiredClusterId());
        key.setRequiredHostNodeId(PKey.getRequiredHostNodeId());
        CFSecurityHostNodeBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityHostNodeBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamHostNode.readAllDerived";
        CFSecurityHostNodeBuff[] retList = new CFSecurityHostNodeBuff[this.dictByPKey.values().size()];
        Iterator<CFSecurityHostNodeBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFSecurityHostNodeBuff[] readDerivedByClusterIdx(CFSecurityAuthorization Authorization, long ClusterId) {
        CFSecurityHostNodeBuff[] recArray;
        String S_ProcName = "CFBamRamHostNode.readDerivedByClusterIdx";
        CFSecurityHostNodeByClusterIdxKey key = this.schema.getFactoryHostNode().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.dictByClusterIdx.containsKey(key)) {
            Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff> subdictClusterIdx = this.dictByClusterIdx.get(key);
            recArray = new CFSecurityHostNodeBuff[subdictClusterIdx.size()];
            Iterator<CFSecurityHostNodeBuff> iter = subdictClusterIdx.values().iterator();
            int idx = 0;
            while (iter.hasNext()) {
                recArray[idx++] = iter.next();
            }
        } else {
            HashMap subdictClusterIdx = new HashMap();
            this.dictByClusterIdx.put(key, subdictClusterIdx);
            recArray = new CFSecurityHostNodeBuff[]{};
        }
        return recArray;
    }

    public CFSecurityHostNodeBuff readDerivedByUDescrIdx(CFSecurityAuthorization Authorization, long ClusterId, String Description) {
        String S_ProcName = "CFBamRamHostNode.readDerivedByUDescrIdx";
        CFSecurityHostNodeByUDescrIdxKey key = this.schema.getFactoryHostNode().newUDescrIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredDescription(Description);
        CFSecurityHostNodeBuff buff = this.dictByUDescrIdx.containsKey(key) ? this.dictByUDescrIdx.get(key) : null;
        return buff;
    }

    public CFSecurityHostNodeBuff readDerivedByHostNameIdx(CFSecurityAuthorization Authorization, long ClusterId, String HostName) {
        String S_ProcName = "CFBamRamHostNode.readDerivedByHostNameIdx";
        CFSecurityHostNodeByHostNameIdxKey key = this.schema.getFactoryHostNode().newHostNameIdxKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostName(HostName);
        CFSecurityHostNodeBuff buff = this.dictByHostNameIdx.containsKey(key) ? this.dictByHostNameIdx.get(key) : null;
        return buff;
    }

    public CFSecurityHostNodeBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, long ClusterId, long HostNodeId) {
        String S_ProcName = "CFBamRamHostNode.readDerivedByIdIdx() ";
        CFSecurityHostNodePKey key = this.schema.getFactoryHostNode().newPKey();
        key.setRequiredClusterId(ClusterId);
        key.setRequiredHostNodeId(HostNodeId);
        CFSecurityHostNodeBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityHostNodeBuff readBuff(CFSecurityAuthorization Authorization, CFSecurityHostNodePKey PKey) {
        String S_ProcName = "CFBamRamHostNode.readBuff";
        CFSecurityHostNodeBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("HSND")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityHostNodeBuff lockBuff(CFSecurityAuthorization Authorization, CFSecurityHostNodePKey PKey) {
        String S_ProcName = "lockBuff";
        CFSecurityHostNodeBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("HSND")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityHostNodeBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamHostNode.readAllBuff";
        ArrayList<CFSecurityHostNodeBuff> filteredList = new ArrayList<CFSecurityHostNodeBuff>();
        CFSecurityHostNodeBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityHostNodeBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("HSND")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityHostNodeBuff[0]);
    }

    public CFSecurityHostNodeBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, long ClusterId, long HostNodeId) {
        String S_ProcName = "CFBamRamHostNode.readBuffByIdIdx() ";
        CFSecurityHostNodeBuff buff = this.readDerivedByIdIdx(Authorization, ClusterId, HostNodeId);
        if (buff != null && buff.getClassCode().equals("HSND")) {
            return buff;
        }
        return null;
    }

    public CFSecurityHostNodeBuff[] readBuffByClusterIdx(CFSecurityAuthorization Authorization, long ClusterId) {
        String S_ProcName = "CFBamRamHostNode.readBuffByClusterIdx() ";
        ArrayList<CFSecurityHostNodeBuff> filteredList = new ArrayList<CFSecurityHostNodeBuff>();
        CFSecurityHostNodeBuff[] buffList = this.readDerivedByClusterIdx(Authorization, ClusterId);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityHostNodeBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("HSND")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityHostNodeBuff[0]);
    }

    public CFSecurityHostNodeBuff readBuffByUDescrIdx(CFSecurityAuthorization Authorization, long ClusterId, String Description) {
        String S_ProcName = "CFBamRamHostNode.readBuffByUDescrIdx() ";
        CFSecurityHostNodeBuff buff = this.readDerivedByUDescrIdx(Authorization, ClusterId, Description);
        if (buff != null && buff.getClassCode().equals("HSND")) {
            return buff;
        }
        return null;
    }

    public CFSecurityHostNodeBuff readBuffByHostNameIdx(CFSecurityAuthorization Authorization, long ClusterId, String HostName) {
        String S_ProcName = "CFBamRamHostNode.readBuffByHostNameIdx() ";
        CFSecurityHostNodeBuff buff = this.readDerivedByHostNameIdx(Authorization, ClusterId, HostName);
        if (buff != null && buff.getClassCode().equals("HSND")) {
            return buff;
        }
        return null;
    }

    public void updateHostNode(CFSecurityAuthorization Authorization, CFSecurityHostNodeBuff Buff) {
        CFSecurityHostNodePKey pkey = this.schema.getFactoryHostNode().newPKey();
        pkey.setRequiredClusterId(Buff.getRequiredClusterId());
        pkey.setRequiredHostNodeId(Buff.getRequiredHostNodeId());
        CFSecurityHostNodeBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateHostNode", "Existing record not found", "HostNode", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateHostNode", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFSecurityHostNodeByClusterIdxKey existingKeyClusterIdx = this.schema.getFactoryHostNode().newClusterIdxKey();
        existingKeyClusterIdx.setRequiredClusterId(existing.getRequiredClusterId());
        CFSecurityHostNodeByClusterIdxKey newKeyClusterIdx = this.schema.getFactoryHostNode().newClusterIdxKey();
        newKeyClusterIdx.setRequiredClusterId(Buff.getRequiredClusterId());
        CFSecurityHostNodeByUDescrIdxKey existingKeyUDescrIdx = this.schema.getFactoryHostNode().newUDescrIdxKey();
        existingKeyUDescrIdx.setRequiredClusterId(existing.getRequiredClusterId());
        existingKeyUDescrIdx.setRequiredDescription(existing.getRequiredDescription());
        CFSecurityHostNodeByUDescrIdxKey newKeyUDescrIdx = this.schema.getFactoryHostNode().newUDescrIdxKey();
        newKeyUDescrIdx.setRequiredClusterId(Buff.getRequiredClusterId());
        newKeyUDescrIdx.setRequiredDescription(Buff.getRequiredDescription());
        CFSecurityHostNodeByHostNameIdxKey existingKeyHostNameIdx = this.schema.getFactoryHostNode().newHostNameIdxKey();
        existingKeyHostNameIdx.setRequiredClusterId(existing.getRequiredClusterId());
        existingKeyHostNameIdx.setRequiredHostName(existing.getRequiredHostName());
        CFSecurityHostNodeByHostNameIdxKey newKeyHostNameIdx = this.schema.getFactoryHostNode().newHostNameIdxKey();
        newKeyHostNameIdx.setRequiredClusterId(Buff.getRequiredClusterId());
        newKeyHostNameIdx.setRequiredHostName(Buff.getRequiredHostName());
        if (!existingKeyUDescrIdx.equals((Object)newKeyUDescrIdx) && this.dictByUDescrIdx.containsKey(newKeyUDescrIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateHostNode", "HostNodeUDescrIdx", (Object)newKeyUDescrIdx);
        }
        if (!existingKeyHostNameIdx.equals((Object)newKeyHostNameIdx) && this.dictByHostNameIdx.containsKey(newKeyHostNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateHostNode", "HostNodeUHostNameIdx", (Object)newKeyHostNameIdx);
        }
        boolean allNull = true;
        if (allNull && null == this.schema.getTableCluster().readDerivedByIdIdx(Authorization, Buff.getRequiredClusterId())) {
            throw CFLib.getDefaultExceptionFactory().newUnresolvedRelationException(this.getClass(), "updateHostNode", "Container", "HostNodeCluster", "Cluster", null);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff> subdict = this.dictByClusterIdx.get(existingKeyClusterIdx);
        if (subdict != null) {
            subdict.remove(pkey);
        }
        if (this.dictByClusterIdx.containsKey(newKeyClusterIdx)) {
            subdict = this.dictByClusterIdx.get(newKeyClusterIdx);
        } else {
            subdict = new HashMap<CFSecurityHostNodePKey, CFSecurityHostNodeBuff>();
            this.dictByClusterIdx.put(newKeyClusterIdx, subdict);
        }
        subdict.put(pkey, Buff);
        this.dictByUDescrIdx.remove(existingKeyUDescrIdx);
        this.dictByUDescrIdx.put(newKeyUDescrIdx, Buff);
        this.dictByHostNameIdx.remove(existingKeyHostNameIdx);
        this.dictByHostNameIdx.put(newKeyHostNameIdx, Buff);
    }

    public void deleteHostNode(CFSecurityAuthorization Authorization, CFSecurityHostNodeBuff Buff) {
        String S_ProcName = "CFBamRamHostNodeTable.deleteHostNode() ";
        CFSecurityHostNodePKey pkey = this.schema.getFactoryHostNode().newPKey();
        pkey.setRequiredClusterId(Buff.getRequiredClusterId());
        pkey.setRequiredHostNodeId(Buff.getRequiredHostNodeId());
        CFSecurityHostNodeBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteHostNode", (Object)pkey);
        }
        this.schema.getTableService().deleteServiceByHostIdx(Authorization, existing.getRequiredClusterId(), existing.getRequiredHostNodeId());
        CFSecurityHostNodeByClusterIdxKey keyClusterIdx = this.schema.getFactoryHostNode().newClusterIdxKey();
        keyClusterIdx.setRequiredClusterId(existing.getRequiredClusterId());
        CFSecurityHostNodeByUDescrIdxKey keyUDescrIdx = this.schema.getFactoryHostNode().newUDescrIdxKey();
        keyUDescrIdx.setRequiredClusterId(existing.getRequiredClusterId());
        keyUDescrIdx.setRequiredDescription(existing.getRequiredDescription());
        CFSecurityHostNodeByHostNameIdxKey keyHostNameIdx = this.schema.getFactoryHostNode().newHostNameIdxKey();
        keyHostNameIdx.setRequiredClusterId(existing.getRequiredClusterId());
        keyHostNameIdx.setRequiredHostName(existing.getRequiredHostName());
        this.dictByPKey.remove(pkey);
        Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff> subdict = this.dictByClusterIdx.get(keyClusterIdx);
        subdict.remove(pkey);
        this.dictByUDescrIdx.remove(keyUDescrIdx);
        this.dictByHostNameIdx.remove(keyHostNameIdx);
    }

    public void deleteHostNodeByIdIdx(CFSecurityAuthorization Authorization, long argClusterId, long argHostNodeId) {
        CFSecurityHostNodePKey key = this.schema.getFactoryHostNode().newPKey();
        key.setRequiredClusterId(argClusterId);
        key.setRequiredHostNodeId(argHostNodeId);
        this.deleteHostNodeByIdIdx(Authorization, key);
    }

    public void deleteHostNodeByIdIdx(CFSecurityAuthorization Authorization, CFSecurityHostNodePKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityHostNodeBuff> matchSet = new LinkedList<CFSecurityHostNodeBuff>();
        for (CFSecurityHostNodeBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityHostNodeBuff cur : matchSet) {
            cur = this.schema.getTableHostNode().readDerivedByIdIdx(Authorization, cur.getRequiredClusterId(), cur.getRequiredHostNodeId());
            this.deleteHostNode(Authorization, cur);
        }
    }

    public void deleteHostNodeByClusterIdx(CFSecurityAuthorization Authorization, long argClusterId) {
        CFSecurityHostNodeByClusterIdxKey key = this.schema.getFactoryHostNode().newClusterIdxKey();
        key.setRequiredClusterId(argClusterId);
        this.deleteHostNodeByClusterIdx(Authorization, key);
    }

    public void deleteHostNodeByClusterIdx(CFSecurityAuthorization Authorization, CFSecurityHostNodeByClusterIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityHostNodeBuff> matchSet = new LinkedList<CFSecurityHostNodeBuff>();
        for (CFSecurityHostNodeBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityHostNodeBuff cur : matchSet) {
            cur = this.schema.getTableHostNode().readDerivedByIdIdx(Authorization, cur.getRequiredClusterId(), cur.getRequiredHostNodeId());
            this.deleteHostNode(Authorization, cur);
        }
    }

    public void deleteHostNodeByUDescrIdx(CFSecurityAuthorization Authorization, long argClusterId, String argDescription) {
        CFSecurityHostNodeByUDescrIdxKey key = this.schema.getFactoryHostNode().newUDescrIdxKey();
        key.setRequiredClusterId(argClusterId);
        key.setRequiredDescription(argDescription);
        this.deleteHostNodeByUDescrIdx(Authorization, key);
    }

    public void deleteHostNodeByUDescrIdx(CFSecurityAuthorization Authorization, CFSecurityHostNodeByUDescrIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityHostNodeBuff> matchSet = new LinkedList<CFSecurityHostNodeBuff>();
        for (CFSecurityHostNodeBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityHostNodeBuff cur : matchSet) {
            cur = this.schema.getTableHostNode().readDerivedByIdIdx(Authorization, cur.getRequiredClusterId(), cur.getRequiredHostNodeId());
            this.deleteHostNode(Authorization, cur);
        }
    }

    public void deleteHostNodeByHostNameIdx(CFSecurityAuthorization Authorization, long argClusterId, String argHostName) {
        CFSecurityHostNodeByHostNameIdxKey key = this.schema.getFactoryHostNode().newHostNameIdxKey();
        key.setRequiredClusterId(argClusterId);
        key.setRequiredHostName(argHostName);
        this.deleteHostNodeByHostNameIdx(Authorization, key);
    }

    public void deleteHostNodeByHostNameIdx(CFSecurityAuthorization Authorization, CFSecurityHostNodeByHostNameIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityHostNodeBuff> matchSet = new LinkedList<CFSecurityHostNodeBuff>();
        for (CFSecurityHostNodeBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityHostNodeBuff cur : matchSet) {
            cur = this.schema.getTableHostNode().readDerivedByIdIdx(Authorization, cur.getRequiredClusterId(), cur.getRequiredHostNodeId());
            this.deleteHostNode(Authorization, cur);
        }
    }

    public CFSecurityCursor openHostNodeCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamHostNodeCursor cursor = new CFBamRamHostNodeCursor(Authorization, (ICFSecuritySchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public CFSecurityCursor openHostNodeCursorByClusterIdx(CFSecurityAuthorization Authorization, long ClusterId) {
        CFBamRamHostNodeCursor cursor;
        CFSecurityHostNodeByClusterIdxKey key = this.schema.getFactoryHostNode().newClusterIdxKey();
        key.setRequiredClusterId(ClusterId);
        if (this.dictByClusterIdx.containsKey(key)) {
            Map<CFSecurityHostNodePKey, CFSecurityHostNodeBuff> subdictClusterIdx = this.dictByClusterIdx.get(key);
            cursor = new CFBamRamHostNodeCursor(Authorization, (ICFSecuritySchema)this.schema, subdictClusterIdx.values());
        } else {
            cursor = new CFBamRamHostNodeCursor(Authorization, (ICFSecuritySchema)this.schema, new ArrayList<CFSecurityHostNodeBuff>());
        }
        return cursor;
    }

    public void closeHostNodeCursor(CFSecurityCursor Cursor) {
    }

    public CFSecurityHostNodeBuff nextHostNodeCursor(CFSecurityCursor Cursor) {
        CFBamRamHostNodeCursor cursor = (CFBamRamHostNodeCursor)Cursor;
        CFSecurityHostNodeBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFSecurityHostNodeBuff prevHostNodeCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFSecurityHostNodeBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextHostNodeCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityHostNodeBuff firstHostNodeCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFSecurityHostNodeBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextHostNodeCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityHostNodeBuff lastHostNodeCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastHostNodeCursor");
    }

    public CFSecurityHostNodeBuff nthHostNodeCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFSecurityHostNodeBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextHostNodeCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

