/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamClusterTable;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBam.ICFBamSchema;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamClusterCursor;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamClusterId32Gen;
import net.sourceforge.msscodefactory.cfbam.v2_9.CFBamRam.CFBamRamClusterId64Gen;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityAuthorization;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityClusterBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityClusterByUDescrIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityClusterByUDomainNameIdxKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityClusterPKey;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecurityCursor;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecuritySecAppBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.CFSecuritySecGroupBuff;
import net.sourceforge.msscodefactory.cfsecurity.v2_9.CFSecurity.ICFSecuritySchema;

public class CFBamRamClusterTable
implements ICFBamClusterTable {
    private ICFBamSchema schema;
    private Map<CFSecurityClusterPKey, CFSecurityClusterBuff> dictByPKey = new HashMap<CFSecurityClusterPKey, CFSecurityClusterBuff>();
    private Map<CFSecurityClusterByUDomainNameIdxKey, CFSecurityClusterBuff> dictByUDomainNameIdx = new HashMap<CFSecurityClusterByUDomainNameIdxKey, CFSecurityClusterBuff>();
    private Map<CFSecurityClusterByUDescrIdxKey, CFSecurityClusterBuff> dictByUDescrIdx = new HashMap<CFSecurityClusterByUDescrIdxKey, CFSecurityClusterBuff>();
    private Map<CFBamRamClusterId32Gen, CFBamRamClusterId32Gen> id32Generator = new HashMap<CFBamRamClusterId32Gen, CFBamRamClusterId32Gen>();
    private Map<CFBamRamClusterId64Gen, CFBamRamClusterId64Gen> id64Generator = new HashMap<CFBamRamClusterId64Gen, CFBamRamClusterId64Gen>();

    public CFBamRamClusterTable(ICFBamSchema argSchema) {
        this.schema = argSchema;
    }

    protected int generateNextId32(long argId, short argSliceId) {
        CFBamRamClusterId32Gen key = new CFBamRamClusterId32Gen();
        key.setRequiredId(argId);
        key.setRequiredSliceId(argSliceId);
        CFBamRamClusterId32Gen useGen = this.id32Generator.get(key);
        if (useGen == null) {
            this.id32Generator.put(key, key);
            useGen = key;
        }
        int retNext = useGen.getNextId();
        return retNext;
    }

    protected long generateNextId64(long argId, short argSliceId) {
        CFBamRamClusterId64Gen key = new CFBamRamClusterId64Gen();
        key.setRequiredId(argId);
        key.setRequiredSliceId(argSliceId);
        CFBamRamClusterId64Gen useGen = this.id64Generator.get(key);
        if (useGen == null) {
            this.id64Generator.put(key, key);
            useGen = key;
        }
        long retNext = useGen.getNextId();
        return retNext;
    }

    public int nextSecAppIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        int retval = this.nextSecAppIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public int nextSecAppIdGen(CFSecurityAuthorization Authorization, long argId) {
        int retNext = this.generateNextId32(argId, (short)107);
        return retNext;
    }

    public int nextSecFormIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        int retval = this.nextSecFormIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public int nextSecFormIdGen(CFSecurityAuthorization Authorization, long argId) {
        int retNext = this.generateNextId32(argId, (short)108);
        return retNext;
    }

    public int nextSecGroupIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        int retval = this.nextSecGroupIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public int nextSecGroupIdGen(CFSecurityAuthorization Authorization, long argId) {
        int retNext = this.generateNextId32(argId, (short)109);
        return retNext;
    }

    public long nextHostNodeIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        long retval = this.nextHostNodeIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public long nextHostNodeIdGen(CFSecurityAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)116);
        return retNext;
    }

    public long nextSecGroupFormIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        long retval = this.nextSecGroupFormIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public long nextSecGroupFormIdGen(CFSecurityAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)112);
        return retNext;
    }

    public long nextSecGroupIncludeIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        long retval = this.nextSecGroupIncludeIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public long nextSecGroupIncludeIdGen(CFSecurityAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)111);
        return retNext;
    }

    public long nextSecGroupMemberIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        long retval = this.nextSecGroupMemberIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public long nextSecGroupMemberIdGen(CFSecurityAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)110);
        return retNext;
    }

    public long nextServiceIdGen(CFSecurityAuthorization Authorization, CFSecurityClusterPKey pkey) {
        long retval = this.nextServiceIdGen(Authorization, pkey.getRequiredId());
        return retval;
    }

    public long nextServiceIdGen(CFSecurityAuthorization Authorization, long argId) {
        long retNext = this.generateNextId64(argId, (short)115);
        return retNext;
    }

    public void createCluster(CFSecurityAuthorization Authorization, CFSecurityClusterBuff Buff) {
        String S_ProcName = "createCluster";
        CFSecurityClusterPKey pkey = this.schema.getFactoryCluster().newPKey();
        pkey.setRequiredId(this.schema.nextClusterIdGen());
        Buff.setRequiredId(pkey.getRequiredId());
        CFSecurityClusterByUDomainNameIdxKey keyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        keyUDomainNameIdx.setRequiredFullDomainName(Buff.getRequiredFullDomainName());
        CFSecurityClusterByUDescrIdxKey keyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        keyUDescrIdx.setRequiredDescription(Buff.getRequiredDescription());
        if (this.dictByPKey.containsKey(pkey)) {
            throw CFLib.getDefaultExceptionFactory().newPrimaryKeyNotNewException(this.getClass(), "createCluster", (Object)pkey);
        }
        if (this.dictByUDomainNameIdx.containsKey(keyUDomainNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createCluster", "ClusterUDomainNameIdx", (Object)keyUDomainNameIdx);
        }
        if (this.dictByUDescrIdx.containsKey(keyUDescrIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "createCluster", "ClusterUDescrNameIdx", (Object)keyUDescrIdx);
        }
        this.dictByPKey.put(pkey, Buff);
        this.dictByUDomainNameIdx.put(keyUDomainNameIdx, Buff);
        this.dictByUDescrIdx.put(keyUDescrIdx, Buff);
    }

    public CFSecurityClusterBuff readDerived(CFSecurityAuthorization Authorization, CFSecurityClusterPKey PKey) {
        String S_ProcName = "CFBamRamCluster.readDerived";
        CFSecurityClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(PKey.getRequiredId());
        CFSecurityClusterBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityClusterBuff lockDerived(CFSecurityAuthorization Authorization, CFSecurityClusterPKey PKey) {
        String S_ProcName = "CFBamRamCluster.readDerived";
        CFSecurityClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(PKey.getRequiredId());
        CFSecurityClusterBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityClusterBuff[] readAllDerived(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamCluster.readAllDerived";
        CFSecurityClusterBuff[] retList = new CFSecurityClusterBuff[this.dictByPKey.values().size()];
        Iterator<CFSecurityClusterBuff> iter = this.dictByPKey.values().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            retList[idx++] = iter.next();
        }
        return retList;
    }

    public CFSecurityClusterBuff readDerivedByUDomainNameIdx(CFSecurityAuthorization Authorization, String FullDomainName) {
        String S_ProcName = "CFBamRamCluster.readDerivedByUDomainNameIdx";
        CFSecurityClusterByUDomainNameIdxKey key = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        key.setRequiredFullDomainName(FullDomainName);
        CFSecurityClusterBuff buff = this.dictByUDomainNameIdx.containsKey(key) ? this.dictByUDomainNameIdx.get(key) : null;
        return buff;
    }

    public CFSecurityClusterBuff readDerivedByUDescrIdx(CFSecurityAuthorization Authorization, String Description) {
        String S_ProcName = "CFBamRamCluster.readDerivedByUDescrIdx";
        CFSecurityClusterByUDescrIdxKey key = this.schema.getFactoryCluster().newUDescrIdxKey();
        key.setRequiredDescription(Description);
        CFSecurityClusterBuff buff = this.dictByUDescrIdx.containsKey(key) ? this.dictByUDescrIdx.get(key) : null;
        return buff;
    }

    public CFSecurityClusterBuff readDerivedByIdIdx(CFSecurityAuthorization Authorization, long Id) {
        String S_ProcName = "CFBamRamCluster.readDerivedByIdIdx() ";
        CFSecurityClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(Id);
        CFSecurityClusterBuff buff = this.dictByPKey.containsKey(key) ? this.dictByPKey.get(key) : null;
        return buff;
    }

    public CFSecurityClusterBuff readBuff(CFSecurityAuthorization Authorization, CFSecurityClusterPKey PKey) {
        String S_ProcName = "CFBamRamCluster.readBuff";
        CFSecurityClusterBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("CLUS")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityClusterBuff lockBuff(CFSecurityAuthorization Authorization, CFSecurityClusterPKey PKey) {
        String S_ProcName = "lockBuff";
        CFSecurityClusterBuff buff = this.readDerived(Authorization, PKey);
        if (buff != null && !buff.getClassCode().equals("CLUS")) {
            buff = null;
        }
        return buff;
    }

    public CFSecurityClusterBuff[] readAllBuff(CFSecurityAuthorization Authorization) {
        String S_ProcName = "CFBamRamCluster.readAllBuff";
        ArrayList<CFSecurityClusterBuff> filteredList = new ArrayList<CFSecurityClusterBuff>();
        CFSecurityClusterBuff[] buffList = this.readAllDerived(Authorization);
        for (int idx = 0; idx < buffList.length; ++idx) {
            CFSecurityClusterBuff buff = buffList[idx];
            if (buff == null || !buff.getClassCode().equals("CLUS")) continue;
            filteredList.add(buff);
        }
        return filteredList.toArray(new CFSecurityClusterBuff[0]);
    }

    public CFSecurityClusterBuff readBuffByIdIdx(CFSecurityAuthorization Authorization, long Id) {
        String S_ProcName = "CFBamRamCluster.readBuffByIdIdx() ";
        CFSecurityClusterBuff buff = this.readDerivedByIdIdx(Authorization, Id);
        if (buff != null && buff.getClassCode().equals("CLUS")) {
            return buff;
        }
        return null;
    }

    public CFSecurityClusterBuff readBuffByUDomainNameIdx(CFSecurityAuthorization Authorization, String FullDomainName) {
        String S_ProcName = "CFBamRamCluster.readBuffByUDomainNameIdx() ";
        CFSecurityClusterBuff buff = this.readDerivedByUDomainNameIdx(Authorization, FullDomainName);
        if (buff != null && buff.getClassCode().equals("CLUS")) {
            return buff;
        }
        return null;
    }

    public CFSecurityClusterBuff readBuffByUDescrIdx(CFSecurityAuthorization Authorization, String Description) {
        String S_ProcName = "CFBamRamCluster.readBuffByUDescrIdx() ";
        CFSecurityClusterBuff buff = this.readDerivedByUDescrIdx(Authorization, Description);
        if (buff != null && buff.getClassCode().equals("CLUS")) {
            return buff;
        }
        return null;
    }

    public void updateCluster(CFSecurityAuthorization Authorization, CFSecurityClusterBuff Buff) {
        CFSecurityClusterPKey pkey = this.schema.getFactoryCluster().newPKey();
        pkey.setRequiredId(Buff.getRequiredId());
        CFSecurityClusterBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            throw CFLib.getDefaultExceptionFactory().newStaleCacheDetectedException(this.getClass(), "updateCluster", "Existing record not found", "Cluster", (Object)pkey);
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "updateCluster", (Object)pkey);
        }
        Buff.setRequiredRevision(Buff.getRequiredRevision() + 1);
        CFSecurityClusterByUDomainNameIdxKey existingKeyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        existingKeyUDomainNameIdx.setRequiredFullDomainName(existing.getRequiredFullDomainName());
        CFSecurityClusterByUDomainNameIdxKey newKeyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        newKeyUDomainNameIdx.setRequiredFullDomainName(Buff.getRequiredFullDomainName());
        CFSecurityClusterByUDescrIdxKey existingKeyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        existingKeyUDescrIdx.setRequiredDescription(existing.getRequiredDescription());
        CFSecurityClusterByUDescrIdxKey newKeyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        newKeyUDescrIdx.setRequiredDescription(Buff.getRequiredDescription());
        if (!existingKeyUDomainNameIdx.equals((Object)newKeyUDomainNameIdx) && this.dictByUDomainNameIdx.containsKey(newKeyUDomainNameIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateCluster", "ClusterUDomainNameIdx", (Object)newKeyUDomainNameIdx);
        }
        if (!existingKeyUDescrIdx.equals((Object)newKeyUDescrIdx) && this.dictByUDescrIdx.containsKey(newKeyUDescrIdx)) {
            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "updateCluster", "ClusterUDescrNameIdx", (Object)newKeyUDescrIdx);
        }
        this.dictByPKey.remove(pkey);
        this.dictByPKey.put(pkey, Buff);
        this.dictByUDomainNameIdx.remove(existingKeyUDomainNameIdx);
        this.dictByUDomainNameIdx.put(newKeyUDomainNameIdx, Buff);
        this.dictByUDescrIdx.remove(existingKeyUDescrIdx);
        this.dictByUDescrIdx.put(newKeyUDescrIdx, Buff);
    }

    public void deleteCluster(CFSecurityAuthorization Authorization, CFSecurityClusterBuff Buff) {
        String S_ProcName = "CFBamRamClusterTable.deleteCluster() ";
        CFSecurityClusterPKey pkey = this.schema.getFactoryCluster().newPKey();
        pkey.setRequiredId(Buff.getRequiredId());
        CFSecurityClusterBuff existing = this.dictByPKey.get(pkey);
        if (existing == null) {
            return;
        }
        if (existing.getRequiredRevision() != Buff.getRequiredRevision()) {
            throw CFLib.getDefaultExceptionFactory().newCollisionDetectedException(this.getClass(), "deleteCluster", (Object)pkey);
        }
        CFSecuritySecGroupBuff[] arrDelSecGroupForms = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupForms = 0; idxDelSecGroupForms < arrDelSecGroupForms.length; ++idxDelSecGroupForms) {
            CFSecuritySecGroupBuff buffDelSecGroupForms = arrDelSecGroupForms[idxDelSecGroupForms];
            this.schema.getTableSecGroupForm().deleteSecGroupFormByGroupIdx(Authorization, buffDelSecGroupForms.getRequiredClusterId(), buffDelSecGroupForms.getRequiredSecGroupId());
        }
        CFSecuritySecGroupBuff[] arrDelSecGroupIncludedByGroup = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupIncludedByGroup = 0; idxDelSecGroupIncludedByGroup < arrDelSecGroupIncludedByGroup.length; ++idxDelSecGroupIncludedByGroup) {
            CFSecuritySecGroupBuff buffDelSecGroupIncludedByGroup = arrDelSecGroupIncludedByGroup[idxDelSecGroupIncludedByGroup];
            this.schema.getTableSecGroupInclude().deleteSecGroupIncludeByIncludeIdx(Authorization, buffDelSecGroupIncludedByGroup.getRequiredClusterId(), buffDelSecGroupIncludedByGroup.getRequiredSecGroupId());
        }
        CFSecuritySecGroupBuff[] arrDelSecGroupMembers = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupMembers = 0; idxDelSecGroupMembers < arrDelSecGroupMembers.length; ++idxDelSecGroupMembers) {
            CFSecuritySecGroupBuff buffDelSecGroupMembers = arrDelSecGroupMembers[idxDelSecGroupMembers];
            this.schema.getTableSecGroupMember().deleteSecGroupMemberByGroupIdx(Authorization, buffDelSecGroupMembers.getRequiredClusterId(), buffDelSecGroupMembers.getRequiredSecGroupId());
        }
        CFSecuritySecGroupBuff[] arrDelSecGroupIncludes = this.schema.getTableSecGroup().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecGroupIncludes = 0; idxDelSecGroupIncludes < arrDelSecGroupIncludes.length; ++idxDelSecGroupIncludes) {
            CFSecuritySecGroupBuff buffDelSecGroupIncludes = arrDelSecGroupIncludes[idxDelSecGroupIncludes];
            this.schema.getTableSecGroupInclude().deleteSecGroupIncludeByGroupIdx(Authorization, buffDelSecGroupIncludes.getRequiredClusterId(), buffDelSecGroupIncludes.getRequiredSecGroupId());
        }
        this.schema.getTableSecGroup().deleteSecGroupByClusterIdx(Authorization, existing.getRequiredId());
        CFSecuritySecAppBuff[] arrDelSecAppForms = this.schema.getTableSecApp().readDerivedByClusterIdx(Authorization, existing.getRequiredId());
        for (int idxDelSecAppForms = 0; idxDelSecAppForms < arrDelSecAppForms.length; ++idxDelSecAppForms) {
            CFSecuritySecAppBuff buffDelSecAppForms = arrDelSecAppForms[idxDelSecAppForms];
            this.schema.getTableSecForm().deleteSecFormBySecAppIdx(Authorization, buffDelSecAppForms.getRequiredClusterId(), buffDelSecAppForms.getRequiredSecAppId());
        }
        this.schema.getTableSecApp().deleteSecAppByClusterIdx(Authorization, existing.getRequiredId());
        this.schema.getTableTenant().deleteTenantByClusterIdx(Authorization, existing.getRequiredId());
        this.schema.getTableHostNode().deleteHostNodeByClusterIdx(Authorization, existing.getRequiredId());
        CFSecurityClusterByUDomainNameIdxKey keyUDomainNameIdx = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        keyUDomainNameIdx.setRequiredFullDomainName(existing.getRequiredFullDomainName());
        CFSecurityClusterByUDescrIdxKey keyUDescrIdx = this.schema.getFactoryCluster().newUDescrIdxKey();
        keyUDescrIdx.setRequiredDescription(existing.getRequiredDescription());
        this.dictByPKey.remove(pkey);
        this.dictByUDomainNameIdx.remove(keyUDomainNameIdx);
        this.dictByUDescrIdx.remove(keyUDescrIdx);
    }

    public void deleteClusterByIdIdx(CFSecurityAuthorization Authorization, long argId) {
        CFSecurityClusterPKey key = this.schema.getFactoryCluster().newPKey();
        key.setRequiredId(argId);
        this.deleteClusterByIdIdx(Authorization, key);
    }

    public void deleteClusterByIdIdx(CFSecurityAuthorization Authorization, CFSecurityClusterPKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityClusterBuff> matchSet = new LinkedList<CFSecurityClusterBuff>();
        for (CFSecurityClusterBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityClusterBuff cur : matchSet) {
            cur = this.schema.getTableCluster().readDerivedByIdIdx(Authorization, cur.getRequiredId());
            this.deleteCluster(Authorization, cur);
        }
    }

    public void deleteClusterByUDomainNameIdx(CFSecurityAuthorization Authorization, String argFullDomainName) {
        CFSecurityClusterByUDomainNameIdxKey key = this.schema.getFactoryCluster().newUDomainNameIdxKey();
        key.setRequiredFullDomainName(argFullDomainName);
        this.deleteClusterByUDomainNameIdx(Authorization, key);
    }

    public void deleteClusterByUDomainNameIdx(CFSecurityAuthorization Authorization, CFSecurityClusterByUDomainNameIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityClusterBuff> matchSet = new LinkedList<CFSecurityClusterBuff>();
        for (CFSecurityClusterBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityClusterBuff cur : matchSet) {
            cur = this.schema.getTableCluster().readDerivedByIdIdx(Authorization, cur.getRequiredId());
            this.deleteCluster(Authorization, cur);
        }
    }

    public void deleteClusterByUDescrIdx(CFSecurityAuthorization Authorization, String argDescription) {
        CFSecurityClusterByUDescrIdxKey key = this.schema.getFactoryCluster().newUDescrIdxKey();
        key.setRequiredDescription(argDescription);
        this.deleteClusterByUDescrIdx(Authorization, key);
    }

    public void deleteClusterByUDescrIdx(CFSecurityAuthorization Authorization, CFSecurityClusterByUDescrIdxKey argKey) {
        boolean anyNotNull = false;
        anyNotNull = true;
        if (!anyNotNull) {
            return;
        }
        LinkedList<CFSecurityClusterBuff> matchSet = new LinkedList<CFSecurityClusterBuff>();
        for (CFSecurityClusterBuff cur : this.dictByPKey.values()) {
            if (!argKey.equals((Object)cur)) continue;
            matchSet.add(cur);
        }
        for (CFSecurityClusterBuff cur : matchSet) {
            cur = this.schema.getTableCluster().readDerivedByIdIdx(Authorization, cur.getRequiredId());
            this.deleteCluster(Authorization, cur);
        }
    }

    public CFSecurityCursor openClusterCursorAll(CFSecurityAuthorization Authorization) {
        CFBamRamClusterCursor cursor = new CFBamRamClusterCursor(Authorization, (ICFSecuritySchema)this.schema, this.dictByPKey.values());
        return cursor;
    }

    public void closeClusterCursor(CFSecurityCursor Cursor) {
    }

    public CFSecurityClusterBuff nextClusterCursor(CFSecurityCursor Cursor) {
        CFBamRamClusterCursor cursor = (CFBamRamClusterCursor)Cursor;
        CFSecurityClusterBuff rec = cursor.getCursor().next();
        cursor.setRowIdx(cursor.getRowIdx() + 1);
        return rec;
    }

    public CFSecurityClusterBuff prevClusterCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = Cursor.getRowIdx() > 1 ? Cursor.getRowIdx() - 1 : 1;
        CFSecurityClusterBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextClusterCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityClusterBuff firstClusterCursor(CFSecurityCursor Cursor) {
        int targetRowIdx = 1;
        CFSecurityClusterBuff rec = null;
        Cursor.reset();
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextClusterCursor(Cursor);
        }
        return rec;
    }

    public CFSecurityClusterBuff lastClusterCursor(CFSecurityCursor Cursor) {
        throw CFLib.getDefaultExceptionFactory().newNotImplementedYetException(this.getClass(), "lastClusterCursor");
    }

    public CFSecurityClusterBuff nthClusterCursor(CFSecurityCursor Cursor, int Idx) {
        int targetRowIdx = Idx;
        CFSecurityClusterBuff rec = null;
        if (Cursor.getRowIdx() >= targetRowIdx) {
            Cursor.reset();
        }
        while (Cursor.getRowIdx() < targetRowIdx) {
            rec = this.nextClusterCursor(Cursor);
        }
        return rec;
    }

    public void releasePreparedStatements() {
    }
}

