/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import org.apache.commons.codec.binary.Base64;

public class CFTipServerInfo {
    public static final int CLUSTER_L_URL = 192;
    public static final int CLUSTER_L_DESCR = 128;
    public static final int SCHEMA_L_NAME = 32;
    public static final int SCHEMA_L_DESCR = 1023;
    public static final int PUBLIC_L_KEY = 8000;
    private String clusterURL = null;
    private String clusterDescr = null;
    private String schemaName = null;
    private String schemaDescr = null;
    private AltSchema[] altSchemas = new AltSchema[0];
    private String serverLoginKey = null;
    private PublicKey serverPublicKey = null;
    private PrivateKey serverPrivateKey = null;

    public String getClusterURL() {
        return this.clusterURL;
    }

    public void setClusterURL(String value) {
        String S_ProcName = "setClusterURL";
        if (value == null || value.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setClusterURL", 1, "value");
        }
        if (value.length() > 192) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "setClusterURL", 1, "value.length()", value.length(), 192);
        }
        this.clusterURL = value;
    }

    public String getClusterDescr() {
        return this.clusterDescr;
    }

    public void setClusterDescr(String value) {
        String S_ProcName = "setClusterDescr";
        if (value == null || value.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setClusterDescr", 1, "value");
        }
        if (value.length() > 128) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "setClusterDescr", 1, "value.length()", value.length(), 128);
        }
        this.clusterDescr = value;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String value) {
        String S_ProcName = "setSchemaName";
        if (value == null || value.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setSchemaName", 1, "value");
        }
        if (value.length() > 32) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "setSchemaName", 1, "value.length()", value.length(), 32);
        }
        this.schemaName = value;
    }

    public String getSchemaDescr() {
        return this.schemaDescr;
    }

    public void setSchemaDescr(String value) {
        String S_ProcName = "setSchemaDescr";
        if (value == null || value.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setSchemaDescr", 1, "value");
        }
        if (value.length() > 1023) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "setSchemaDescr", 1, "value.length()", value.length(), 1023);
        }
        this.schemaDescr = value;
    }

    public AltSchema[] getAltSchemas() {
        return this.altSchemas;
    }

    public void addAltSchema(String schemaName, String schemaDescr) {
        AltSchema altSchema = new AltSchema();
        altSchema.setSchemaName(schemaName);
        altSchema.setSchemaDescr(schemaDescr);
        AltSchema[] oldAltSchemas = this.altSchemas;
        AltSchema[] newAltSchemas = new AltSchema[oldAltSchemas.length + 1];
        for (int idx = 0; idx < oldAltSchemas.length; ++idx) {
            newAltSchemas[idx] = oldAltSchemas[idx];
        }
        newAltSchemas[oldAltSchemas.length] = altSchema;
        this.altSchemas = newAltSchemas;
    }

    public String getServerLoginKey() {
        return this.serverLoginKey;
    }

    public void setServerLoginKey(String serverEncodedKey) {
        String S_ProcName = "setServerLoginKey";
        try {
            byte[] decoded = Base64.decodeBase64((byte[])serverEncodedKey.getBytes());
            this.setEncodedServerPublicKey(decoded);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw CFLib.getDefaultExceptionFactory().newRuntimeException(this.getClass(), "setServerLoginKey", "Caught " + e.getClass().getName() + " -- " + e.getMessage(), e);
        }
        this.serverLoginKey = serverEncodedKey;
    }

    public PublicKey getServerPublicKey() {
        return this.serverPublicKey;
    }

    public void setEncodedServerPublicKey(byte[] encoded) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.serverPublicKey = kf.generatePublic(x509KeySpec);
    }

    public byte[] encryptWithServerPublicKey(byte[] value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        String S_ProcName = "encryptWithServerPublicKey";
        if (this.serverPublicKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "encryptWithServerPublicKey", "Server public key must be set first");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "encryptWithServerPublicKey", 0, "cipher");
        }
        cipher.init(1, this.serverPublicKey);
        byte[] encrypted = cipher.doFinal(value);
        return encrypted;
    }

    public byte[] decryptWithServerPublicKey(byte[] value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String S_ProcName = "decryptWithServerPublicKey";
        if (this.serverPublicKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "decryptWithServerPublicKey", "Server key must be initialized by setEncodedServerPublicKey()");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "decryptWithServerPublicKey", 0, "cipher");
        }
        cipher.init(2, this.serverPublicKey);
        byte[] decrypted = cipher.doFinal(value);
        return decrypted;
    }

    public void setServerKeys(PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException {
        String encoded;
        String S_ProcName = "setServerKeys";
        if (publicKey == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setServerKeys", 1, "publicKey");
        }
        if (privateKey == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setServerKeys", 1, "privateKey");
        }
        this.serverPrivateKey = privateKey;
        this.serverPublicKey = publicKey;
        byte[] encodedPKey = this.getEncodedServerPublicKey();
        this.serverLoginKey = encoded = new String(Base64.encodeBase64((byte[])encodedPKey));
    }

    public void initServerKeys() throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException {
        String encoded;
        if (this.serverPrivateKey == null) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048, new SecureRandom());
            KeyPair serverKeyPair = kpg.generateKeyPair();
            this.serverPrivateKey = serverKeyPair.getPrivate();
            this.serverPublicKey = serverKeyPair.getPublic();
        }
        byte[] encodedPKey = this.getEncodedServerPublicKey();
        this.serverLoginKey = encoded = new String(Base64.encodeBase64((byte[])encodedPKey));
    }

    public byte[] getEncodedServerPublicKey() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        String S_ProcName = "getEncodedServerPublicKey";
        if (this.serverPublicKey == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "getEncodedServerPublicKey", 0, "serverPublicKey");
        }
        byte[] encoded = this.serverPublicKey.getEncoded();
        return encoded;
    }

    public byte[] decryptWithServerPrivateKey(byte[] value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String S_ProcName = "decryptWithServerPrivateKey";
        if (this.serverPrivateKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "decryptWithServerPrivateKey", "Server keys must be initialized by initServerKeys() or setServerKeys()");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "decryptWithServerPrivateKey", 0, "cipher");
        }
        cipher.init(2, this.serverPrivateKey);
        byte[] decrypted = cipher.doFinal(value);
        return decrypted;
    }

    public class AltSchema {
        private String schemaName = "callSetSchemaName()";
        private String schemaDescr = "callSetSchemaDescr()";

        public AltSchema() {
        }

        public AltSchema(String parmName, String parmDescr) {
            this.schemaName = parmName;
            this.schemaDescr = parmDescr;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        void setSchemaName(String value) {
            String S_ProcName = "setSchemaName";
            if (value == null || value.length() <= 0) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setSchemaName", 1, "value");
            }
            if (value.length() > 32) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "setSchemaName", 1, "value.length()", value.length(), 32);
            }
            this.schemaName = value;
        }

        public String getSchemaDescr() {
            return this.schemaDescr;
        }

        void setSchemaDescr(String value) {
            String S_ProcName = "setSchemaDescr";
            if (value == null || value.length() <= 0) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setSchemaDescr", 1, "value");
            }
            if (value.length() > 1023) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.getClass(), "setSchemaDescr", 1, "value.length()", value.length(), 1023);
            }
            this.schemaDescr = value;
        }
    }
}

