/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreElementHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreSaxParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlUtil;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip.CFTipServerInfo;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip.ICFTipRequestHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip.ICFTipThrowableFormatter;
import org.apache.commons.codec.binary.Base64;
import org.apache.xerces.xni.grammars.Grammar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CFTipEnvelopeHandler
extends CFLibXmlCoreSaxParser
implements ContentHandler {
    public static final String SCHEMA_XMLNS = "uri://net.sourceforge.msscodefactory/cftipenvelope";
    public static final String SCHEMA_URI = "../bin/xsd/cftip-envelope.xsd";
    public static final String SCHEMA_ROOT_URI = "/xsd/cftip-envelope.xsd";
    protected static Grammar myGrammar = null;
    private ICFTipRequestHandler requestHandler = null;
    private ICFTipThrowableFormatter throwableFormatter = null;
    private String response = "";
    private CFTipServerInfo serverInfo = null;
    private SecretKey sessionKey = null;
    private PublicKey clientPublicKey = null;
    private CFTipQueryServerInfoHandler queryServerInfoHandler = null;
    private CFTipAppRequestHandler appRequestHandler = null;
    private CFTipLoginRequestHandler loginRequestHandler = null;
    private CFTipSaxEnvelopeDocHandler saxEnvelopeDocHandler = null;
    private CFTipSaxEnvelopeRootHandler saxEnvelopeRootHandler = null;

    public CFTipEnvelopeHandler() {
        this.setRootElementHandler(this.getSaxRqstRootHandler());
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = CFTipEnvelopeHandler.addToGrammarPool(SCHEMA_URI, input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = CFTipEnvelopeHandler.addToGrammarPool(SCHEMA_ROOT_URI, input);
                }
            }
        }
        this.initParser();
    }

    public CFTipEnvelopeHandler(ICFLibMessageLog logger) {
        super(logger);
        this.setRootElementHandler(this.getSaxRqstRootHandler());
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = CFTipEnvelopeHandler.addToGrammarPool(SCHEMA_URI, input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = CFTipEnvelopeHandler.addToGrammarPool(SCHEMA_ROOT_URI, input);
                }
            }
        }
        this.initParser();
    }

    public ICFTipRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(ICFTipRequestHandler value) {
        String S_ProcName = "setRequestHandler";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setRequestHandler", 1, "value");
        }
        this.requestHandler = value;
    }

    public ICFTipThrowableFormatter getThrowableFormatter() {
        return this.throwableFormatter;
    }

    public void setThrowableFormatter(ICFTipThrowableFormatter value) {
        String S_ProcName = "setThrowableFormatter";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setThrowableFormatter", 1, "value");
        }
        this.throwableFormatter = value;
    }

    public String getResponse() {
        return this.response;
    }

    void setResponse(String str) {
        this.response = str == null ? "" : str;
    }

    public CFTipServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(CFTipServerInfo value) {
        String S_ProcName = "setServerInfo";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setServerInfo", 1, "value");
        }
        this.serverInfo = value;
    }

    public void setEncodedSessionKey(byte[] encoded) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        this.sessionKey = new SecretKeySpec(encoded, "AES");
    }

    public byte[] encryptWithSessionKey(IvParameterSpec ivspec, byte[] value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        String S_ProcName = "encryptWithClientPrivateKey";
        if (this.sessionKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "encryptWithClientPrivateKey", "Session key must be initialized by setEncodedSessionKey()");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "encryptWithClientPrivateKey", 0, "cipher");
        }
        cipher.init(1, (Key)this.sessionKey, ivspec);
        byte[] encrypted = cipher.doFinal(value);
        return encrypted;
    }

    public byte[] decryptWithSessionKey(IvParameterSpec ivspec, byte[] value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        String S_ProcName = "decryptWithClientPrivateKey";
        if (this.sessionKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "decryptWithClientPrivateKey", "Session key must be initialized by setEncodedSessionKey()");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "decryptWithClientPrivateKey", 0, "cipher");
        }
        cipher.init(2, (Key)this.sessionKey, ivspec);
        byte[] decrypted = cipher.doFinal(value);
        return decrypted;
    }

    public void setEncodedClientPublicKey(byte[] encoded) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.clientPublicKey = kf.generatePublic(x509KeySpec);
    }

    public byte[] decryptWithClientPublicKey(byte[] value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String S_ProcName = "decryptWithClientPublicKey";
        if (this.clientPublicKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "decryptWithClientPublicKey", "Client public key must be set by calling setEncodedClientPublicKey() first");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "decryptWithClientPublicKey", 0, "cipher");
        }
        cipher.init(2, this.clientPublicKey);
        byte[] decrypted = cipher.doFinal(value);
        return decrypted;
    }

    protected CFTipQueryServerInfoHandler getQueryServerInfoHandler() {
        if (this.queryServerInfoHandler == null) {
            this.queryServerInfoHandler = new CFTipQueryServerInfoHandler(this);
        }
        return this.queryServerInfoHandler;
    }

    protected CFTipAppRequestHandler getAppRequestHandler() {
        if (this.appRequestHandler == null) {
            this.appRequestHandler = new CFTipAppRequestHandler(this);
        }
        return this.appRequestHandler;
    }

    protected CFTipLoginRequestHandler getLoginRequestHandler() {
        if (this.loginRequestHandler == null) {
            this.loginRequestHandler = new CFTipLoginRequestHandler(this);
        }
        return this.loginRequestHandler;
    }

    protected CFTipSaxEnvelopeDocHandler getSaxEnvelopeDocHandler() {
        if (this.saxEnvelopeDocHandler == null) {
            this.saxEnvelopeDocHandler = new CFTipSaxEnvelopeDocHandler(this);
            this.saxEnvelopeDocHandler.addElementHandler("AppRequest", this.getAppRequestHandler());
            this.saxEnvelopeDocHandler.addElementHandler("LoginRequest", this.getLoginRequestHandler());
            this.saxEnvelopeDocHandler.addElementHandler("QueryServerInfo", this.getQueryServerInfoHandler());
        }
        return this.saxEnvelopeDocHandler;
    }

    protected CFTipSaxEnvelopeRootHandler getSaxRqstRootHandler() {
        if (this.saxEnvelopeRootHandler == null) {
            this.saxEnvelopeRootHandler = new CFTipSaxEnvelopeRootHandler(this);
            this.saxEnvelopeRootHandler.addElementHandler("CFTIPEnvelope", this.getSaxEnvelopeDocHandler());
        }
        return this.saxEnvelopeRootHandler;
    }

    @Override
    public void parseStringContents(String str) {
        this.setResponse("");
        try {
            super.parseStringContents(str);
        }
        catch (RuntimeException e) {
            ICFLibMessageLog log = this.getLog();
            if (log != null) {
                PrintStream printStream = log.getPrintStream();
                log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                e.printStackTrace(printStream);
            } else {
                e.printStackTrace();
            }
            this.setResponse("");
        }
        catch (Error e) {
            ICFLibMessageLog log = this.getLog();
            if (log != null) {
                PrintStream printStream = log.getPrintStream();
                log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                e.printStackTrace(printStream);
            } else {
                e.printStackTrace();
            }
            this.setResponse("");
        }
    }

    @Override
    public void parse(String url) {
        this.setResponse("");
        try {
            super.parse(url);
        }
        catch (RuntimeException e) {
            ICFLibMessageLog log = this.getLog();
            if (log != null) {
                PrintStream printStream = log.getPrintStream();
                log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                e.printStackTrace(printStream);
            } else {
                e.printStackTrace();
            }
            this.setResponse("");
        }
        catch (Error e) {
            ICFLibMessageLog log = this.getLog();
            if (log != null) {
                PrintStream printStream = log.getPrintStream();
                log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                e.printStackTrace(printStream);
            } else {
                e.printStackTrace();
            }
            this.setResponse("");
        }
    }

    public void parseFile(String url) {
        this.setResponse("");
        try {
            super.parse(url);
        }
        catch (RuntimeException e) {
            ICFLibMessageLog log = this.getLog();
            if (log != null) {
                PrintStream printStream = log.getPrintStream();
                log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                e.printStackTrace(printStream);
            } else {
                e.printStackTrace();
            }
            this.setResponse("");
        }
        catch (Error e) {
            ICFLibMessageLog log = this.getLog();
            if (log != null) {
                PrintStream printStream = log.getPrintStream();
                log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                e.printStackTrace(printStream);
            } else {
                e.printStackTrace();
            }
            this.setResponse("");
        }
    }

    public class CFTipAppRequestHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipAppRequestHandler(CFTipEnvelopeHandler envelopeHandler) {
            super(envelopeHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String S_ProcName = "startElement";
            String S_LocalName = "LocalName";
            CFTipEnvelopeHandler envelopeHandler = (CFTipEnvelopeHandler)this.getParser();
            if (envelopeHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser()");
            }
            ICFTipRequestHandler rqstHandler = envelopeHandler.getRequestHandler();
            if (rqstHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser().getRequestHandler()");
            }
            IvParameterSpec ivspec = null;
            try {
                String rspn;
                String attrId = null;
                String attrMessageIV = null;
                String attrPayload = null;
                assert (qName.equals("AppRequest"));
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName.equals("Id")) {
                        if (attrId != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrId = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("MessageIV")) {
                        if (attrMessageIV != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrMessageIV = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("Payload")) {
                        if (attrPayload != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrPayload = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("schemaLocation")) continue;
                    throw CFLib.getDefaultExceptionFactory().newUnrecognizedAttributeException(this.getClass(), "startElement", this.getParser().getLocationInfo(), attrLocalName);
                }
                if (attrMessageIV == null || attrMessageIV.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "MessageIV");
                }
                if (attrPayload == null || attrPayload.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "Payload");
                }
                byte[] iv = Base64.decodeBase64((String)attrMessageIV);
                ivspec = new IvParameterSpec(iv);
                byte[] payload = Base64.decodeBase64((String)attrPayload);
                byte[] decrypted = envelopeHandler.decryptWithSessionKey(ivspec, payload);
                try {
                    String rqst = new String(decrypted);
                    rqstHandler.parseStringContents(rqst);
                    rspn = rqstHandler.getResponse();
                    if (rspn == null) {
                        rspn = "";
                    }
                }
                catch (Throwable t) {
                    rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(t) : "";
                }
                byte[] bytes = rspn.getBytes();
                byte[] encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (RuntimeException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = ivspec != null ? envelopeHandler.encryptWithSessionKey(ivspec, bytes) : new byte[]{};
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (Error e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (InvalidKeyException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught InvalidKeyException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (NoSuchAlgorithmException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught NoSuchAlgorithmException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (NoSuchPaddingException e) {
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught NoSuchPaddingException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                envelopeHandler.setResponse("");
            }
            catch (IllegalBlockSizeException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught IllegalBlockSizeException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (BadPaddingException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught BadPaddingException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (InvalidAlgorithmParameterException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught InvalidAlgorithmParameterException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class CFTipLoginRequestHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipLoginRequestHandler(CFTipEnvelopeHandler envelopeHandler) {
            super(envelopeHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String S_ProcName = "startElement";
            String S_LocalName = "LocalName";
            CFTipEnvelopeHandler envelopeHandler = (CFTipEnvelopeHandler)this.getParser();
            if (envelopeHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser()");
            }
            ICFTipRequestHandler rqstHandler = envelopeHandler.getRequestHandler();
            if (rqstHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser().getRequestHandler()");
            }
            IvParameterSpec ivspec = null;
            try {
                String rspn;
                String attrId = null;
                String attrMessageIV = null;
                String attrAES256Key = null;
                String attrPayload = null;
                assert (qName.equals("LoginRequest"));
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName.equals("Id")) {
                        if (attrId != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrId = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("MessageIV")) {
                        if (attrMessageIV != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrMessageIV = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("AES256Key")) {
                        if (attrAES256Key != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrAES256Key = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("Payload")) {
                        if (attrPayload != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrPayload = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("schemaLocation")) continue;
                    throw CFLib.getDefaultExceptionFactory().newUnrecognizedAttributeException(this.getClass(), "startElement", this.getParser().getLocationInfo(), attrLocalName);
                }
                if (attrMessageIV == null || attrMessageIV.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "MessageIV");
                }
                if (attrAES256Key == null || attrAES256Key.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "AES256Key");
                }
                if (attrPayload == null || attrPayload.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "Payload");
                }
                byte[] iv = Base64.decodeBase64((String)attrMessageIV);
                ivspec = new IvParameterSpec(iv);
                byte[] base64AES256Key = Base64.decodeBase64((String)attrAES256Key);
                byte[] decryptedAES256Key = CFTipEnvelopeHandler.this.serverInfo.decryptWithServerPrivateKey(base64AES256Key);
                envelopeHandler.setEncodedSessionKey(decryptedAES256Key);
                byte[] payload = Base64.decodeBase64((String)attrPayload);
                byte[] decrypted = envelopeHandler.decryptWithSessionKey(ivspec, payload);
                try {
                    String rqst = new String(decrypted);
                    rqstHandler.parseStringContents(rqst);
                    rspn = rqstHandler.getResponse();
                    if (rspn == null) {
                        rspn = "";
                    }
                }
                catch (Throwable t) {
                    rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(t) : "";
                }
                byte[] bytes = rspn.getBytes();
                byte[] encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (RuntimeException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (Error e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (InvalidKeyException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught InvalidKeyException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (NoSuchAlgorithmException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught NoSuchAlgorithmException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (NoSuchPaddingException e) {
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught NoSuchPaddingException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                envelopeHandler.setResponse("");
            }
            catch (IllegalBlockSizeException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught IllegalBlockSizeException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (BadPaddingException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught BadPaddingException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (InvalidAlgorithmParameterException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught InvalidAlgorithmParameterException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
            catch (InvalidKeySpecException e) {
                byte[] encrypted;
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught InvalidKeySpecException -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                String rspn = CFTipEnvelopeHandler.this.throwableFormatter != null ? CFTipEnvelopeHandler.this.throwableFormatter.formatResponseThrowable(e) : "";
                byte[] bytes = rspn.getBytes();
                try {
                    encrypted = envelopeHandler.encryptWithSessionKey(ivspec, bytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException x) {
                    encrypted = new byte[]{};
                }
                String rspnString = new String(Base64.encodeBase64((byte[])encrypted));
                envelopeHandler.setResponse(rspnString);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class CFTipQueryServerInfoHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipQueryServerInfoHandler(CFTipEnvelopeHandler envelopeHandler) {
            super(envelopeHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String S_ProcName = "startElement";
            String S_LocalName = "LocalName";
            CFTipEnvelopeHandler envelopeHandler = (CFTipEnvelopeHandler)this.getParser();
            if (envelopeHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser()");
            }
            try {
                String attrId = null;
                assert (qName.equals("QueryServerInfo"));
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName.equals("Id")) {
                        if (attrId != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrId = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("schemaLocation")) continue;
                    throw CFLib.getDefaultExceptionFactory().newUnrecognizedAttributeException(this.getClass(), "startElement", this.getParser().getLocationInfo(), attrLocalName);
                }
                CFTipServerInfo serverInfo = envelopeHandler.getServerInfo();
                String clusterURL = serverInfo.getClusterURL();
                String clusterDescr = serverInfo.getClusterDescr();
                String schemaName = serverInfo.getSchemaName();
                String schemaDescr = serverInfo.getSchemaDescr();
                CFTipServerInfo.AltSchema[] altSchemas = serverInfo.getAltSchemas();
                String serverLoginKey = serverInfo.getServerLoginKey();
                int numSchemas = altSchemas.length;
                StringBuffer buff = new StringBuffer();
                buff.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<CFTipServerInfo\n\t\txmlns=\"uri://net.sourceforge.msscodefactory/CFTipServerInfo\"\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n\t\txsi:schemaLocation=\"uri://net.sourceforge.msscodefactory/CFTipServerInfo file:../bin/xsd/cftip-serverinfo.xsd\"\t\tClusterURL=\"" + CFLibXmlUtil.formatXmlString(clusterURL) + "\"\n\t\tClusterDescr=\"" + CFLibXmlUtil.formatXmlString(clusterDescr) + "\"\n\t\tSchemaName=\"" + CFLibXmlUtil.formatXmlString(schemaName) + "\"\n\t\tSchemaDescr=\"" + CFLibXmlUtil.formatXmlString(schemaDescr) + "\"\n\t\tServerLoginKey=\"" + CFLibXmlUtil.formatXmlString(serverLoginKey) + "\" >\n");
                for (int idx = 0; idx < numSchemas; ++idx) {
                    CFTipServerInfo.AltSchema altSchema = altSchemas[idx];
                    if (altSchema == null) continue;
                    String altSchemaName = altSchema.getSchemaName();
                    String altSchemaDescr = altSchema.getSchemaDescr();
                    buff.append("\t<AltSchema SchemaName=\"" + CFLibXmlUtil.formatXmlString(altSchemaName) + "\" SchemaDescr=\"" + CFLibXmlUtil.formatXmlString(altSchemaDescr) + "\" />\n");
                }
                buff.append("</CFTipServerInfo>\n");
                envelopeHandler.setResponse(buff.toString());
            }
            catch (RuntimeException e) {
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                envelopeHandler.setResponse("");
            }
            catch (Error e) {
                ICFLibMessageLog log = this.getLog();
                if (log != null) {
                    PrintStream printStream = log.getPrintStream();
                    log.message("Caught " + e.getClass().getName() + " -- " + e.getMessage());
                    e.printStackTrace(printStream);
                } else {
                    e.printStackTrace();
                }
                envelopeHandler.setResponse("");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class CFTipSaxEnvelopeDocHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipSaxEnvelopeDocHandler(CFTipEnvelopeHandler xmsgRqstHandler) {
            super(xmsgRqstHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class CFTipSaxEnvelopeRootHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipSaxEnvelopeRootHandler(CFTipEnvelopeHandler xmsgRqstHandler) {
            super(xmsgRqstHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

