/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibRuntimeException;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreElementHandler;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLibXmlCoreSaxParser;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.ICFLibMessageLog;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip.CFTipServerInfo;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.Tip.ICFTipResponseHandler;
import org.apache.commons.codec.binary.Base64;
import org.apache.xerces.xni.grammars.Grammar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CFTipClientHandler
extends CFLibXmlCoreSaxParser
implements ContentHandler {
    public static final String SCHEMA_XMLNS = "uri://net.sourceforge.msscodefactory/CFTipServerInfo";
    public static final String SCHEMA_URI = "../bin/xsd/cftip-serverinfo.xsd";
    public static final String SCHEMA_ROOT_URI = "/xsd/cftip-serverinfo.xsd";
    protected static Grammar myGrammar = null;
    private ICFTipResponseHandler responseHandler = null;
    private CFTipServerInfo serverInfo = null;
    private SecretKey sessionKey = null;
    private String deviceName = null;
    private PublicKey devicePublicKey = null;
    private PrivateKey devicePrivateKey = null;
    private CFTipSaxServerInfoRootHandler saxServerInfoRootHandler = null;
    private CFTipSaxServerInfoDocHandler saxServerInfoDocHandler = null;
    private CFTipAltSchemaEltHandler altSchemaEltHandler = null;

    public CFTipClientHandler() {
        this.setRootElementHandler(this.getSaxRqstRootHandler());
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = CFTipClientHandler.addToGrammarPool(SCHEMA_URI, input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = CFTipClientHandler.addToGrammarPool(SCHEMA_ROOT_URI, input);
                }
            }
        }
        this.initParser();
    }

    public CFTipClientHandler(ICFLibMessageLog logger) {
        super(logger);
        this.setRootElementHandler(this.getSaxRqstRootHandler());
        if (myGrammar == null) {
            File file = new File(SCHEMA_URI);
            if (file.exists()) {
                FileInputStream input;
                try {
                    input = new FileInputStream(file);
                }
                catch (Exception e) {
                    input = null;
                }
                if (input != null) {
                    myGrammar = CFTipClientHandler.addToGrammarPool(SCHEMA_URI, input);
                }
            } else {
                InputStream input = this.getClass().getResourceAsStream(SCHEMA_ROOT_URI);
                if (input != null) {
                    myGrammar = CFTipClientHandler.addToGrammarPool(SCHEMA_ROOT_URI, input);
                }
            }
        }
        this.initParser();
    }

    public ICFTipResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ICFTipResponseHandler value) {
        String S_ProcName = "setResponseHandler";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "setResponseHandler", 1, "value");
        }
        this.responseHandler = value;
    }

    public CFTipServerInfo getServerInfo() {
        return this.serverInfo;
    }

    void setServerInfo(CFTipServerInfo value) {
        this.serverInfo = value;
    }

    public void initSessionKey() throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(256, new SecureRandom());
        this.sessionKey = kg.generateKey();
    }

    public byte[] getEncodedSessionKey() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        String S_ProcName = "getEncodedSessionKey";
        if (this.sessionKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "getEncodedSessionKey", "Session key must be initialized by initSessionKey()");
        }
        byte[] encoded = this.sessionKey.getEncoded();
        return encoded;
    }

    public void setEncodedSessionKey(byte[] encoded) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        this.sessionKey = new SecretKeySpec(encoded, "AES");
    }

    public byte[] encryptWithSessionKey(IvParameterSpec ivspec, byte[] value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        String S_ProcName = "encryptWithClientPrivateKey";
        if (this.sessionKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "encryptWithClientPrivateKey", "Session key must be initialized by initSessionKey()");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "encryptWithClientPrivateKey", 0, "cipher");
        }
        cipher.init(1, (Key)this.sessionKey, ivspec);
        byte[] encrypted = cipher.doFinal(value);
        return encrypted;
    }

    public byte[] decryptWithSessionKey(IvParameterSpec ivspec, byte[] value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        String S_ProcName = "decryptWithClientPrivateKey";
        if (this.sessionKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "decryptWithClientPrivateKey", "Session key must be initialized by initSessionKey()");
        }
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "decryptWithClientPrivateKey", 0, "cipher");
        }
        cipher.init(2, (Key)this.sessionKey, ivspec);
        byte[] decrypted = cipher.doFinal(value);
        return decrypted;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String value) {
        this.deviceName = value;
    }

    public PrivateKey getDevicePrivateKey() {
        return this.devicePrivateKey;
    }

    public void setDevicePrivateKey(PrivateKey value) {
        this.devicePrivateKey = value;
    }

    public PublicKey getDevicePublicKey() {
        return this.devicePublicKey;
    }

    public void setDevicePublicKey(PublicKey value) {
        this.devicePublicKey = value;
    }

    public byte[] getEncodedDevicePublicKey() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        String S_ProcName = "getEncodedDevicePublicKey";
        if (this.devicePublicKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "getEncodedDevicePublicKey", "Device keys must be initialized by createDeviceKeys() or loadDeviceKeys()");
        }
        byte[] encoded = this.devicePublicKey.getEncoded();
        return encoded;
    }

    public byte[] encryptWithDevicePrivateKey(byte[] value) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        String S_ProcName = "encryptWithDevicePrivateKey";
        if (this.devicePrivateKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "encryptWithDevicePrivateKey", "Device keys must be initialized by createDeviceKeys() or loadDeviceKeys()");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "encryptWithDevicePrivateKey", 0, "cipher");
        }
        cipher.init(1, this.devicePrivateKey);
        byte[] encrypted = cipher.doFinal(value);
        return encrypted;
    }

    public String sendReceive(String value) {
        String S_ProcName = "sendReceive";
        throw CFLib.getDefaultExceptionFactory().newMustOverrideException(this.getClass(), "sendReceive");
    }

    public CFTipServerInfo requestServerInfo() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        String S_ProcName = "requestServerInfo";
        String msg = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<CFTIPEnvelope\n\t\txmlns=\"uri://net.sourceforge.msscodefactory/cftipenvelope\"\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n\t\txsi:schemaLocation=\"uri://net.sourceforge.msscodefactory/cftipenvelope file:../bin/xsd/cftip-envelope.xsd\" >\n\t<QueryServerInfo />\n</CFTIPEnvelope>\n";
        String response = this.sendReceive("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<CFTIPEnvelope\n\t\txmlns=\"uri://net.sourceforge.msscodefactory/cftipenvelope\"\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n\t\txsi:schemaLocation=\"uri://net.sourceforge.msscodefactory/cftipenvelope file:../bin/xsd/cftip-envelope.xsd\" >\n\t<QueryServerInfo />\n</CFTIPEnvelope>\n");
        if (response == null || response.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "requestServerInfo", 0, "response");
        }
        this.parseStringContents(response);
        if (this.serverInfo == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "requestServerInfo", 0, "serverInfo");
        }
        String encodedServerKey = this.serverInfo.getServerLoginKey();
        byte[] decodedServerKey = Base64.decodeBase64((String)encodedServerKey);
        this.serverInfo.setEncodedServerPublicKey(decodedServerKey);
        return this.serverInfo;
    }

    public void issueLoginRequest(String body) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        String S_ProcName = "issueLoginRequest";
        if (this.responseHandler == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "issueLoginRequest", "Response handler must be set first by setResponseHandler()");
        }
        if (this.serverInfo == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "issueLoginRequest", "Server info must be queried first by requestServerInfo()");
        }
        if (body == null || body.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "issueLoginRequest", 1, "body");
        }
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        byte[] base64IV = Base64.encodeBase64((byte[])iv);
        String stringIV = new String(base64IV);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        byte[] encodedSessionKey = this.getEncodedSessionKey();
        byte[] encryptedSessionKey = this.serverInfo.encryptWithServerPublicKey(encodedSessionKey);
        byte[] base64SessionKey = Base64.encodeBase64((byte[])encryptedSessionKey);
        String stringSessionKey = new String(base64SessionKey);
        byte[] bodyBytes = body.getBytes();
        byte[] serverEncrypted = this.encryptWithSessionKey(ivspec, bodyBytes);
        byte[] base64Encrypted = Base64.encodeBase64((byte[])serverEncrypted);
        String encoded = new String(base64Encrypted);
        String msg = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<CFTIPEnvelope\n\t\txmlns=\"uri://net.sourceforge.msscodefactory/cftipenvelope\"\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n\t\txsi:schemaLocation=\"uri://net.sourceforge.msscodefactory/cftipenvelope file:../bin/xsd/cftip-envelope.xsd\" >\n\t<LoginRequest MessageIV=\"" + stringIV + "\" AES256Key=\"" + stringSessionKey + "\" Payload=\"" + encoded + "\" />\n</CFTIPEnvelope>\n";
        String response = this.sendReceive(msg);
        if (response == null || response.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "issueLoginRequest", 0, "response");
        }
        byte[] responseBytes = Base64.decodeBase64((String)response);
        byte[] decrypted = this.decryptWithSessionKey(ivspec, responseBytes);
        String decryptedResponse = new String(decrypted);
        this.responseHandler.parseStringContents(decryptedResponse);
    }

    public void issueAppRequest(String body) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        String S_ProcName = "issueAppRequest";
        if (this.responseHandler == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "issueAppRequest", "Response handler must be set first by setResponseHandler()");
        }
        if (this.serverInfo == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "issueAppRequest", "Server info must be queried first by requestServerInfo()");
        }
        if (this.sessionKey == null) {
            throw CFLib.getDefaultExceptionFactory().newUsageException(this.getClass(), "issueAppRequest", "Session key must be set first by logging in");
        }
        if (body == null || body.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "issueAppRequest", 1, "body");
        }
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        byte[] base64IV = Base64.encodeBase64((byte[])iv);
        String stringIV = new String(base64IV);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        byte[] bodyBytes = body.getBytes();
        byte[] serverEncrypted = this.encryptWithSessionKey(ivspec, bodyBytes);
        byte[] base64Encrypted = Base64.encodeBase64((byte[])serverEncrypted);
        String encoded = new String(base64Encrypted);
        String msg = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<CFTIPEnvelope\n\t\txmlns=\"uri://net.sourceforge.msscodefactory/cftipenvelope\"\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n\t\txsi:schemaLocation=\"uri://net.sourceforge.msscodefactory/cftipenvelope file:../bin/xsd/cftip-envelope.xsd\" >\n\t<AppRequest MessageIV=\"" + stringIV + "\" Payload=\"" + encoded + "\" />\n</CFTIPEnvelope>\n";
        String response = this.sendReceive(msg);
        if (response == null || response.length() <= 0) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "issueAppRequest", 0, "response");
        }
        byte[] responseBytes = Base64.decodeBase64((String)response);
        byte[] decrypted = this.decryptWithSessionKey(ivspec, responseBytes);
        String decryptedResponse = new String(decrypted);
        this.responseHandler.parseStringContents(decryptedResponse);
    }

    protected CFTipAltSchemaEltHandler getAltSchemaEltHandler() {
        if (this.altSchemaEltHandler == null) {
            this.altSchemaEltHandler = new CFTipAltSchemaEltHandler(this);
        }
        return this.altSchemaEltHandler;
    }

    protected CFTipSaxServerInfoDocHandler getSaxServerInfoDocHandler() {
        if (this.saxServerInfoDocHandler == null) {
            this.saxServerInfoDocHandler = new CFTipSaxServerInfoDocHandler(this);
            this.saxServerInfoDocHandler.addElementHandler("AltSchema", this.getAltSchemaEltHandler());
        }
        return this.saxServerInfoDocHandler;
    }

    protected CFTipSaxServerInfoRootHandler getSaxRqstRootHandler() {
        if (this.saxServerInfoRootHandler == null) {
            this.saxServerInfoRootHandler = new CFTipSaxServerInfoRootHandler(this);
            this.saxServerInfoRootHandler.addElementHandler("CFTipServerInfo", this.getSaxServerInfoDocHandler());
        }
        return this.saxServerInfoRootHandler;
    }

    @Override
    public void parseStringContents(String str) {
        this.setServerInfo(null);
        try {
            super.parseStringContents(str);
        }
        catch (CFLibRuntimeException e) {
            this.setServerInfo(null);
            throw e;
        }
        catch (RuntimeException e) {
            this.setServerInfo(null);
            throw e;
        }
        catch (Exception e) {
            this.setServerInfo(null);
            throw e;
        }
    }

    @Override
    public void parse(String url) {
        this.setServerInfo(null);
        try {
            super.parse(url);
        }
        catch (CFLibRuntimeException e) {
            this.setServerInfo(null);
            throw e;
        }
        catch (RuntimeException e) {
            this.setServerInfo(null);
            throw e;
        }
        catch (Exception e) {
            this.setServerInfo(null);
            throw e;
        }
    }

    public void parseFile(String url) {
        this.setServerInfo(null);
        try {
            super.parse(url);
        }
        catch (CFLibRuntimeException e) {
            this.setServerInfo(null);
            throw e;
        }
        catch (RuntimeException e) {
            this.setServerInfo(null);
            throw e;
        }
        catch (Exception e) {
            this.setServerInfo(null);
            throw e;
        }
    }

    public class CFTipAltSchemaEltHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipAltSchemaEltHandler(CFTipClientHandler clientHandler) {
            super(clientHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String S_ProcName = "startElement";
            String S_LocalName = "LocalName";
            CFTipClientHandler clientHandler = (CFTipClientHandler)this.getParser();
            if (clientHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser()");
            }
            String attrId = null;
            String attrSchemaName = null;
            String attrSchemaDescr = null;
            assert (qName.equals("AltSchema"));
            int numAttrs = attrs.getLength();
            for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                String attrLocalName = attrs.getLocalName(idxAttr);
                if (attrLocalName.equals("Id")) {
                    if (attrId != null) {
                        throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                    }
                    attrId = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("SchemaName")) {
                    if (attrSchemaName != null) {
                        throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                    }
                    attrSchemaName = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("SchemaDescr")) {
                    if (attrSchemaDescr != null) {
                        throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                    }
                    attrSchemaDescr = attrs.getValue(idxAttr);
                    continue;
                }
                if (attrLocalName.equals("schemaLocation")) continue;
                throw CFLib.getDefaultExceptionFactory().newUnrecognizedAttributeException(this.getClass(), "startElement", this.getParser().getLocationInfo(), attrLocalName);
            }
            if (attrSchemaName == null || attrSchemaName.length() <= 0) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "SchemaName");
            }
            if (attrSchemaDescr == null || attrSchemaDescr.length() <= 0) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "SchemaDescr");
            }
            clientHandler.getServerInfo().addAltSchema(attrSchemaName, attrSchemaDescr);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class CFTipSaxServerInfoDocHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipSaxServerInfoDocHandler(CFTipClientHandler clientHandler) {
            super(clientHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String S_ProcName = "startElement";
            String S_LocalName = "LocalName";
            CFTipClientHandler clientHandler = (CFTipClientHandler)this.getParser();
            if (clientHandler == null) {
                throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "getParser()");
            }
            try {
                String attrId = null;
                String attrClusterURL = null;
                String attrClusterDescr = null;
                String attrSchemaName = null;
                String attrSchemaDescr = null;
                String attrServerLoginKey = null;
                assert (qName.equals("CFTipServerInfo"));
                int numAttrs = attrs.getLength();
                for (int idxAttr = 0; idxAttr < numAttrs; ++idxAttr) {
                    String attrLocalName = attrs.getLocalName(idxAttr);
                    if (attrLocalName.equals("Id")) {
                        if (attrId != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrId = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("ClusterURL")) {
                        if (attrClusterURL != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrClusterURL = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("ClusterDescr")) {
                        if (attrClusterDescr != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrClusterDescr = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("SchemaName")) {
                        if (attrSchemaName != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrSchemaName = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("SchemaDescr")) {
                        if (attrSchemaDescr != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrSchemaDescr = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("ServerLoginKey")) {
                        if (attrServerLoginKey != null) {
                            throw CFLib.getDefaultExceptionFactory().newUniqueIndexViolationException(this.getClass(), "startElement", "LocalName", attrLocalName);
                        }
                        attrServerLoginKey = attrs.getValue(idxAttr);
                        continue;
                    }
                    if (attrLocalName.equals("schemaLocation")) continue;
                    throw CFLib.getDefaultExceptionFactory().newUnrecognizedAttributeException(this.getClass(), "startElement", this.getParser().getLocationInfo(), attrLocalName);
                }
                if (attrClusterURL == null || attrClusterURL.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "ClusterURL");
                }
                if (attrClusterDescr == null || attrClusterDescr.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "ClusterDescr");
                }
                if (attrSchemaName == null || attrSchemaName.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "SchemaName");
                }
                if (attrSchemaDescr == null || attrSchemaDescr.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "SchemaDescr");
                }
                if (attrServerLoginKey == null || attrServerLoginKey.length() <= 0) {
                    throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.getClass(), "startElement", 0, "ServerLoginKey");
                }
                CFTipServerInfo info = new CFTipServerInfo();
                info.setClusterURL(attrClusterURL);
                info.setClusterDescr(attrClusterDescr);
                info.setSchemaName(attrSchemaName);
                info.setSchemaDescr(attrSchemaDescr);
                info.setServerLoginKey(attrServerLoginKey);
                clientHandler.setServerInfo(info);
            }
            catch (RuntimeException e) {
                clientHandler.setServerInfo(null);
                throw e;
            }
            catch (Error e) {
                clientHandler.setServerInfo(null);
                throw e;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    public class CFTipSaxServerInfoRootHandler
    extends CFLibXmlCoreElementHandler {
        public CFTipSaxServerInfoRootHandler(CFTipClientHandler xmsgRqstHandler) {
            super(xmsgRqstHandler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

