/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.math.BigDecimal;
import java.text.Format;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFUInt64Editor
extends CFFormattedTextField {
    protected static Format defaultFormat = null;
    public static final BigDecimal MIN_VALUE = new BigDecimal("0");
    public static final BigDecimal MAX_VALUE = new BigDecimal("18446744073709551616");
    protected BigDecimal minValue = MIN_VALUE;
    protected BigDecimal maxValue = MAX_VALUE;
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public CFUInt64Editor() {
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setMinWidth(210.0);
        this.setMaxWidth(210.0);
        this.setPrefWidth(210.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal value) {
        String S_ProcName = "setMinValue";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "setMinValue", 1, "value");
        }
        if (value.compareTo(MIN_VALUE) < 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setMinValue", 1, "value", value, MIN_VALUE);
        }
        this.minValue = value;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal value) {
        String S_ProcName = "setMaxValue";
        if (value == null) {
            throw CFLib.getDefaultExceptionFactory().newNullArgumentException(this.fieldName, "setMaxValue", 1, "value");
        }
        if (value.compareTo(MAX_VALUE) > 0) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setMaxValue", 1, "value", value, MAX_VALUE);
        }
        this.maxValue = value;
    }

    public void setUInt64Value(BigDecimal value) {
        if (value == null) {
            this.setText("");
        } else {
            String text = value.toPlainString();
            this.setText(text);
        }
    }

    public BigDecimal getUInt64Value() {
        BigDecimal retval;
        String S_ProcName = "getUInt64Value";
        String text = this.getText();
        if (text == null || text.length() <= 0) {
            retval = null;
        } else {
            BigDecimal v = new BigDecimal(text);
            if (v.compareTo(this.minValue) < 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "getUInt64Value", 1, this.fieldName, v, this.minValue);
            }
            if (v.compareTo(this.maxValue) > 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "getUInt64Value", 1, this.fieldName, v, this.maxValue);
            }
            retval = v;
        }
        return retval;
    }
}

