/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX;

import java.text.DecimalFormat;
import java.text.Format;
import javafx.geometry.Pos;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.CFLib;
import net.sourceforge.msscodefactory.cflib.v2_9.CFLib.JavaFX.CFFormattedTextField;

public class CFUInt32Editor
extends CFFormattedTextField {
    protected static Format defaultFormat = null;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0x100000000L;
    protected long minValue = 0L;
    protected long maxValue = 0x100000000L;
    protected String fieldName = "?";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value == null || value.length() <= 0 ? "?" : value;
    }

    public static Format getDefaultFormat() {
        if (defaultFormat == null) {
            defaultFormat = new DecimalFormat("#########0");
        }
        return defaultFormat;
    }

    public CFUInt32Editor() {
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setMinWidth(110.0);
        this.setMaxWidth(110.0);
        this.setPrefWidth(110.0);
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long value) {
        if (value < 0L) {
            throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "setMinValue", 1, "value", value, 0L);
        }
        this.minValue = value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long value) {
        if (value > 0x100000000L) {
            throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "setMaxValue", 1, "value", value, 0x100000000L);
        }
        this.maxValue = value;
    }

    public void setUInt32Value(Long value) {
        if (value == null) {
            this.setText("");
        } else {
            String text = CFUInt32Editor.getDefaultFormat().format(value);
            this.setText(text);
        }
    }

    public Long getUInt32Value() {
        Long retval;
        String S_ProcName = "getUInt32Value";
        String text = this.getText();
        if (text == null || text.length() <= 0) {
            retval = null;
        } else {
            Long v = Long.valueOf(text);
            if (v == null) {
                throw CFLib.getDefaultExceptionFactory().newInvalidArgumentException(this.fieldName, "getUInt32Value", 0, "text", (Object)text);
            }
            if (v.compareTo(this.minValue) < 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentUnderflowException(this.fieldName, "getUInt32Value", 1, this.fieldName, (long)v, this.minValue);
            }
            if (v.compareTo(this.maxValue) > 0) {
                throw CFLib.getDefaultExceptionFactory().newArgumentOverflowException(this.fieldName, "getUInt32Value", 1, this.fieldName, (long)v, this.maxValue);
            }
            retval = v;
        }
        return retval;
    }
}

